/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.multi;

import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.operators.AbstractMulti;
import io.smallrye.mutiny.operators.multi.MultiFlatMapOp;
import io.smallrye.mutiny.operators.multi.builders.CollectionBasedMulti;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.function.Function;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;

public final class MultiMergeOp<T>
extends AbstractMulti<T> {
    private final List<Publisher<? extends T>> upstreams;
    private final boolean postponeFailurePropagation;
    private final int maxConcurrency;
    private final int prefetch;
    private final Supplier<? extends Queue<T>> mainQueueSupplier;
    private final Supplier<? extends Queue<T>> innerQueueSupplier;

    public MultiMergeOp(List<Publisher<? extends T>> upstreams, boolean postponeFailurePropagation, int maxConcurrency, int prefetch, Supplier<? extends Queue<T>> mainQueueSupplier, Supplier<? extends Queue<T>> innerQueueSupplier) {
        this.upstreams = Collections.unmodifiableList(ParameterValidation.doesNotContainNull(upstreams, "upstreams"));
        this.postponeFailurePropagation = postponeFailurePropagation;
        this.prefetch = ParameterValidation.positive(prefetch, "prefetch");
        this.maxConcurrency = ParameterValidation.positive(maxConcurrency, "maxConcurrency");
        this.mainQueueSupplier = ParameterValidation.nonNull(mainQueueSupplier, "mainQueueSupplier");
        this.innerQueueSupplier = ParameterValidation.nonNull(innerQueueSupplier, "innerQueueSupplier");
    }

    @Override
    public void subscribe(Subscriber<? super T> actual) {
        MultiFlatMapOp.FlatMapMainSubscriber merger = new MultiFlatMapOp.FlatMapMainSubscriber(actual, Function.identity(), this.postponeFailurePropagation, this.maxConcurrency, this.mainQueueSupplier, this.innerQueueSupplier);
        merger.onSubscribe(new CollectionBasedMulti.CollectionSubscription<Publisher<? extends T>>(merger, this.upstreams));
    }

    @Override
    protected Publisher<T> publisher() {
        return this;
    }
}

