/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.multi;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.operators.multi.AbstractMultiOperator;
import io.smallrye.mutiny.operators.multi.MultiOperatorProcessor;
import java.util.function.Predicate;
import org.reactivestreams.Subscriber;

public class MultiFilterOp<T>
extends AbstractMultiOperator<T, T> {
    private final Predicate<? super T> predicate;

    public MultiFilterOp(Multi<? extends T> upstream, Predicate<? super T> predicate) {
        super(upstream);
        this.predicate = ParameterValidation.nonNull(predicate, "predicate");
    }

    @Override
    public void subscribe(Subscriber<? super T> downstream) {
        if (downstream == null) {
            throw new NullPointerException("The subscriber must not be `null`");
        }
        this.upstream.subscribe(new MultiFilterProcessor<T>(downstream, this.predicate));
    }

    static final class MultiFilterProcessor<T>
    extends MultiOperatorProcessor<T, T> {
        private final Predicate<? super T> predicate;

        MultiFilterProcessor(Subscriber<? super T> downstream, Predicate<? super T> predicate) {
            super(downstream);
            this.predicate = predicate;
        }

        public void onNext(T t) {
            boolean passed;
            if (this.isDone()) {
                return;
            }
            try {
                passed = this.predicate.test(t);
            }
            catch (Throwable exception) {
                this.failAndCancel(exception);
                return;
            }
            if (passed) {
                this.downstream.onNext(t);
            } else {
                this.request(1L);
            }
        }
    }
}

