/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.operators.MultiOperator;
import io.smallrye.mutiny.operators.multi.MultiOnFailureResumeOp;
import java.util.function.Function;
import java.util.function.Predicate;
import org.reactivestreams.Publisher;

public class MultiMapOnFailure<T>
extends MultiOperator<T, T> {
    private final Predicate<? super Throwable> predicate;
    private final Function<? super Throwable, ? extends Throwable> mapper;

    public MultiMapOnFailure(Multi<T> upstream, Predicate<? super Throwable> predicate, Function<? super Throwable, ? extends Throwable> mapper) {
        super(ParameterValidation.nonNull(upstream, "upstream"));
        this.predicate = predicate == null ? x -> true : predicate;
        this.mapper = ParameterValidation.nonNull(mapper, "mapper");
    }

    @Override
    protected Publisher<T> publisher() {
        Function<Throwable, Publisher> next = failure -> {
            if (this.predicate.test((Throwable)failure)) {
                Throwable throwable = this.mapper.apply((Throwable)failure);
                if (throwable == null) {
                    return Multi.createFrom().failure(new NullPointerException("The mapper returned `null`"));
                }
                return Multi.createFrom().failure(throwable);
            }
            return Multi.createFrom().failure((Throwable)failure);
        };
        return new MultiOnFailureResumeOp(this.upstream(), next);
    }
}

