/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.helpers;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.operators.multi.processors.UnicastProcessor;
import io.smallrye.mutiny.subscription.MultiEmitter;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Processor;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class MultiEmitterProcessor<T>
implements Processor<T, T>,
MultiEmitter<T> {
    private final UnicastProcessor<T> processor;
    private final AtomicReference<Runnable> onTermination = new AtomicReference();

    private MultiEmitterProcessor() {
        this.processor = UnicastProcessor.create();
    }

    public static <T> MultiEmitterProcessor<T> create() {
        return new MultiEmitterProcessor<T>();
    }

    @Override
    public MultiEmitter<T> emit(T item) {
        this.onNext(item);
        return this;
    }

    @Override
    public void fail(Throwable failure) {
        this.onError(failure);
    }

    @Override
    public void complete() {
        this.onComplete();
    }

    @Override
    public MultiEmitter<T> onTermination(Runnable onTermination) {
        this.onTermination.set(onTermination);
        return this;
    }

    public void subscribe(final Subscriber<? super T> subscriber) {
        this.processor.subscribe(new Subscriber<T>(){

            public void onSubscribe(final Subscription subscription) {
                subscriber.onSubscribe(new Subscription(){

                    public void request(long l) {
                        subscription.request(l);
                    }

                    public void cancel() {
                        subscription.cancel();
                        MultiEmitterProcessor.this.fireTermination();
                    }
                });
            }

            public void onNext(T item) {
                subscriber.onNext(item);
            }

            public void onError(Throwable failure) {
                subscriber.onError(failure);
                MultiEmitterProcessor.this.fireTermination();
            }

            public void onComplete() {
                subscriber.onComplete();
                MultiEmitterProcessor.this.fireTermination();
            }
        });
    }

    private void fireTermination() {
        Runnable runnable = this.onTermination.getAndSet(null);
        if (runnable != null) {
            runnable.run();
        }
    }

    public void onSubscribe(Subscription subscription) {
        this.processor.onSubscribe(subscription);
    }

    public void onNext(T item) {
        this.processor.onNext(item);
    }

    public void onError(Throwable failure) {
        this.processor.onError(failure);
    }

    public void onComplete() {
        this.processor.onComplete();
    }

    public Multi<T> toMulti() {
        return Multi.createFrom().publisher(this);
    }
}

