/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.groups;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.operators.MultiTransformation;
import io.smallrye.mutiny.operators.multi.MultiFilterOp;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Function;
import java.util.function.Predicate;
import org.reactivestreams.Publisher;

public class MultiTransform<T> {
    private final Multi<T> upstream;

    public MultiTransform(Multi<T> upstream) {
        this.upstream = upstream;
    }

    public Multi<T> bySkippingFirstItems(long number) {
        return MultiTransformation.skipFirst(this.upstream, ParameterValidation.positiveOrZero(number, "number"));
    }

    public Multi<T> bySkippingLastItems(int number) {
        return MultiTransformation.skipLast(this.upstream, ParameterValidation.positiveOrZero(number, "number"));
    }

    public Multi<T> bySkippingItemsWhile(Predicate<? super T> predicate) {
        return MultiTransformation.skipWhile(this.upstream, ParameterValidation.nonNull(predicate, "predicate"));
    }

    public Multi<T> bySkippingItemsFor(Duration duration) {
        return MultiTransformation.skipForDuration(this.upstream, ParameterValidation.validate(duration, "duration"));
    }

    public Multi<T> byTakingFirstItems(long number) {
        return MultiTransformation.takeFirst(this.upstream, ParameterValidation.positiveOrZero(number, "number"));
    }

    public Multi<T> byTakingLastItems(int number) {
        return MultiTransformation.takeLast(this.upstream, ParameterValidation.positiveOrZero(number, "number"));
    }

    public Multi<T> byTakingItemsFor(Duration duration) {
        return MultiTransformation.takeForDuration(this.upstream, ParameterValidation.validate(duration, "duration"));
    }

    public Multi<T> byTakingItemsWhile(Predicate<? super T> predicate) {
        return MultiTransformation.takeWhile(this.upstream, ParameterValidation.nonNull(predicate, "predicate"));
    }

    public Multi<T> byDroppingDuplicates() {
        return MultiTransformation.distinct(this.upstream);
    }

    public Multi<T> byDroppingRepetitions() {
        return MultiTransformation.dropRepetitions(this.upstream);
    }

    @SafeVarargs
    public final Multi<T> byMergingWith(Publisher<T> ... publishers) {
        ArrayList list = new ArrayList();
        list.add(this.upstream);
        list.addAll(Arrays.asList((Object[])ParameterValidation.nonNull(publishers, "publishers")));
        return Multi.createBy().merging().streams(list);
    }

    public Multi<T> byMergingWith(Iterable<Publisher<T>> iterable) {
        ArrayList list = new ArrayList();
        list.add(this.upstream);
        ParameterValidation.nonNull(iterable, "produceIterable").forEach(list::add);
        return Multi.createBy().merging().streams(list);
    }

    public Multi<T> byFilteringItemsWith(Predicate<? super T> predicate) {
        return new MultiFilterOp<T>(this.upstream, ParameterValidation.nonNull(predicate, "predicate"));
    }

    public Multi<T> byTestingItemsWith(Function<? super T, ? extends Uni<Boolean>> tester) {
        ParameterValidation.nonNull(tester, "tester");
        return this.upstream.onItem().produceMulti(res -> {
            Uni uni = (Uni)tester.apply(res);
            return uni.map(pass -> {
                if (pass.booleanValue()) {
                    return res;
                }
                return null;
            }).toMulti();
        }).concatenate();
    }
}

