/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny;

import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.groups.MultiBroadcast;
import io.smallrye.mutiny.groups.MultiCollect;
import io.smallrye.mutiny.groups.MultiConvert;
import io.smallrye.mutiny.groups.MultiCreate;
import io.smallrye.mutiny.groups.MultiCreateBy;
import io.smallrye.mutiny.groups.MultiGroup;
import io.smallrye.mutiny.groups.MultiOnCompletion;
import io.smallrye.mutiny.groups.MultiOnEvent;
import io.smallrye.mutiny.groups.MultiOnFailure;
import io.smallrye.mutiny.groups.MultiOnItem;
import io.smallrye.mutiny.groups.MultiOverflow;
import io.smallrye.mutiny.groups.MultiSubscribe;
import io.smallrye.mutiny.groups.MultiTransform;
import io.smallrye.mutiny.helpers.ParameterValidation;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.function.Predicate;
import org.reactivestreams.Publisher;

public interface Multi<T>
extends Publisher<T> {
    public static MultiCreate createFrom() {
        return MultiCreate.INSTANCE;
    }

    public static MultiCreateBy createBy() {
        return MultiCreateBy.INSTANCE;
    }

    public MultiSubscribe<T> subscribe();

    public MultiOnItem<T> onItem();

    public Uni<T> toUni();

    public MultiOnFailure<T> onFailure();

    public MultiOnFailure<T> onFailure(Predicate<? super Throwable> var1);

    public MultiOnFailure<T> onFailure(Class<? extends Throwable> var1);

    public MultiOnEvent<T> on();

    public Multi<T> cache();

    public MultiCollect<T> collectItems();

    public MultiGroup<T> groupItems();

    public Multi<T> emitOn(Executor var1);

    public Multi<T> subscribeOn(Executor var1);

    public MultiOnCompletion<T> onCompletion();

    public MultiTransform<T> transform();

    public MultiOverflow<T> onOverflow();

    public MultiBroadcast<T> broadcast();

    public MultiConvert<T> convert();

    default public <O> Multi<O> map(Function<? super T, ? extends O> mapper) {
        return this.onItem().apply(ParameterValidation.nonNull(mapper, "mapper"));
    }

    default public <O> Multi<O> flatMap(Function<? super T, ? extends Publisher<? extends O>> mapper) {
        return this.onItem().producePublisher(mapper).merge();
    }

    default public <O> Multi<O> concatMap(Function<? super T, ? extends Publisher<? extends O>> mapper) {
        return this.onItem().producePublisher(mapper).concatenate();
    }
}

