/*
 * Decompiled with CFR 0.152.
 */
package mutiny.zero.internal;

import java.util.Objects;
import java.util.function.Consumer;
import mutiny.zero.BackpressureStrategy;
import mutiny.zero.Tube;
import mutiny.zero.internal.BufferingTube;
import mutiny.zero.internal.DroppingTube;
import mutiny.zero.internal.ErroringTube;
import mutiny.zero.internal.IgnoringTube;
import mutiny.zero.internal.LatestTube;
import mutiny.zero.internal.TubeBase;
import mutiny.zero.internal.UnbounbedBufferingTube;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;

public class TubePublisher<T>
implements Publisher<T> {
    private final BackpressureStrategy backpressureStrategy;
    private final int bufferSize;
    private final Consumer<Tube<T>> tubeConsumer;

    public TubePublisher(BackpressureStrategy backpressureStrategy, int bufferSize, Consumer<Tube<T>> tubeConsumer) {
        this.backpressureStrategy = backpressureStrategy;
        this.bufferSize = bufferSize;
        this.tubeConsumer = tubeConsumer;
    }

    public void subscribe(Subscriber<? super T> subscriber) {
        Objects.requireNonNull(subscriber, "The subscriber cannot be null");
        TubeBase tube = null;
        switch (this.backpressureStrategy) {
            case BUFFER: {
                tube = new BufferingTube<T>(subscriber, this.bufferSize);
                break;
            }
            case UNBOUNDED_BUFFER: {
                tube = new UnbounbedBufferingTube<T>(subscriber);
                break;
            }
            case DROP: {
                tube = new DroppingTube<T>(subscriber);
                break;
            }
            case ERROR: {
                tube = new ErroringTube<T>(subscriber);
                break;
            }
            case IGNORE: {
                tube = new IgnoringTube<T>(subscriber);
                break;
            }
            case LATEST: {
                tube = new LatestTube<T>(subscriber, this.bufferSize);
            }
        }
        subscriber.onSubscribe(tube);
        this.tubeConsumer.accept(tube);
    }
}

