/*
 * Decompiled with CFR 0.152.
 */
package mutiny.zero.internal;

import java.util.Objects;
import mutiny.zero.internal.AlreadyCompletedSubscription;
import mutiny.zero.internal.IteratorSubscription;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class IterablePublisher<T>
implements Publisher<T> {
    private final Iterable<T> iterable;

    public IterablePublisher(Iterable<T> iterable) {
        this.iterable = iterable;
    }

    public void subscribe(Subscriber<? super T> subscriber) {
        Objects.requireNonNull(subscriber, "The subscriber cannot be null");
        if (!this.iterable.iterator().hasNext()) {
            subscriber.onSubscribe((Subscription)new AlreadyCompletedSubscription());
            subscriber.onComplete();
        } else {
            subscriber.onSubscribe(new IteratorSubscription<T>(this.iterable.iterator(), subscriber));
        }
    }
}

