/*
 * Decompiled with CFR 0.152.
 */
package mutiny.zero;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import mutiny.zero.BackpressureStrategy;
import mutiny.zero.Tube;
import mutiny.zero.internal.CompletionStagePublisher;
import mutiny.zero.internal.EmptyPublisher;
import mutiny.zero.internal.FailurePublisher;
import mutiny.zero.internal.GeneratorPublisher;
import mutiny.zero.internal.IterablePublisher;
import mutiny.zero.internal.PublisherToCompletionStageSubscriber;
import mutiny.zero.internal.StreamPublisher;
import mutiny.zero.internal.TubePublisher;
import org.reactivestreams.Publisher;

public interface ZeroPublisher {
    @SafeVarargs
    public static <T> Publisher<T> fromItems(T ... items) {
        Objects.requireNonNull(items, "The items array cannot be null");
        return ZeroPublisher.fromIterable(Arrays.asList(items));
    }

    public static <T> Publisher<T> fromIterable(Iterable<T> iterable) {
        Objects.requireNonNull(iterable, "The iterable cannot be null");
        return new IterablePublisher<T>(iterable);
    }

    public static <T> Publisher<T> fromStream(Supplier<Stream<T>> supplier) {
        Objects.requireNonNull(supplier, "The supplier cannot be null");
        return new StreamPublisher<T>(supplier);
    }

    public static <S, T> Publisher<T> fromGenerator(Supplier<S> stateSupplier, Function<S, Iterator<T>> generator) {
        Objects.requireNonNull(stateSupplier, "The state supplier cannot be null");
        Objects.requireNonNull(generator, "The generator supplier cannot be null");
        return new GeneratorPublisher<S, T>(stateSupplier, generator);
    }

    public static <T> Publisher<T> fromCompletionStage(Supplier<CompletionStage<T>> completionStageSupplier) {
        Objects.requireNonNull(completionStageSupplier, "The CompletionStage supplier cannot be null");
        return new CompletionStagePublisher<T>(completionStageSupplier);
    }

    public static <T> CompletionStage<Optional<T>> toCompletionStage(Publisher<T> publisher) {
        Objects.requireNonNull(publisher, "The publisher cannot be null");
        CompletableFuture future = new CompletableFuture();
        publisher.subscribe(new PublisherToCompletionStageSubscriber(future));
        return future;
    }

    public static <T> Publisher<T> fromFailure(Throwable failure) {
        Objects.requireNonNull(failure, "The failure cannot be null");
        return new FailurePublisher(failure);
    }

    public static <T> Publisher<T> empty() {
        return new EmptyPublisher();
    }

    public static <T> Publisher<T> create(BackpressureStrategy backpressureStrategy, int bufferSize, Consumer<Tube<T>> tubeConsumer) {
        Objects.requireNonNull(backpressureStrategy, "The backpressure strategy cannot be null");
        Objects.requireNonNull(tubeConsumer, "The tube consumer cannot be null");
        if ((backpressureStrategy == BackpressureStrategy.BUFFER || backpressureStrategy == BackpressureStrategy.LATEST) && bufferSize <= 0) {
            throw new IllegalArgumentException("The buffer size must be strictly positive");
        }
        return new TubePublisher<T>(backpressureStrategy, bufferSize, tubeConsumer);
    }
}

