/*
 * Decompiled with CFR 0.152.
 */
package _08_misc;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.operators.multi.AbstractMultiOperator;
import io.smallrye.mutiny.operators.multi.MultiOperatorProcessor;
import io.smallrye.mutiny.subscription.MultiSubscriber;
import java.util.concurrent.ThreadLocalRandom;

public class _01_Multi_Custom_Operator {
    public static void main(String[] args) {
        System.out.println("\u26a1\ufe0f Custom operator, randomly drop items");
        Multi.createFrom().range(1, 20).plug(RandomDrop::new).subscribe().with(System.out::println);
    }

    static class RandomDrop<T>
    extends AbstractMultiOperator<T, T> {
        public RandomDrop(Multi<? extends T> upstream) {
            super(upstream);
        }

        public void subscribe(MultiSubscriber<? super T> downstream) {
            this.upstream.subscribe().withSubscriber((MultiSubscriber)new DropProcessor(downstream));
        }

        private class DropProcessor
        extends MultiOperatorProcessor<T, T> {
            DropProcessor(MultiSubscriber<? super T> downstream) {
                super(downstream);
            }

            public void onItem(T item) {
                if (ThreadLocalRandom.current().nextBoolean()) {
                    super.onItem(item);
                }
            }
        }
    }
}

