/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.streams.utils;

import io.smallrye.mutiny.helpers.Subscriptions;
import io.smallrye.mutiny.streams.utils.CancellationSubscriber;
import io.smallrye.mutiny.streams.utils.WrappedSubscription;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Processor;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class ConnectableProcessor<T>
implements Processor<T, T> {
    private final AtomicReference<Subscriber<? super T>> subscriber = new AtomicReference();
    private final AtomicReference<Subscription> subscription = new AtomicReference();
    private final AtomicReference<Throwable> failure = new AtomicReference();
    private final AtomicReference<State> state = new AtomicReference<State>(State.IDLE);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribe(Subscriber<? super T> subscriber) {
        Objects.requireNonNull(subscriber);
        if (!this.subscriber.compareAndSet(null, subscriber)) {
            Subscriptions.fail(subscriber, (Throwable)new IllegalStateException("Multicasting not supported"));
            return;
        }
        ConnectableProcessor connectableProcessor = this;
        synchronized (connectableProcessor) {
            if (!this.state.compareAndSet(State.IDLE, State.HAS_SUBSCRIBER)) {
                if (this.state.get() == State.FAILED) {
                    this.manageSubscribeInFailedState(subscriber);
                } else if (this.state.get() == State.COMPLETE) {
                    this.manageSubscribeInCompleteState(subscriber);
                } else if (this.state.get() == State.HAS_SUBSCRIPTION) {
                    this.manageSubscribeInTheHasSubscriptionState(subscriber);
                } else {
                    throw new IllegalStateException("Illegal transition - subscribe happened in the " + this.state.get().name() + " state");
                }
            }
        }
    }

    private void manageSubscribeInTheHasSubscriptionState(Subscriber<? super T> subscriber) {
        subscriber.onSubscribe((Subscription)new WrappedSubscription(this.subscription.get(), () -> this.subscriber.set(new CancellationSubscriber())));
        if (!this.state.compareAndSet(State.HAS_SUBSCRIPTION, State.PROCESSING)) {
            if (this.state.get() == State.FAILED) {
                subscriber.onError(this.failure.get());
            } else if (this.state.get() == State.COMPLETE) {
                subscriber.onComplete();
            } else {
                throw new IllegalStateException("Illegal transition - subscribe called in the " + this.state.get().name() + " state");
            }
        }
    }

    private void manageSubscribeInCompleteState(Subscriber<? super T> subscriber) {
        Subscriptions.complete(subscriber);
    }

    private void manageSubscribeInFailedState(Subscriber<? super T> subscriber) {
        Subscriptions.fail(subscriber, (Throwable)this.failure.get());
    }

    public void onSubscribe(Subscription subscription) {
        Objects.requireNonNull(subscription);
        if (!this.subscription.compareAndSet(null, subscription)) {
            subscription.cancel();
            return;
        }
        if (!this.state.compareAndSet(State.IDLE, State.HAS_SUBSCRIPTION)) {
            this.state.set(State.PROCESSING);
            this.subscriber.get().onSubscribe((Subscription)new WrappedSubscription(subscription, () -> this.subscriber.set(new CancellationSubscriber())));
        }
    }

    public void onNext(T item) {
        Objects.requireNonNull(item);
        Subscriber<? super T> actualSubscriber = this.subscriber.get();
        if (actualSubscriber == null) {
            throw new IllegalStateException("No subscriber - cannot handle onNext");
        }
        actualSubscriber.onNext(item);
    }

    public void onComplete() {
        if (this.state.get() == State.PROCESSING) {
            this.subscriber.get().onComplete();
            this.state.set(State.COMPLETE);
        } else {
            if (this.state.get() == State.FAILED || this.state.get() == State.COMPLETE || this.state.get() == State.IDLE) {
                throw new IllegalStateException("Invalid transition, cannot handle onComplete in " + this.state.get().name());
            }
            this.state.set(State.COMPLETE);
        }
    }

    public void onError(Throwable throwable) {
        Objects.requireNonNull(throwable);
        this.failure.set(throwable);
        if (this.state.get() == State.PROCESSING) {
            this.subscriber.get().onError(throwable);
            this.state.set(State.FAILED);
        } else {
            if (this.state.get() == State.FAILED || this.state.get() == State.COMPLETE || this.state.get() == State.IDLE) {
                throw new IllegalStateException("Invalid transition, cannot handle onError in " + this.state.get().name());
            }
            this.state.set(State.FAILED);
        }
    }

    private static enum State {
        IDLE,
        HAS_SUBSCRIBER,
        HAS_SUBSCRIPTION,
        PROCESSING,
        FAILED,
        COMPLETE;

    }
}

