/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.math;

import io.smallrye.mutiny.Multi;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;

public class AverageOperator<T extends Number>
implements Function<Multi<T>, Multi<Double>> {
    private final AtomicReference<State> state = new AtomicReference();

    @Override
    public Multi<Double> apply(Multi<T> multi) {
        return multi.onItem().transform(x -> {
            State newState = this.state.updateAndGet(s -> {
                if (s == null) {
                    return new State(x.doubleValue(), 1L);
                }
                return new State(x.doubleValue() + s.sum, s.count + 1L);
            });
            return newState.sum / (double)newState.count;
        }).onCompletion().ifEmpty().continueWith((Object[])new Double[]{0.0});
    }

    private static class State {
        double sum = 0.0;
        long count = 0L;

        State(double sum, long count) {
            this.sum = sum;
            this.count = count;
        }
    }
}

