/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config.source.hocon;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigList;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigValue;
import io.smallrye.common.classloader.ClassPathUtils;
import io.smallrye.config.common.MapBackedConfigSource;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.net.URL;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class HoconConfigSource
extends MapBackedConfigSource {
    private static final long serialVersionUID = -458821383311704657L;
    public static final String NAME = "HoconConfigSource[source=%s]";
    public static final int ORDINAL = 105;

    public HoconConfigSource(String name, Map<String, String> source, int ordinal) {
        super(name, source, ordinal, false);
    }

    public HoconConfigSource(URL url) throws IOException {
        this(url, 105);
    }

    public HoconConfigSource(URL url, int ordinal) throws IOException {
        this(String.format(NAME, url.toString()), (Map)ClassPathUtils.readStream((URL)url, inputStream -> {
            try {
                return HoconConfigSource.streamToMap(inputStream);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }), ordinal);
    }

    private static Map<String, String> streamToMap(InputStream inputStream) throws IOException {
        TreeMap<String, String> input = new TreeMap<String, String>();
        try (InputStreamReader reader = new InputStreamReader(inputStream);){
            Config config = ConfigFactory.parseReader((Reader)reader).resolve();
            input.putAll(HoconConfigSource.configToMap(config));
        }
        return input;
    }

    private static Map<String, String> configToMap(Config config) {
        TreeMap<String, String> properties = new TreeMap<String, String>();
        Set entries = config.entrySet();
        for (Map.Entry entry : entries) {
            HoconConfigSource.flatten((String)entry.getKey(), (ConfigValue)entry.getValue(), properties);
        }
        return properties;
    }

    private static void flatten(String path, ConfigValue value, Map<String, String> target) {
        if (value instanceof ConfigObject) {
            HoconConfigSource.flattenObject(path, (ConfigObject)value, target);
        } else if (value instanceof ConfigList) {
            HoconConfigSource.flattenList(path, (ConfigList)value, target);
        } else {
            target.put(path, value.unwrapped().toString());
        }
    }

    private static void flattenObject(String path, ConfigObject value, Map<String, String> target) {
        for (Map.Entry entry : value.entrySet()) {
            HoconConfigSource.flatten(path + "." + (String)entry.getKey(), (ConfigValue)entry.getValue(), target);
        }
    }

    private static void flattenList(String path, ConfigList value, Map<String, String> target) {
        int valueSize = value.size();
        for (int i = 0; i < valueSize; ++i) {
            HoconConfigSource.flatten(path + "[" + i + "]", (ConfigValue)value.get(i), target);
        }
    }
}

