/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config.crypto;

import io.smallrye.config.ConfigMessages;
import io.smallrye.config.ConfigSourceContext;
import io.smallrye.config.ConfigValue;
import io.smallrye.config.Converters;
import io.smallrye.config.SecretKeysHandler;
import io.smallrye.config.SecretKeysHandlerFactory;
import io.smallrye.config.crypto.AESGCMNoPaddingSecretKeysHandler;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.NoSuchElementException;

public class AESGCMNoPaddingSecretKeysHandlerFactory
implements SecretKeysHandlerFactory {
    public static final String ENCRYPTION_KEY = "smallrye.config.secret-handler.aes-gcm-nopadding.encryption-key";

    public SecretKeysHandler getSecretKeysHandler(ConfigSourceContext context) {
        return new SecretKeysHandlerFactory.LazySecretKeysHandler(new SecretKeysHandlerFactory(){

            public SecretKeysHandler getSecretKeysHandler(ConfigSourceContext context) {
                ConfigValue encryptionKey = context.getValue(AESGCMNoPaddingSecretKeysHandlerFactory.ENCRYPTION_KEY);
                if (encryptionKey == null || encryptionKey.getValue() == null) {
                    throw new NoSuchElementException(ConfigMessages.msg.propertyNotFound(AESGCMNoPaddingSecretKeysHandlerFactory.ENCRYPTION_KEY));
                }
                boolean decode = false;
                ConfigValue plain = context.getValue("smallrye.config.secret-handler.aes-gcm-nopadding.encryption-key-decode");
                if (plain != null && plain.getValue() != null) {
                    decode = (Boolean)Converters.getImplicitConverter(Boolean.class).convert(plain.getValue());
                }
                byte[] encryptionKeyBytes = decode ? Base64.getUrlDecoder().decode(encryptionKey.getValue()) : encryptionKey.getValue().getBytes(StandardCharsets.UTF_8);
                return new AESGCMNoPaddingSecretKeysHandler(encryptionKeyBytes);
            }

            public String getName() {
                return AESGCMNoPaddingSecretKeysHandlerFactory.this.getName();
            }
        });
    }

    public String getName() {
        return "aes-gcm-nopadding";
    }
}

