/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import io.smallrye.config.ConfigMapping;
import io.smallrye.config.ConfigMappingClassMapper;
import io.smallrye.config.ConfigMappingContext;
import io.smallrye.config.ConfigMappingInterface;
import io.smallrye.config.Secret;
import io.smallrye.config.WithConverter;
import io.smallrye.config.WithDefault;
import io.smallrye.config.WithName;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.eclipse.microprofile.config.inject.ConfigProperties;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class ConfigMappingGenerator {
    static final boolean usefulDebugInfo;
    private static final Pattern ARRAY_FORMAT_REGEX;
    private static final String I_CLASS;
    private static final String I_FIELD;
    private static final String I_MAPPING_CONTEXT;
    private static final String I_OBJECT_CREATOR;
    private static final String I_NAMING_STRATEGY;
    private static final String I_STRING_BUILDER;
    private static final String I_RUNTIME_EXCEPTION;
    private static final String I_OBJECT;
    private static final String I_STRING;
    private static final String I_OPTIONAL;
    private static final String I_COLLECTION;
    private static final String I_MAP;
    private static final String I_ITERABLE;
    private static final String I_SECRET;
    private static final int V_THIS = 0;
    private static final int V_MAPPING_CONTEXT = 1;
    private static final int V_STRING_BUILDER = 2;
    private static final int V_LENGTH = 3;
    private static final int V_NAMING_FUNCTION = 4;

    static byte[] generate(ConfigMappingInterface mapping) {
        ClassWriter writer = new ClassWriter(3);
        Object visitor = usefulDebugInfo ? new Debugging.ClassVisitorImpl(writer) : writer;
        visitor.visit(52, 1, mapping.getClassInternalName(), null, I_OBJECT, new String[]{Type.getInternalName(mapping.getInterfaceType())});
        visitor.visitSource(null, null);
        MethodVisitor noArgsCtor = visitor.visitMethod(1, "<init>", "()V", null, null);
        noArgsCtor.visitVarInsn(25, 0);
        noArgsCtor.visitMethodInsn(183, I_OBJECT, "<init>", "()V", false);
        noArgsCtor.visitInsn(177);
        noArgsCtor.visitEnd();
        noArgsCtor.visitMaxs(0, 0);
        MethodVisitor ctor = visitor.visitMethod(1, "<init>", "(L" + I_MAPPING_CONTEXT + ";)V", null, null);
        ctor.visitParameter("context", 16);
        Label ctorStart = new Label();
        Label ctorEnd = new Label();
        ctor.visitLabel(ctorStart);
        ctor.visitVarInsn(25, 0);
        ctor.visitMethodInsn(183, I_OBJECT, "<init>", "()V", false);
        ctor.visitVarInsn(25, 1);
        ctor.visitMethodInsn(182, I_MAPPING_CONTEXT, "getNameBuilder", "()L" + I_STRING_BUILDER + ';', false);
        ctor.visitInsn(89);
        Label ctorSbStart = new Label();
        ctor.visitLabel(ctorSbStart);
        ctor.visitVarInsn(58, 2);
        ctor.visitMethodInsn(182, I_STRING_BUILDER, "length", "()I", false);
        Label ctorLenStart = new Label();
        ctor.visitLabel(ctorLenStart);
        ctor.visitVarInsn(54, 3);
        Label ctorNfStart = new Label();
        ctor.visitLabel(ctorNfStart);
        if (mapping.hasConfigMapping()) {
            ctor.visitVarInsn(25, 1);
            ctor.visitFieldInsn(178, I_NAMING_STRATEGY, mapping.getNamingStrategy().name(), "L" + I_NAMING_STRATEGY + ";");
            ctor.visitMethodInsn(182, I_MAPPING_CONTEXT, "applyNamingStrategy", "(L" + I_NAMING_STRATEGY + ";)V", false);
            ctor.visitVarInsn(25, 1);
            ctor.visitInsn(mapping.isBeanStyleGetters() ? 4 : 3);
            ctor.visitMethodInsn(184, "java/lang/Boolean", "valueOf", "(Z)Ljava/lang/Boolean;", false);
            ctor.visitMethodInsn(182, I_MAPPING_CONTEXT, "applyBeanStyleGetters", "(Ljava/lang/Boolean;)V", false);
        }
        ctor.visitVarInsn(25, 1);
        ctor.visitMethodInsn(182, I_MAPPING_CONTEXT, "propertyName", "()Ljava/util/function/Function;", false);
        ctor.visitVarInsn(58, 4);
        ConfigMappingGenerator.addProperties((ClassVisitor)visitor, ctor, mapping);
        ctor.visitInsn(177);
        ctor.visitLabel(ctorEnd);
        ctor.visitLocalVariable("mc", 'L' + I_MAPPING_CONTEXT + ';', null, ctorStart, ctorEnd, 1);
        ctor.visitLocalVariable("sb", 'L' + I_STRING_BUILDER + ';', null, ctorSbStart, ctorEnd, 2);
        ctor.visitLocalVariable("len", "I", null, ctorLenStart, ctorEnd, 3);
        ctor.visitLocalVariable("nf", "Ljava/util/function/Function;", null, ctorNfStart, ctorEnd, 4);
        ctor.visitEnd();
        ctor.visitMaxs(0, 0);
        visitor.visitEnd();
        ConfigMappingGenerator.generateStaticInit((ClassVisitor)visitor, mapping);
        ConfigMappingGenerator.generateEquals((ClassVisitor)visitor, mapping);
        ConfigMappingGenerator.generateHashCode((ClassVisitor)visitor, mapping);
        ConfigMappingGenerator.generateToString((ClassVisitor)visitor, mapping);
        return writer.toByteArray();
    }

    static byte[] generate(Class<?> classType, String interfaceName) {
        Field[] declaredFields;
        Object classInstance;
        String classInternalName = Type.getInternalName(classType);
        String interfaceInternalName = interfaceName.replace('.', '/');
        ClassWriter writer = new ClassWriter(3);
        writer.visit(52, 1537, interfaceInternalName, null, I_OBJECT, new String[]{Type.getInternalName(ConfigMappingClassMapper.class)});
        AnnotationVisitor av = writer.visitAnnotation("L" + Type.getInternalName(ConfigMapping.class) + ";", true);
        av.visitEnum("namingStrategy", "L" + Type.getInternalName(ConfigMapping.NamingStrategy.class) + ";", ConfigMapping.NamingStrategy.VERBATIM.toString());
        if (classType.isAnnotationPresent(ConfigProperties.class)) {
            av.visit("prefix", (Object)classType.getAnnotation(ConfigProperties.class).prefix());
        }
        av.visitEnd();
        try {
            classInstance = classType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        for (Field declaredField : declaredFields = classType.getDeclaredFields()) {
            AnnotationVisitor av2;
            AnnotationVisitor av3;
            MethodVisitor mv = writer.visitMethod(1025, declaredField.getName(), Type.getMethodDescriptor((Type)Type.getType(declaredField.getType()), (Type[])new Type[0]), ConfigMappingGenerator.getSignature(declaredField), null);
            boolean hasDefault = false;
            if (declaredField.isAnnotationPresent(WithName.class)) {
                av3 = mv.visitAnnotation("L" + Type.getInternalName(WithName.class) + ";", true);
                av3.visit("value", (Object)declaredField.getAnnotation(WithName.class).value());
                av3.visitEnd();
            }
            if (declaredField.isAnnotationPresent(WithDefault.class)) {
                av3 = mv.visitAnnotation("L" + Type.getInternalName(WithDefault.class) + ";", true);
                av3.visit("value", (Object)declaredField.getAnnotation(WithDefault.class).value());
                av3.visitEnd();
                hasDefault = true;
            }
            if (declaredField.isAnnotationPresent(WithConverter.class)) {
                av3 = mv.visitAnnotation("L" + Type.getInternalName(WithConverter.class) + ";", true);
                av3.visit("value", declaredField.getAnnotation(WithConverter.class).value());
                av3.visitEnd();
            }
            if (declaredField.isAnnotationPresent(ConfigProperty.class)) {
                ConfigProperty configProperty = declaredField.getAnnotation(ConfigProperty.class);
                if (!configProperty.name().isEmpty()) {
                    av2 = mv.visitAnnotation("L" + Type.getInternalName(WithName.class) + ";", true);
                    av2.visit("value", (Object)configProperty.name());
                    av2.visitEnd();
                }
                if (!configProperty.defaultValue().equals("org.eclipse.microprofile.config.configproperty.unconfigureddvalue")) {
                    av2 = mv.visitAnnotation("L" + Type.getInternalName(WithDefault.class) + ";", true);
                    av2.visit("value", (Object)configProperty.defaultValue());
                    av2.visitEnd();
                    hasDefault = true;
                }
            }
            if (!hasDefault) {
                try {
                    declaredField.setAccessible(true);
                    Object defaultValue = declaredField.get(classInstance);
                    if (ConfigMappingGenerator.hasDefaultValue(declaredField.getType(), defaultValue)) {
                        av2 = mv.visitAnnotation("L" + Type.getInternalName(WithDefault.class) + ";", true);
                        av2.visit("value", (Object)defaultValue.toString());
                        av2.visitEnd();
                    }
                }
                catch (IllegalAccessException defaultValue) {
                    // empty catch block
                }
            }
            mv.visitEnd();
        }
        MethodVisitor ctor = writer.visitMethod(1, "map", "()L" + I_OBJECT + ";", null, null);
        Label ctorStart = new Label();
        ctor.visitLabel(ctorStart);
        ctor.visitTypeInsn(187, classInternalName);
        ctor.visitInsn(89);
        ctor.visitMethodInsn(183, classInternalName, "<init>", "()V", false);
        ctor.visitVarInsn(58, 1);
        for (Field declaredField : declaredFields) {
            if (Modifier.isStatic(declaredField.getModifiers()) || Modifier.isVolatile(declaredField.getModifiers()) || Modifier.isFinal(declaredField.getModifiers())) continue;
            String name = declaredField.getName();
            Class<?> type = declaredField.getType();
            if (Modifier.isPublic(declaredField.getModifiers())) {
                ctor.visitVarInsn(25, 1);
                ctor.visitVarInsn(25, 0);
                ctor.visitMethodInsn(185, interfaceInternalName, name, Type.getMethodDescriptor((Type)Type.getType(type), (Type[])new Type[0]), true);
                ctor.visitFieldInsn(181, classInternalName, name, Type.getDescriptor(type));
                continue;
            }
            ctor.visitLdcInsn((Object)Type.getType(classType));
            ctor.visitLdcInsn((Object)name);
            ctor.visitMethodInsn(182, I_CLASS, "getDeclaredField", Type.getMethodDescriptor((Type)Type.getType(Field.class), (Type[])new Type[]{Type.getType(String.class)}), false);
            ctor.visitVarInsn(58, 2);
            ctor.visitVarInsn(25, 2);
            ctor.visitInsn(4);
            ctor.visitMethodInsn(182, I_FIELD, "setAccessible", "(Z)V", false);
            ctor.visitVarInsn(25, 2);
            ctor.visitVarInsn(25, 1);
            ctor.visitVarInsn(25, 0);
            ctor.visitMethodInsn(185, interfaceInternalName, name, Type.getMethodDescriptor((Type)Type.getType(type), (Type[])new Type[0]), true);
            switch (Type.getType(type).getSort()) {
                case 1: {
                    ctor.visitMethodInsn(184, "java/lang/Boolean", "valueOf", "(Z)Ljava/lang/Boolean;", false);
                    break;
                }
                case 3: {
                    ctor.visitMethodInsn(184, "java/lang/Byte", "valueOf", "(B)Ljava/lang/Byte;", false);
                    break;
                }
                case 2: {
                    ctor.visitMethodInsn(184, "java/lang/Character", "valueOf", "(C)Ljava/lang/Character;", false);
                    break;
                }
                case 4: {
                    ctor.visitMethodInsn(184, "java/lang/Short", "valueOf", "(S)Ljava/lang/Short;", false);
                    break;
                }
                case 5: {
                    ctor.visitMethodInsn(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;", false);
                    break;
                }
                case 6: {
                    ctor.visitMethodInsn(184, "java/lang/Float", "valueOf", "(F)Ljava/lang/Float;", false);
                    break;
                }
                case 7: {
                    ctor.visitMethodInsn(184, "java/lang/Long", "valueOf", "(J)Ljava/lang/Long;", false);
                    break;
                }
                case 8: {
                    ctor.visitMethodInsn(184, "java/lang/Double", "valueOf", "(D)Ljava/lang/Double;", false);
                }
            }
            ctor.visitMethodInsn(182, I_FIELD, "set", Type.getMethodDescriptor((Type)Type.getType(Void.TYPE), (Type[])new Type[]{Type.getType(Object.class), Type.getType(Object.class)}), false);
        }
        ctor.visitVarInsn(25, 1);
        ctor.visitInsn(176);
        ctor.visitMaxs(2, 2);
        writer.visitEnd();
        return writer.toByteArray();
    }

    private static void addProperties(ClassVisitor cv, MethodVisitor ctor, ConfigMappingInterface mapping) {
        String memberName;
        Method method;
        for (ConfigMappingInterface.Property property : mapping.getProperties()) {
            method = property.getMethod();
            memberName = method.getName();
            String fieldType = Type.getInternalName(method.getReturnType());
            String fieldDesc = Type.getDescriptor(method.getReturnType());
            cv.visitField(2, memberName, fieldDesc, null, null);
            MethodVisitor mv = cv.visitMethod(1, memberName, "()" + fieldDesc, null, null);
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, mapping.getClassInternalName(), memberName, fieldDesc);
            mv.visitInsn(ConfigMappingGenerator.getReturnInstruction(property));
            mv.visitEnd();
            mv.visitMaxs(0, 0);
            if (property.isDefaultMethod()) continue;
            Label _try = new Label();
            Label _catch = new Label();
            Label _continue = new Label();
            ctor.visitTryCatchBlock(_try, _catch, _catch, I_RUNTIME_EXCEPTION);
            ctor.visitLabel(_try);
            ctor.visitVarInsn(25, 0);
            ConfigMappingGenerator.generateProperty(ctor, property);
            if (property.isPrimitive()) {
                ConfigMappingInterface.PrimitiveProperty primitive = property.asPrimitive();
                ctor.visitTypeInsn(192, Type.getInternalName(primitive.getBoxType()));
                ctor.visitMethodInsn(182, Type.getInternalName(primitive.getBoxType()), primitive.getUnboxMethodName(), primitive.getUnboxMethodDescriptor(), false);
            } else {
                ctor.visitTypeInsn(192, fieldType);
            }
            ctor.visitFieldInsn(181, mapping.getClassInternalName(), memberName, fieldDesc);
            ctor.visitJumpInsn(167, _continue);
            ctor.visitLabel(_catch);
            ctor.visitVarInsn(25, 1);
            ctor.visitInsn(95);
            ctor.visitMethodInsn(182, I_MAPPING_CONTEXT, "reportProblem", "(L" + I_RUNTIME_EXCEPTION + ";)V", false);
            ctor.visitJumpInsn(167, _continue);
            ctor.visitLabel(_continue);
            ConfigMappingGenerator.restoreLength(ctor);
        }
        for (ConfigMappingInterface.Property property : mapping.getProperties()) {
            method = property.getMethod();
            memberName = method.getName();
            String fieldDesc = Type.getDescriptor(method.getReturnType());
            if (!property.isDefaultMethod()) continue;
            ctor.visitVarInsn(25, 0);
            Method defaultMethod = property.asDefaultMethod().getDefaultMethod();
            ctor.visitVarInsn(25, 0);
            ctor.visitMethodInsn(184, Type.getInternalName(defaultMethod.getDeclaringClass()), defaultMethod.getName(), "(" + Type.getType(mapping.getInterfaceType()) + ")" + fieldDesc, false);
            ctor.visitFieldInsn(181, mapping.getClassInternalName(), memberName, fieldDesc);
        }
    }

    private static void generateProperty(MethodVisitor ctor, ConfigMappingInterface.Property property) {
        ConfigMappingGenerator.appendPropertyName(ctor, property);
        if (property.isPrimitive()) {
            ConfigMappingGenerator.toStringPropertyName(ctor);
            ConfigMappingInterface.PrimitiveProperty propertyPrimitive = property.asPrimitive();
            ctor.visitLdcInsn((Object)Type.getType(propertyPrimitive.getBoxType()));
            if (property.hasConvertWith()) {
                ctor.visitLdcInsn((Object)Type.getType(propertyPrimitive.getConvertWith()));
            } else {
                ctor.visitInsn(1);
            }
            ctor.visitMethodInsn(184, I_OBJECT_CREATOR, "value", "(L" + I_MAPPING_CONTEXT + ";L" + I_STRING + ";L" + I_CLASS + ";L" + I_CLASS + ";)L" + I_OBJECT + ";", false);
        } else if (property.isLeaf() && !property.isOptional()) {
            ConfigMappingGenerator.toStringPropertyName(ctor);
            ConfigMappingInterface.LeafProperty leafProperty = property.asLeaf();
            ctor.visitLdcInsn((Object)Type.getType(leafProperty.getValueRawType()));
            if (leafProperty.hasConvertWith()) {
                ctor.visitLdcInsn((Object)Type.getType(leafProperty.getConvertWith()));
            } else {
                ctor.visitInsn(1);
            }
            ctor.visitMethodInsn(184, I_OBJECT_CREATOR, leafProperty.isSecret() ? "secretValue" : "value", "(L" + I_MAPPING_CONTEXT + ";L" + I_STRING + ";L" + I_CLASS + ";L" + I_CLASS + ";)L" + (leafProperty.isSecret() ? I_SECRET : I_OBJECT) + ";", false);
        } else if (property.isOptional() && property.isLeaf()) {
            ConfigMappingGenerator.toStringPropertyName(ctor);
            ConfigMappingInterface.LeafProperty optionalProperty = property.asLeaf();
            ctor.visitLdcInsn((Object)Type.getType(optionalProperty.getValueRawType()));
            if (optionalProperty.hasConvertWith()) {
                ctor.visitLdcInsn((Object)Type.getType(optionalProperty.getConvertWith()));
            } else {
                ctor.visitInsn(1);
            }
            ctor.visitMethodInsn(184, I_OBJECT_CREATOR, optionalProperty.isSecret() ? "optionalSecretValue" : "optionalValue", "(L" + I_MAPPING_CONTEXT + ";L" + I_STRING + ";L" + I_CLASS + ";L" + I_CLASS + ";)L" + I_OPTIONAL + ";", false);
        } else if (property.isMap() && property.asMap().getValueProperty().isLeaf()) {
            ConfigMappingGenerator.toStringPropertyName(ctor);
            ConfigMappingInterface.MapProperty mapProperty = property.asMap();
            ConfigMappingInterface.LeafProperty valueProperty = mapProperty.getValueProperty().asLeaf();
            ctor.visitLdcInsn((Object)Type.getType(mapProperty.getKeyRawType()));
            if (mapProperty.hasKeyConvertWith()) {
                ctor.visitLdcInsn((Object)Type.getType(mapProperty.getKeyConvertWith()));
            } else {
                ctor.visitInsn(1);
            }
            ctor.visitLdcInsn((Object)Type.getType(valueProperty.getValueRawType()));
            if (valueProperty.hasConvertWith()) {
                ctor.visitLdcInsn((Object)Type.getType(valueProperty.getConvertWith()));
            } else {
                ctor.visitInsn(1);
            }
            if (mapProperty.hasKeyProvider()) {
                ConfigMappingGenerator.generateMapKeysProvider(ctor, mapProperty.getKeysProvider());
            } else {
                ctor.visitInsn(1);
            }
            if (mapProperty.hasDefaultValue() && mapProperty.getDefaultValue() != null) {
                ctor.visitLdcInsn((Object)mapProperty.getDefaultValue());
            } else {
                ctor.visitInsn(1);
            }
            ctor.visitMethodInsn(184, I_OBJECT_CREATOR, valueProperty.isSecret() ? "secretValues" : "values", "(L" + I_MAPPING_CONTEXT + ";L" + I_STRING + ";L" + I_CLASS + ";L" + I_CLASS + ";L" + I_CLASS + ";L" + I_CLASS + ";L" + I_ITERABLE + ";L" + I_STRING + ";)L" + I_MAP + ";", false);
        } else if (property.isMap() && property.asMap().getValueProperty().isCollection() && property.asMap().getValueProperty().asCollection().getElement().isLeaf()) {
            ConfigMappingGenerator.toStringPropertyName(ctor);
            ConfigMappingInterface.MapProperty mapProperty = property.asMap();
            ConfigMappingInterface.Property valueProperty = mapProperty.getValueProperty();
            ctor.visitLdcInsn((Object)Type.getType(mapProperty.getKeyRawType()));
            if (mapProperty.hasKeyConvertWith()) {
                ctor.visitLdcInsn((Object)Type.getType(mapProperty.getKeyConvertWith()));
            } else {
                ctor.visitInsn(1);
            }
            ConfigMappingInterface.LeafProperty elementProperty = valueProperty.asCollection().getElement().asLeaf();
            ctor.visitLdcInsn((Object)Type.getType(elementProperty.getValueRawType()));
            if (elementProperty.hasConvertWith()) {
                ctor.visitLdcInsn((Object)Type.getType(elementProperty.getConvertWith()));
            } else {
                ctor.visitInsn(1);
            }
            ctor.visitLdcInsn((Object)Type.getType(valueProperty.asCollection().getCollectionRawType()));
            if (mapProperty.hasKeyProvider()) {
                ConfigMappingGenerator.generateMapKeysProvider(ctor, mapProperty.getKeysProvider());
            } else {
                ctor.visitInsn(1);
            }
            if (mapProperty.hasDefaultValue()) {
                ctor.visitLdcInsn((Object)mapProperty.getDefaultValue());
            } else {
                ctor.visitInsn(1);
            }
            ctor.visitMethodInsn(184, I_OBJECT_CREATOR, elementProperty.isSecret() ? "secretValues" : "values", "(L" + I_MAPPING_CONTEXT + ";L" + I_STRING + ";L" + I_CLASS + ";L" + I_CLASS + ";L" + I_CLASS + ";L" + I_CLASS + ";L" + I_CLASS + ";L" + I_ITERABLE + ";L" + I_STRING + ";)L" + I_MAP + ";", false);
        } else if (property.isCollection() && property.asCollection().getElement().isLeaf()) {
            ConfigMappingGenerator.toStringPropertyName(ctor);
            ConfigMappingInterface.CollectionProperty collectionProperty = property.asCollection();
            ConfigMappingInterface.LeafProperty elementProperty = collectionProperty.getElement().asLeaf();
            ctor.visitLdcInsn((Object)Type.getType(elementProperty.getValueRawType()));
            if (collectionProperty.getElement().hasConvertWith()) {
                ctor.visitLdcInsn((Object)Type.getType(elementProperty.getConvertWith()));
            } else {
                ctor.visitInsn(1);
            }
            ctor.visitLdcInsn((Object)Type.getType(collectionProperty.getCollectionRawType()));
            ctor.visitMethodInsn(184, I_OBJECT_CREATOR, elementProperty.isSecret() ? "secretValues" : "values", "(L" + I_MAPPING_CONTEXT + ";L" + I_STRING + ";L" + I_CLASS + ";L" + I_CLASS + ";L" + I_CLASS + ";)L" + I_COLLECTION + ";", false);
        } else if (property.isOptional() && property.asOptional().getNestedProperty().isCollection() && property.asOptional().getNestedProperty().asCollection().getElement().isLeaf()) {
            ConfigMappingGenerator.toStringPropertyName(ctor);
            ConfigMappingInterface.CollectionProperty collectionProperty = property.asOptional().getNestedProperty().asCollection();
            ConfigMappingInterface.LeafProperty elementProperty = collectionProperty.getElement().asLeaf();
            ctor.visitLdcInsn((Object)Type.getType(elementProperty.getValueRawType()));
            if (collectionProperty.getElement().hasConvertWith()) {
                ctor.visitLdcInsn((Object)Type.getType(elementProperty.getConvertWith()));
            } else {
                ctor.visitInsn(1);
            }
            ctor.visitLdcInsn((Object)Type.getType(collectionProperty.getCollectionRawType()));
            ctor.visitMethodInsn(184, I_OBJECT_CREATOR, elementProperty.isSecret() ? "optionalSecretValues" : "optionalValues", "(L" + I_MAPPING_CONTEXT + ";L" + I_STRING + ";L" + I_CLASS + ";L" + I_CLASS + ";L" + I_CLASS + ";)L" + I_OPTIONAL + ";", false);
        } else {
            ctor.visitTypeInsn(187, I_OBJECT_CREATOR);
            ctor.visitInsn(89);
            ConfigMappingGenerator.toStringPropertyName(ctor);
            ctor.visitMethodInsn(183, I_OBJECT_CREATOR, "<init>", "(L" + I_MAPPING_CONTEXT + ";L" + I_STRING + ";)V", false);
            ConfigMappingGenerator.generateNestedProperty(ctor, property);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void generateNestedProperty(MethodVisitor ctor, ConfigMappingInterface.Property property) {
        if (property.isGroup()) {
            ctor.visitLdcInsn((Object)Type.getType(property.asGroup().getGroupType().getInterfaceType()));
            ctor.visitMethodInsn(182, I_OBJECT_CREATOR, "group", "(L" + I_CLASS + ";)L" + I_OBJECT_CREATOR + ";", false);
            ctor.visitMethodInsn(182, I_OBJECT_CREATOR, "get", "()L" + I_OBJECT + ";", false);
            return;
        } else if (property.isMap() && property.asMap().getValueProperty().isLeaf()) {
            ConfigMappingInterface.MapProperty mapProperty = property.asMap();
            ConfigMappingInterface.Property valueProperty = mapProperty.getValueProperty();
            ctor.visitLdcInsn((Object)Type.getType(mapProperty.getKeyRawType()));
            if (mapProperty.hasKeyConvertWith()) {
                ctor.visitLdcInsn((Object)Type.getType(mapProperty.getKeyConvertWith()));
            } else {
                ctor.visitInsn(1);
            }
            ConfigMappingInterface.LeafProperty leafProperty = valueProperty.asLeaf();
            ctor.visitLdcInsn((Object)Type.getType(leafProperty.getValueRawType()));
            if (leafProperty.hasConvertWith()) {
                ctor.visitLdcInsn((Object)Type.getType(leafProperty.getConvertWith()));
            } else {
                ctor.visitInsn(1);
            }
            if (mapProperty.hasKeyProvider()) {
                ConfigMappingGenerator.generateMapKeysProvider(ctor, mapProperty.getKeysProvider());
            } else {
                ctor.visitInsn(1);
            }
            if (mapProperty.hasDefaultValue() && mapProperty.getDefaultValue() != null) {
                ctor.visitLdcInsn((Object)mapProperty.getDefaultValue());
            } else {
                ctor.visitInsn(1);
            }
            ctor.visitMethodInsn(182, I_OBJECT_CREATOR, "values", "(L" + I_CLASS + ";L" + I_CLASS + ";L" + I_CLASS + ";L" + I_CLASS + ";L" + I_ITERABLE + ";L" + I_STRING + ";)L" + I_OBJECT_CREATOR + ";", false);
            ctor.visitMethodInsn(182, I_OBJECT_CREATOR, "get", "()L" + I_OBJECT + ";", false);
            return;
        } else if (property.isMap() && property.asMap().getValueProperty().isCollection() && property.asMap().getValueProperty().asCollection().getElement().isLeaf()) {
            ConfigMappingInterface.MapProperty mapProperty = property.asMap();
            ConfigMappingInterface.Property valueProperty = mapProperty.getValueProperty();
            ctor.visitLdcInsn((Object)Type.getType(mapProperty.getKeyRawType()));
            if (mapProperty.hasKeyConvertWith()) {
                ctor.visitLdcInsn((Object)Type.getType(mapProperty.getKeyConvertWith()));
            } else {
                ctor.visitInsn(1);
            }
            ConfigMappingInterface.LeafProperty leafProperty = valueProperty.asCollection().getElement().asLeaf();
            ctor.visitLdcInsn((Object)Type.getType(leafProperty.getValueRawType()));
            if (leafProperty.hasConvertWith()) {
                ctor.visitLdcInsn((Object)Type.getType(leafProperty.getConvertWith()));
            } else {
                ctor.visitInsn(1);
            }
            ctor.visitLdcInsn((Object)Type.getType(valueProperty.asCollection().getCollectionRawType()));
            if (mapProperty.hasKeyProvider()) {
                ConfigMappingGenerator.generateMapKeysProvider(ctor, mapProperty.getKeysProvider());
            } else {
                ctor.visitInsn(1);
            }
            if (mapProperty.hasDefaultValue()) {
                ctor.visitLdcInsn((Object)mapProperty.getDefaultValue());
            } else {
                ctor.visitInsn(1);
            }
            ctor.visitMethodInsn(182, I_OBJECT_CREATOR, "values", "(L" + I_CLASS + ";L" + I_CLASS + ";L" + I_CLASS + ";L" + I_CLASS + ";L" + I_CLASS + ";L" + I_ITERABLE + ";L" + I_STRING + ";)L" + I_OBJECT_CREATOR + ";", false);
            ctor.visitMethodInsn(182, I_OBJECT_CREATOR, "get", "()L" + I_OBJECT + ";", false);
            return;
        } else if (property.isOptional() && property.asOptional().getNestedProperty().isCollection() && property.asOptional().getNestedProperty().asCollection().getElement().isLeaf()) {
            ConfigMappingInterface.CollectionProperty collectionProperty = property.asOptional().getNestedProperty().asCollection();
            ctor.visitLdcInsn((Object)Type.getType(collectionProperty.getElement().asLeaf().getValueRawType()));
            if (collectionProperty.getElement().hasConvertWith()) {
                ctor.visitLdcInsn((Object)Type.getType(collectionProperty.getElement().asLeaf().getConvertWith()));
            } else {
                ctor.visitInsn(1);
            }
            ctor.visitLdcInsn((Object)Type.getType(collectionProperty.getCollectionRawType()));
            ctor.visitMethodInsn(182, I_OBJECT_CREATOR, "optionalValues", "(L" + I_CLASS + ";L" + I_CLASS + ";L" + I_CLASS + ";)L" + I_OBJECT_CREATOR + ";", false);
            ctor.visitMethodInsn(182, I_OBJECT_CREATOR, "get", "()L" + I_OBJECT + ";", false);
            return;
        } else if (property.isMap()) {
            ConfigMappingInterface.MapProperty mapProperty = property.asMap();
            ConfigMappingInterface.Property valueProperty = mapProperty.getValueProperty();
            if (valueProperty.isGroup()) {
                ctor.visitLdcInsn((Object)Type.getType(mapProperty.getKeyRawType()));
                if (mapProperty.hasKeyConvertWith()) {
                    ctor.visitLdcInsn((Object)Type.getType(mapProperty.getKeyConvertWith()));
                } else {
                    ctor.visitInsn(1);
                }
                if (mapProperty.hasKeyUnnamed()) {
                    ctor.visitLdcInsn((Object)mapProperty.getKeyUnnamed());
                } else {
                    ctor.visitInsn(1);
                }
                if (mapProperty.hasKeyProvider()) {
                    ConfigMappingGenerator.generateMapKeysProvider(ctor, mapProperty.getKeysProvider());
                } else {
                    ctor.visitInsn(1);
                }
                if (mapProperty.hasDefaultValue()) {
                    ctor.visitLdcInsn((Object)Type.getType(valueProperty.asGroup().getGroupType().getInterfaceType()));
                } else {
                    ctor.visitInsn(1);
                }
                ctor.visitMethodInsn(182, I_OBJECT_CREATOR, "map", "(L" + I_CLASS + ";L" + I_CLASS + ";L" + I_STRING + ";L" + I_ITERABLE + ";L" + I_CLASS + ";)L" + I_OBJECT_CREATOR + ";", false);
                ctor.visitLdcInsn((Object)Type.getType(valueProperty.asGroup().getGroupType().getInterfaceType()));
                if (mapProperty.hasKeyProvider()) {
                    ctor.visitMethodInsn(182, I_OBJECT_CREATOR, "group", "(L" + I_CLASS + ";)L" + I_OBJECT_CREATOR + ";", false);
                } else {
                    ctor.visitMethodInsn(182, I_OBJECT_CREATOR, "lazyGroup", "(L" + I_CLASS + ";)L" + I_OBJECT_CREATOR + ";", false);
                }
                ctor.visitMethodInsn(182, I_OBJECT_CREATOR, "get", "()L" + I_OBJECT + ";", false);
                return;
            } else {
                ConfigMappingGenerator.unwrapNestedProperty(ctor, property);
            }
            return;
        } else if (property.isCollection()) {
            ConfigMappingGenerator.unwrapNestedProperty(ctor, property);
            return;
        } else {
            if (!property.isOptional()) throw new UnsupportedOperationException();
            ConfigMappingInterface.MayBeOptionalProperty nestedProperty = property.asOptional().getNestedProperty();
            if (nestedProperty.isGroup()) {
                ctor.visitLdcInsn((Object)Type.getType(nestedProperty.asGroup().getGroupType().getInterfaceType()));
                ctor.visitMethodInsn(182, I_OBJECT_CREATOR, "optionalGroup", "(L" + I_CLASS + ";)L" + I_OBJECT_CREATOR + ";", false);
                ctor.visitMethodInsn(182, I_OBJECT_CREATOR, "get", "()L" + I_OBJECT + ";", false);
                return;
            } else {
                if (!nestedProperty.isCollection()) throw new UnsupportedOperationException();
                ConfigMappingInterface.CollectionProperty collectionProperty = nestedProperty.asCollection();
                ctor.visitLdcInsn((Object)Type.getType(collectionProperty.getCollectionRawType()));
                ctor.visitMethodInsn(182, I_OBJECT_CREATOR, "optionalCollection", "(L" + I_CLASS + ";)L" + I_OBJECT_CREATOR + ";", false);
                ConfigMappingGenerator.generateNestedProperty(ctor, collectionProperty.getElement());
            }
        }
    }

    private static void unwrapNestedProperty(MethodVisitor ctor, ConfigMappingInterface.Property property) {
        if (property.isMap()) {
            ConfigMappingInterface.MapProperty mapProperty = property.asMap();
            ctor.visitLdcInsn((Object)Type.getType(mapProperty.getKeyRawType()));
            if (mapProperty.hasKeyConvertWith()) {
                ctor.visitLdcInsn((Object)Type.getType(mapProperty.getKeyConvertWith()));
            } else {
                ctor.visitInsn(1);
            }
            if (mapProperty.hasKeyUnnamed()) {
                ctor.visitLdcInsn((Object)mapProperty.getKeyUnnamed());
            } else {
                ctor.visitInsn(1);
            }
            if (mapProperty.hasKeyProvider()) {
                ConfigMappingGenerator.generateMapKeysProvider(ctor, mapProperty.getKeysProvider());
            } else {
                ctor.visitInsn(1);
            }
            ctor.visitMethodInsn(182, I_OBJECT_CREATOR, "map", "(L" + I_CLASS + ";L" + I_CLASS + ";L" + I_STRING + ";L" + I_ITERABLE + ";)L" + I_OBJECT_CREATOR + ";", false);
            ConfigMappingGenerator.generateNestedProperty(ctor, mapProperty.getValueProperty());
        } else if (property.isCollection()) {
            ConfigMappingInterface.CollectionProperty collectionProperty = property.asCollection();
            ctor.visitLdcInsn((Object)Type.getType(collectionProperty.getCollectionRawType()));
            ctor.visitMethodInsn(182, I_OBJECT_CREATOR, "collection", "(L" + I_CLASS + ";)L" + I_OBJECT_CREATOR + ";", false);
            ConfigMappingGenerator.generateNestedProperty(ctor, collectionProperty.getElement());
        } else {
            throw new UnsupportedOperationException();
        }
    }

    private static void generateMapKeysProvider(MethodVisitor ctor, Class<? extends Supplier<Iterable<String>>> mapKeysProvider) {
        String provider = Type.getInternalName(mapKeysProvider);
        ctor.visitTypeInsn(187, provider);
        ctor.visitInsn(89);
        ctor.visitMethodInsn(183, provider, "<init>", "()V", false);
        ctor.visitMethodInsn(182, provider, "get", "()L" + I_ITERABLE + ";", false);
    }

    private static void appendPropertyName(MethodVisitor ctor, ConfigMappingInterface.Property property) {
        if (property.isParentPropertyName()) {
            return;
        }
        Label _continue = new Label();
        ctor.visitVarInsn(25, 2);
        ctor.visitMethodInsn(182, I_STRING_BUILDER, "length", "()I", false);
        ctor.visitJumpInsn(153, _continue);
        ctor.visitVarInsn(25, 2);
        ctor.visitLdcInsn((Object)Character.valueOf('.'));
        ctor.visitInsn(146);
        ctor.visitMethodInsn(182, I_STRING_BUILDER, "append", "(C)L" + I_STRING_BUILDER + ';', false);
        ctor.visitInsn(87);
        ctor.visitLabel(_continue);
        ctor.visitVarInsn(25, 2);
        if (property.hasPropertyName()) {
            ctor.visitLdcInsn((Object)property.getPropertyName());
        } else {
            ctor.visitVarInsn(25, 4);
            ctor.visitLdcInsn((Object)property.getPropertyName());
            ctor.visitMethodInsn(185, Type.getInternalName(Function.class), "apply", "(L" + I_OBJECT + ";)L" + I_OBJECT + ";", true);
            ctor.visitTypeInsn(192, "java/lang/String");
        }
        ctor.visitMethodInsn(182, I_STRING_BUILDER, "append", "(L" + I_STRING + ";)L" + I_STRING_BUILDER + ';', false);
        ctor.visitInsn(87);
    }

    private static void toStringPropertyName(MethodVisitor ctor) {
        ctor.visitVarInsn(25, 1);
        ctor.visitVarInsn(25, 2);
        ctor.visitMethodInsn(182, I_STRING_BUILDER, "toString", "()L" + I_STRING + ';', false);
    }

    private static void restoreLength(MethodVisitor ctor) {
        ctor.visitVarInsn(25, 2);
        ctor.visitVarInsn(21, 3);
        ctor.visitMethodInsn(182, I_STRING_BUILDER, "setLength", "(I)V", false);
    }

    private static int getReturnInstruction(ConfigMappingInterface.Property property) {
        ConfigMappingInterface.PrimitiveProperty primitiveProperty;
        if (property.isPrimitive()) {
            primitiveProperty = property.asPrimitive();
        } else if (property.isDefaultMethod() && property.asDefaultMethod().getDefaultProperty().isPrimitive()) {
            primitiveProperty = property.asDefaultMethod().getDefaultProperty().asPrimitive();
        } else {
            return 176;
        }
        if (primitiveProperty.getPrimitiveType() == Float.TYPE) {
            return 174;
        }
        if (primitiveProperty.getPrimitiveType() == Double.TYPE) {
            return 175;
        }
        if (primitiveProperty.getPrimitiveType() == Long.TYPE) {
            return 173;
        }
        return 172;
    }

    private static String getSignature(Field field) {
        String typeName = field.getGenericType().getTypeName();
        if (typeName.indexOf(60) != -1 && typeName.indexOf(62) != -1) {
            String signature = "()L" + typeName.replace(".", "/");
            signature = signature.replace("<", "<L");
            signature = signature.replace(", ", ";L");
            signature = signature.replace(">", ";>");
            signature = signature + ";";
            if (typeName.contains("[]")) {
                signature = ARRAY_FORMAT_REGEX.matcher(signature).replaceAll("$1[L$2;");
            }
            return signature;
        }
        return null;
    }

    private static void generateToString(ClassVisitor visitor, ConfigMappingInterface mapping) {
        if (!mapping.getToStringMethod().generate()) {
            return;
        }
        MethodVisitor ts = visitor.visitMethod(1, "toString", "()L" + I_STRING + ";", null, null);
        ts.visitCode();
        ts.visitTypeInsn(187, I_STRING_BUILDER);
        ts.visitInsn(89);
        ts.visitMethodInsn(183, I_STRING_BUILDER, "<init>", "()V", false);
        ts.visitLdcInsn((Object)(mapping.getInterfaceType().getSimpleName() + "{"));
        ts.visitMethodInsn(182, I_STRING_BUILDER, "append", "(L" + I_STRING + ";)L" + I_STRING_BUILDER + ";", false);
        ConfigMappingInterface.Property[] properties = mapping.getProperties();
        int propertiesLength = properties.length;
        for (int i = 0; i < propertiesLength; ++i) {
            ConfigMappingInterface.Property property = properties[i];
            if (ConfigMappingGenerator.isSecret(property)) continue;
            if (property.isDefaultMethod()) {
                property = property.asDefaultMethod().getDefaultProperty();
            }
            String member = property.getMethod().getName();
            ts.visitLdcInsn((Object)(member + "="));
            ts.visitMethodInsn(182, I_STRING_BUILDER, "append", "(L" + I_STRING + ";)L" + I_STRING_BUILDER + ";", false);
            ts.visitVarInsn(25, 0);
            ts.visitFieldInsn(180, mapping.getClassInternalName(), member, Type.getDescriptor(property.getMethod().getReturnType()));
            if (property.isPrimitive()) {
                ts.visitMethodInsn(182, I_STRING_BUILDER, "append", "(" + Type.getDescriptor(property.asPrimitive().getPrimitiveType()) + ")L" + I_STRING_BUILDER + ";", false);
            } else {
                ts.visitMethodInsn(182, I_STRING_BUILDER, "append", "(L" + I_OBJECT + ";)L" + I_STRING_BUILDER + ";", false);
            }
            if (i + 1 >= propertiesLength) continue;
            ts.visitLdcInsn((Object)", ");
            ts.visitMethodInsn(182, I_STRING_BUILDER, "append", "(L" + I_STRING + ";)L" + I_STRING_BUILDER + ";", false);
        }
        ts.visitLdcInsn((Object)"}");
        ts.visitMethodInsn(182, I_STRING_BUILDER, "append", "(L" + I_STRING + ";)L" + I_STRING_BUILDER + ";", false);
        ts.visitMethodInsn(182, I_STRING_BUILDER, "toString", "()L" + I_STRING + ";", false);
        ts.visitInsn(176);
        ts.visitEnd();
        ts.visitMaxs(0, 0);
    }

    private static void generateEquals(ClassVisitor visitor, ConfigMappingInterface mapping) {
        MethodVisitor eq = visitor.visitMethod(1, "equals", "(Ljava/lang/Object;)Z", null, null);
        eq.visitCode();
        int V_O = 1;
        int V_THAT = 2;
        eq.visitVarInsn(25, 0);
        eq.visitVarInsn(25, V_O);
        Label _ifRef = new Label();
        eq.visitJumpInsn(166, _ifRef);
        eq.visitInsn(4);
        eq.visitInsn(172);
        eq.visitLabel(_ifRef);
        eq.visitVarInsn(25, V_O);
        Label _ifNull = new Label();
        eq.visitJumpInsn(198, _ifNull);
        eq.visitVarInsn(25, 0);
        Label _ifClass = new Label();
        eq.visitMethodInsn(182, I_OBJECT, "getClass", "()L" + I_CLASS + ";", false);
        eq.visitVarInsn(25, V_O);
        eq.visitMethodInsn(182, I_OBJECT, "getClass", "()L" + I_CLASS + ";", false);
        eq.visitJumpInsn(165, _ifClass);
        eq.visitLabel(_ifNull);
        eq.visitFrame(3, 0, null, 0, null);
        eq.visitInsn(3);
        eq.visitInsn(172);
        eq.visitLabel(_ifClass);
        eq.visitVarInsn(25, V_O);
        eq.visitTypeInsn(192, mapping.getClassInternalName());
        eq.visitVarInsn(58, V_THAT);
        Label _ifTrue = new Label();
        Label _ifFalse = new Label();
        for (ConfigMappingInterface.Property property : mapping.getProperties()) {
            if (property.isDefaultMethod()) {
                property = property.asDefaultMethod().getDefaultProperty();
            }
            String member = property.getMethod().getName();
            Class<?> returnType = property.getMethod().getReturnType();
            eq.visitVarInsn(25, 0);
            eq.visitMethodInsn(182, mapping.getClassInternalName(), member, "()" + Type.getDescriptor(returnType), false);
            eq.visitVarInsn(25, V_THAT);
            eq.visitMethodInsn(182, mapping.getClassInternalName(), member, "()" + Type.getDescriptor(returnType), false);
            if (property.isPrimitive()) {
                ConfigMappingInterface.PrimitiveProperty primitiveProperty = property.asPrimitive();
                if (primitiveProperty.getPrimitiveType() == Float.TYPE) {
                    eq.visitInsn(149);
                    eq.visitJumpInsn(154, _ifFalse);
                    continue;
                }
                if (primitiveProperty.getPrimitiveType() == Double.TYPE) {
                    eq.visitInsn(151);
                    eq.visitJumpInsn(154, _ifFalse);
                    continue;
                }
                if (primitiveProperty.getPrimitiveType() == Long.TYPE) {
                    eq.visitInsn(148);
                    eq.visitJumpInsn(154, _ifFalse);
                    continue;
                }
                eq.visitJumpInsn(160, _ifFalse);
                continue;
            }
            eq.visitMethodInsn(184, "java/util/Objects", "equals", "(Ljava/lang/Object;Ljava/lang/Object;)Z", false);
            eq.visitJumpInsn(153, _ifFalse);
        }
        eq.visitInsn(4);
        eq.visitJumpInsn(167, _ifTrue);
        eq.visitLabel(_ifFalse);
        eq.visitInsn(3);
        eq.visitLabel(_ifTrue);
        eq.visitInsn(172);
        eq.visitEnd();
        eq.visitMaxs(0, 0);
    }

    private static void generateHashCode(ClassVisitor visitor, ConfigMappingInterface mapping) {
        MethodVisitor hc = visitor.visitMethod(1, "hashCode", "()I", null, null);
        hc.visitCode();
        ConfigMappingInterface.Property[] properties = mapping.getProperties();
        hc.visitIntInsn(16, properties.length);
        hc.visitTypeInsn(189, I_OBJECT);
        hc.visitInsn(89);
        for (int i = 0; i < properties.length; ++i) {
            ConfigMappingInterface.Property property = properties[i];
            if (property.isDefaultMethod()) {
                property = property.asDefaultMethod().getDefaultProperty();
            }
            String member = property.getMethod().getName();
            Class<?> returnType = property.getMethod().getReturnType();
            hc.visitIntInsn(16, i);
            hc.visitVarInsn(25, 0);
            hc.visitFieldInsn(180, mapping.getClassInternalName(), member, Type.getDescriptor(returnType));
            if (property.isPrimitive()) {
                ConfigMappingInterface.PrimitiveProperty primitiveProperty = property.asPrimitive();
                hc.visitMethodInsn(184, Type.getInternalName(primitiveProperty.getBoxType()), "valueOf", "(" + Type.getDescriptor(primitiveProperty.getPrimitiveType()) + ")" + Type.getDescriptor(primitiveProperty.getBoxType()), false);
            }
            hc.visitInsn(83);
            hc.visitInsn(89);
        }
        hc.visitMethodInsn(184, "java/util/Objects", "hash", "([Ljava/lang/Object;)I", false);
        hc.visitInsn(172);
        hc.visitMaxs(0, 0);
        hc.visitEnd();
    }

    private static void generateStaticInit(ClassVisitor classVisitor, ConfigMappingInterface mapping) {
        Map<String, ConfigMappingInterface.Property> properties = ConfigMappingInterface.getProperties(mapping).get(mapping.getInterfaceType()).get("");
        classVisitor.visitField(26, "PROPERTIES", "Ljava/util/Map;", "Ljava/util/Map<Ljava/lang/String;Ljava/lang/String;>;", null).visitEnd();
        classVisitor.visitField(26, "SECRETS", "Ljava/util/Set;", "Ljava/util/Set<Ljava/lang/String;>;", null).visitEnd();
        MethodVisitor clinit = classVisitor.visitMethod(8, "<clinit>", "()V", null, null);
        clinit.visitTypeInsn(187, "java/util/HashMap");
        clinit.visitInsn(89);
        if (properties.size() < 3) {
            clinit.visitIntInsn(16, properties.size() + 1);
        } else {
            clinit.visitIntInsn(17, (int)((float)properties.size() / 0.75f + 1.0f));
        }
        clinit.visitMethodInsn(183, "java/util/HashMap", "<init>", "(I)V", false);
        clinit.visitFieldInsn(179, mapping.getClassInternalName(), "PROPERTIES", "Ljava/util/Map;");
        HashMap<String, ConfigMappingInterface.Property> secrets = new HashMap<String, ConfigMappingInterface.Property>();
        for (Map.Entry<String, ConfigMappingInterface.Property> entry : properties.entrySet()) {
            if (!ConfigMappingGenerator.isSecret(entry.getValue())) continue;
            secrets.put(entry.getKey(), entry.getValue());
        }
        if (secrets.isEmpty()) {
            clinit.visitMethodInsn(184, "java/util/Collections", "emptySet", "()Ljava/util/Set;", false);
        } else if (secrets.size() < 3) {
            clinit.visitTypeInsn(187, "java/util/HashSet");
            clinit.visitInsn(89);
            clinit.visitIntInsn(16, secrets.size() + 1);
            clinit.visitMethodInsn(183, "java/util/HashSet", "<init>", "(I)V", false);
        } else {
            clinit.visitTypeInsn(187, "java/util/HashSet");
            clinit.visitInsn(89);
            clinit.visitIntInsn(17, (int)((float)secrets.size() / 0.75f + 1.0f));
            clinit.visitMethodInsn(183, "java/util/HashSet", "<init>", "(I)V", false);
        }
        clinit.visitFieldInsn(179, mapping.getClassInternalName(), "SECRETS", "Ljava/util/Set;");
        for (Map.Entry<String, ConfigMappingInterface.Property> entry : properties.entrySet()) {
            clinit.visitFieldInsn(178, mapping.getClassInternalName(), "PROPERTIES", "Ljava/util/Map;");
            clinit.visitLdcInsn((Object)entry.getKey());
            if (entry.getValue().hasDefaultValue()) {
                if (entry.getKey().endsWith("[*]")) {
                    clinit.visitInsn(1);
                } else {
                    clinit.visitLdcInsn((Object)entry.getValue().getDefaultValue());
                }
            } else {
                clinit.visitInsn(1);
            }
            clinit.visitMethodInsn(185, "java/util/Map", "put", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", true);
            clinit.visitInsn(87);
        }
        for (Map.Entry<String, ConfigMappingInterface.Property> entry : secrets.entrySet()) {
            clinit.visitFieldInsn(178, mapping.getClassInternalName(), "SECRETS", "Ljava/util/Set;");
            clinit.visitLdcInsn((Object)entry.getKey());
            clinit.visitMethodInsn(185, "java/util/Set", "add", "(Ljava/lang/Object;)Z", true);
            clinit.visitInsn(87);
        }
        clinit.visitInsn(177);
        clinit.visitMaxs(0, 0);
        clinit.visitEnd();
        MethodVisitor mv = classVisitor.visitMethod(9, "getProperties", "()Ljava/util/Map;", "()Ljava/util/Map<Ljava/lang/String;Ljava/lang/String;>;", null);
        mv.visitFieldInsn(178, mapping.getClassInternalName(), "PROPERTIES", "Ljava/util/Map;");
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        mv = classVisitor.visitMethod(9, "getSecrets", "()Ljava/util/Set;", "()Ljava/util/Set<Ljava/lang/String;>;", null);
        mv.visitFieldInsn(178, mapping.getClassInternalName(), "SECRETS", "Ljava/util/Set;");
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private static boolean hasDefaultValue(Class<?> klass, Object value) {
        if (value == null) {
            return false;
        }
        if (klass.isPrimitive() && value instanceof Number && value.equals(0)) {
            return false;
        }
        if (klass.isPrimitive() && value instanceof Boolean && value.equals(Boolean.FALSE)) {
            return false;
        }
        return !klass.isPrimitive() || !(value instanceof Character) || !value.equals(0);
    }

    private static boolean isSecret(ConfigMappingInterface.Property property) {
        if (property.isLeaf()) {
            return property.isSecret();
        }
        if (property.isOptional()) {
            return ConfigMappingGenerator.isSecret(property.asOptional().getNestedProperty());
        }
        if (property.isCollection()) {
            return ConfigMappingGenerator.isSecret(property.asCollection().getElement());
        }
        if (property.isMap()) {
            return ConfigMappingGenerator.isSecret(property.asMap().getValueProperty());
        }
        return false;
    }

    static {
        ARRAY_FORMAT_REGEX = Pattern.compile("([<;])L(.*)\\[];");
        usefulDebugInfo = Boolean.parseBoolean(AccessController.doPrivileged(() -> System.getProperty("io.smallrye.config.mapper.useful-debug-info")));
        I_CLASS = Type.getInternalName(Class.class);
        I_FIELD = Type.getInternalName(Field.class);
        I_MAPPING_CONTEXT = Type.getInternalName(ConfigMappingContext.class);
        I_OBJECT_CREATOR = Type.getInternalName(ConfigMappingContext.ObjectCreator.class);
        I_NAMING_STRATEGY = Type.getInternalName(ConfigMapping.NamingStrategy.class);
        I_STRING_BUILDER = Type.getInternalName(StringBuilder.class);
        I_RUNTIME_EXCEPTION = Type.getInternalName(RuntimeException.class);
        I_OBJECT = Type.getInternalName(Object.class);
        I_STRING = Type.getInternalName(String.class);
        I_OPTIONAL = Type.getInternalName(Optional.class);
        I_COLLECTION = Type.getInternalName(Collection.class);
        I_MAP = Type.getInternalName(Map.class);
        I_ITERABLE = Type.getInternalName(Iterable.class);
        I_SECRET = Type.getInternalName(Secret.class);
    }

    static final class Debugging {
        Debugging() {
        }

        static StackTraceElement getCaller() {
            return new Throwable().getStackTrace()[2];
        }

        static final class ClassVisitorImpl
        extends ClassVisitor {
            final String sourceFile = Debugging.getCaller().getFileName();

            ClassVisitorImpl(int api) {
                super(api);
            }

            ClassVisitorImpl(ClassWriter cw) {
                super(458752, (ClassVisitor)cw);
            }

            public void visitSource(String source, String debug) {
                super.visitSource(this.sourceFile, debug);
            }

            public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
                return new MethodVisitorImpl(this.api, super.visitMethod(access, name, descriptor, signature, exceptions));
            }
        }

        static final class MethodVisitorImpl
        extends MethodVisitor {
            MethodVisitorImpl(int api) {
                super(api);
            }

            MethodVisitorImpl(int api, MethodVisitor methodVisitor) {
                super(api, methodVisitor);
            }

            public void visitInsn(int opcode) {
                Label l = new Label();
                this.visitLabel(l);
                this.visitLineNumber(Debugging.getCaller().getLineNumber(), l);
                super.visitInsn(opcode);
            }

            public void visitIntInsn(int opcode, int operand) {
                Label l = new Label();
                this.visitLabel(l);
                this.visitLineNumber(Debugging.getCaller().getLineNumber(), l);
                super.visitIntInsn(opcode, operand);
            }

            public void visitVarInsn(int opcode, int var) {
                Label l = new Label();
                this.visitLabel(l);
                this.visitLineNumber(Debugging.getCaller().getLineNumber(), l);
                super.visitVarInsn(opcode, var);
            }

            public void visitTypeInsn(int opcode, String type) {
                Label l = new Label();
                this.visitLabel(l);
                this.visitLineNumber(Debugging.getCaller().getLineNumber(), l);
                super.visitTypeInsn(opcode, type);
            }

            public void visitFieldInsn(int opcode, String owner, String name, String descriptor) {
                Label l = new Label();
                this.visitLabel(l);
                this.visitLineNumber(Debugging.getCaller().getLineNumber(), l);
                super.visitFieldInsn(opcode, owner, name, descriptor);
            }

            public void visitMethodInsn(int opcode, String owner, String name, String descriptor) {
                Label l = new Label();
                this.visitLabel(l);
                this.visitLineNumber(Debugging.getCaller().getLineNumber(), l);
                super.visitMethodInsn(opcode, owner, name, descriptor);
            }

            public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
                Label l = new Label();
                this.visitLabel(l);
                this.visitLineNumber(Debugging.getCaller().getLineNumber(), l);
                super.visitMethodInsn(opcode, owner, name, descriptor, isInterface);
            }

            public void visitInvokeDynamicInsn(String name, String descriptor, Handle bootstrapMethodHandle, Object ... bootstrapMethodArguments) {
                Label l = new Label();
                this.visitLabel(l);
                this.visitLineNumber(Debugging.getCaller().getLineNumber(), l);
                super.visitInvokeDynamicInsn(name, descriptor, bootstrapMethodHandle, bootstrapMethodArguments);
            }

            public void visitJumpInsn(int opcode, Label label) {
                Label l = new Label();
                this.visitLabel(l);
                this.visitLineNumber(Debugging.getCaller().getLineNumber(), l);
                super.visitJumpInsn(opcode, label);
            }

            public void visitLdcInsn(Object value) {
                Label l = new Label();
                this.visitLabel(l);
                this.visitLineNumber(Debugging.getCaller().getLineNumber(), l);
                super.visitLdcInsn(value);
            }

            public void visitIincInsn(int var, int increment) {
                Label l = new Label();
                this.visitLabel(l);
                this.visitLineNumber(Debugging.getCaller().getLineNumber(), l);
                super.visitIincInsn(var, increment);
            }

            public void visitTableSwitchInsn(int min, int max, Label dflt, Label ... labels) {
                Label l = new Label();
                this.visitLabel(l);
                this.visitLineNumber(Debugging.getCaller().getLineNumber(), l);
                super.visitTableSwitchInsn(min, max, dflt, labels);
            }

            public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
                Label l = new Label();
                this.visitLabel(l);
                this.visitLineNumber(Debugging.getCaller().getLineNumber(), l);
                super.visitLookupSwitchInsn(dflt, keys, labels);
            }

            public void visitMultiANewArrayInsn(String descriptor, int numDimensions) {
                Label l = new Label();
                this.visitLabel(l);
                this.visitLineNumber(Debugging.getCaller().getLineNumber(), l);
                super.visitMultiANewArrayInsn(descriptor, numDimensions);
            }
        }
    }
}

