package io.smallrye.config;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

import org.eclipse.microprofile.config.spi.ConfigSource;

/**
 * Exposes contextual information on the ConfigSource initialization via {@link ConfigSourceFactory}.
 */
public interface ConfigSourceContext {
    ConfigValue getValue(String name);

    Iterator<String> iterateNames();

    default List<String> getProfiles() {
        throw new UnsupportedOperationException();
    }

    default List<ConfigSource> getConfigSources() {
        throw new UnsupportedOperationException();
    }

    class ConfigSourceContextConfigSource implements ConfigSource {
        private final ConfigSourceContext context;

        public ConfigSourceContextConfigSource(final ConfigSourceContext context) {
            this.context = context;
        }

        @Override
        public Set<String> getPropertyNames() {
            Set<String> names = new HashSet<>();
            Iterator<String> namesIterator = context.iterateNames();
            while (namesIterator.hasNext()) {
                names.add(namesIterator.next());
            }
            return names;
        }

        @Override
        public String getValue(final String propertyName) {
            ConfigValue value = context.getValue(propertyName);
            return value != null && value.getValue() != null ? value.getValue() : null;
        }

        @Override
        public String getName() {
            return ConfigSourceContextConfigSource.class.getName();
        }

        @Override
        public int getOrdinal() {
            return Integer.MAX_VALUE;
        }
    }
}
