package io.smallrye.config;

import java.util.Locale;
import java.io.Serializable;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.lang.String;
import org.jboss.logging.Logger;


import static org.jboss.logging.Logger.Level.DEBUG;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
public class ConfigLogging_$logger extends DelegatingBasicLogger implements ConfigLogging, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ConfigLogging_$logger.class.getName();
    public ConfigLogging_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void failedToRetrieveClassloader(final Throwable cause) {
        super.log.logf(FQCN, WARN, cause, failedToRetrieveClassloader$str());
    }
    protected String failedToRetrieveClassloader$str() {
        return "SRCFG01000: Unable to get context classloader instance";
    }
    @Override
    public final void lookup(final String name, final String source, final String value) {
        super.log.logf(FQCN, DEBUG, null, lookup$str(), name, source, value);
    }
    protected String lookup$str() {
        return "SRCFG01001: The config %s was loaded from %s with the value %s";
    }
    @Override
    public final void notFound(final String name) {
        super.log.logf(FQCN, DEBUG, null, notFound$str(), name);
    }
    protected String notFound$str() {
        return "SRCFG01002: The config %s was not found";
    }
    @Override
    public final void failedToRetrieveDeclaredConstructor(final Throwable cause, final String clazz, final String paramTypes) {
        super.log.logf(FQCN, WARN, cause, failedToRetrieveDeclaredConstructor$str(), clazz, paramTypes);
    }
    protected String failedToRetrieveDeclaredConstructor$str() {
        return "SRCFG01003: Unable to get declared constructor for class %s with arguments %s";
    }
    @Override
    public final void failedToSetAccessible(final Throwable cause, final String accessibleObject) {
        super.log.logf(FQCN, WARN, cause, failedToSetAccessible$str(), accessibleObject);
    }
    protected String failedToSetAccessible$str() {
        return "SRCFG01004: Unable to set accessible flag on %s";
    }
    @Override
    public final void configLocationsNotFound(final String name, final String value) {
        super.log.logf(FQCN, WARN, null, configLocationsNotFound$str(), name, value);
    }
    protected String configLocationsNotFound$str() {
        return "SRCFG01005: Could not find sources with %s in %s";
    }
}
