/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config.common.utils;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtil {
    private static final byte[] NON_ALPHANUMERIC_UNDERSCORE_REPLACEMENTS = new byte[256];
    private static final String[] NO_STRINGS;
    private static final Pattern ITEM_PATTERN;

    public static boolean isAsciiLetterOrDigit(char c) {
        if (c > '\u00ff') {
            return false;
        }
        return NON_ALPHANUMERIC_UNDERSCORE_REPLACEMENTS[c & 0xFF] != 95;
    }

    private static char replacementOf(char c) {
        if (c > '\u00ff') {
            return '_';
        }
        return (char)(NON_ALPHANUMERIC_UNDERSCORE_REPLACEMENTS[c & 0xFF] & 0xFF);
    }

    private static byte rawReplacementOf(char c) {
        if (c > '\u00ff') {
            return 95;
        }
        return NON_ALPHANUMERIC_UNDERSCORE_REPLACEMENTS[c & 0xFF];
    }

    private StringUtil() {
    }

    public static String[] split(String text) {
        if (text == null || text.isEmpty()) {
            return NO_STRINGS;
        }
        Matcher matcher = ITEM_PATTERN.matcher(text);
        String item = null;
        StringBuilder b = null;
        ArrayList<String> list = new ArrayList<String>(4);
        while (matcher.find()) {
            if (matcher.group(1) != null) {
                if (item == null) continue;
                list.add(item);
                item = null;
                continue;
            }
            if (matcher.group(2) != null) {
                assert (item == null) : "Regular expression matching malfunctioned";
                item = matcher.group(2);
                continue;
            }
            if (matcher.group(3) != null) {
                if (b == null) {
                    b = new StringBuilder();
                }
                if (item != null) {
                    b.append(item);
                    item = null;
                }
                b.append(matcher.group(3));
                while (matcher.find() && matcher.group(1) == null) {
                    if (matcher.group(2) != null) {
                        b.append(matcher.group(2));
                        continue;
                    }
                    if (matcher.group(3) != null) {
                        b.append(matcher.group(3));
                        continue;
                    }
                    throw new IllegalStateException();
                }
                list.add(b.toString());
                b.setLength(0);
                continue;
            }
            throw new IllegalStateException();
        }
        if (item != null) {
            list.add(item);
        }
        return list.toArray(NO_STRINGS);
    }

    public static String replaceNonAlphanumericByUnderscores(String name) {
        int length = name.length();
        if (length == 0) {
            return name;
        }
        byte[] result = new byte[length + 1];
        char c = '\u0000';
        for (int i = 0; i < length; ++i) {
            c = name.charAt(i);
            result[i] = StringUtil.rawReplacementOf(c);
        }
        if (c == '\"') {
            result[length] = 95;
            return new String(result, 0, 0, length + 1);
        }
        return new String(result, 0, 0, length);
    }

    public static String replaceNonAlphanumericByUnderscores(String name, StringBuilder sb) {
        int length = name.length();
        char c = '\u0000';
        for (int i = 0; i < length; ++i) {
            c = name.charAt(i);
            sb.append(StringUtil.replacementOf(c));
        }
        if (c == '\"') {
            sb.append('_');
        }
        return sb.toString();
    }

    public static String replaceNonAlphanumericByUnderscores(String name, ResizableByteArray sb) {
        int length = name.length();
        if (length == 0) {
            return name;
        }
        byte[] ascii = sb.ensureCapacity(length + 1);
        char c = '\u0000';
        for (int i = 0; i < length; ++i) {
            c = name.charAt(i);
            ascii[i] = StringUtil.rawReplacementOf(c);
        }
        if (c == '\"') {
            ascii[length] = 95;
            return new String(ascii, 0, 0, length + 1);
        }
        return new String(ascii, 0, 0, length);
    }

    public static String toLowerCaseAndDotted(String name) {
        int length = name.length();
        if (length == 0) {
            return name;
        }
        if (length > 1 && name.charAt(length - 1) == '_' && name.charAt(length - 2) == '_') {
            --length;
        }
        byte[] result = new byte[length];
        int i = 0;
        if (name.charAt(0) == '_' && name.length() > 1 && StringUtil.isAsciiLetterOrDigit(name.charAt(1))) {
            result[0] = 37;
            ++i;
        }
        boolean quotesOpen = false;
        while (i < length) {
            char c = name.charAt(i);
            if ('_' == c) {
                int next = i + 1;
                if (quotesOpen) {
                    if (next == length) {
                        result[i] = 34;
                    } else if (name.charAt(next) == '_') {
                        result[i] = 34;
                        result[next] = 46;
                        ++i;
                        quotesOpen = false;
                    } else {
                        result[i] = 46;
                    }
                } else if (next < length) {
                    char d = name.charAt(next);
                    if (Character.isDigit(d)) {
                        int j;
                        result[next] = (byte)d;
                        for (j = next + 1; j < length; ++j) {
                            d = name.charAt(j);
                            if (!Character.isDigit(d)) {
                                if ('_' == d) {
                                    result[i] = 91;
                                    result[j] = 93;
                                    i = j;
                                    break;
                                }
                                result[i] = 46;
                                break;
                            }
                            result[j] = (byte)d;
                        }
                        if (j >= length) {
                            result[i] = 46;
                        }
                    } else if (name.charAt(next) == '_') {
                        result[i] = 46;
                        result[next] = 34;
                        ++i;
                        quotesOpen = true;
                    } else {
                        result[i] = 46;
                    }
                } else {
                    result[i] = 46;
                }
            } else {
                result[i] = (byte)Character.toLowerCase(c);
            }
            ++i;
        }
        return new String(result, 0, 0, result.length);
    }

    public static boolean isInPath(String path, String name) {
        if (path.isEmpty()) {
            return true;
        }
        if (name.equals(path)) {
            return false;
        }
        if (name.length() <= path.length()) {
            return false;
        }
        char e = name.charAt(path.length());
        if (e == '.' || e == '[') {
            for (int i = 0; i < path.length(); ++i) {
                char r = path.charAt(i);
                e = name.charAt(i);
                if (!(r == '-' ? e != '.' && e != '-' : r != e)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean isNumeric(CharSequence digits) {
        return StringUtil.isNumeric(digits, 0, digits.length());
    }

    public static boolean isNumeric(CharSequence digits, int begin, int end) {
        if (digits.isEmpty()) {
            return false;
        }
        if (end <= begin) {
            return false;
        }
        for (int i = begin; i < end; ++i) {
            if (Character.isDigit(digits.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String unquoted(String name) {
        return StringUtil.unquoted(name, 0);
    }

    public static String unquoted(String name, int begin) {
        return StringUtil.unquoted(name, begin, name.length());
    }

    public static String unquoted(String name, int begin, int end) {
        if (begin < 0 || begin > end || end > name.length()) {
            throw new StringIndexOutOfBoundsException("begin " + begin + ", end " + end + ", length " + name.length());
        }
        if (name.length() < 2 || name.length() <= begin) {
            return name;
        }
        if (name.charAt(begin) == '\"' && name.charAt(end - 1) == '\"') {
            return name.substring(begin + 1, end - 1);
        }
        return name.substring(begin, end);
    }

    public static int index(String name) {
        int start;
        if (name.charAt(name.length() - 1) == ']' && (start = name.lastIndexOf(91)) != -1 && StringUtil.isNumeric(name, start + 1, name.length() - 1)) {
            return Integer.parseInt(name.substring(start + 1, name.length() - 1));
        }
        throw new IllegalArgumentException();
    }

    public static String unindexed(String name) {
        int begin;
        if (name.length() < 3) {
            return name;
        }
        if (name.charAt(name.length() - 1) == ']' && (begin = name.lastIndexOf(91)) != -1 && StringUtil.isNumeric(name, begin + 1, name.length() - 1)) {
            return name.substring(0, begin);
        }
        return name;
    }

    public static String skewer(String camelHumps) {
        return StringUtil.skewer(camelHumps, '-');
    }

    public static String skewer(String camelHumps, char separator) {
        if (camelHumps.isEmpty()) {
            return camelHumps;
        }
        int end = camelHumps.length();
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < end; ++i) {
            char last;
            char c = camelHumps.charAt(i);
            if (Character.isLowerCase(c)) {
                b.append(c);
                continue;
            }
            if (Character.isUpperCase(c)) {
                int j;
                if (i > 0 && (last = camelHumps.charAt(i - 1)) != '_' && last != '-') {
                    b.append(separator);
                }
                b.append(Character.toLowerCase(c));
                for (j = i + 1; j < end; ++j) {
                    char u = camelHumps.charAt(j);
                    if (Character.isUpperCase(u)) {
                        b.append(Character.toLowerCase(u));
                        continue;
                    }
                    if (Character.isDigit(u) || u == '-') {
                        b.append(u);
                        continue;
                    }
                    if (j > i + 1 && u != '_' && !Character.isDigit(b.charAt(b.length() - 1))) {
                        b.insert(b.length() - 1, separator);
                    }
                    --j;
                    break;
                }
                i = j;
                continue;
            }
            if (Character.isDigit(c)) {
                b.append(c);
                continue;
            }
            if (c == '.' || c == '*' || c == '[' || c == ']') {
                b.append(c);
                continue;
            }
            if (i > 0) {
                last = camelHumps.charAt(i - 1);
                if (last == '_' || last == '-') continue;
                b.append(separator);
                continue;
            }
            b.append(c);
        }
        return b.toString();
    }

    static {
        for (int c = 0; c < 256; ++c) {
            StringUtil.NON_ALPHANUMERIC_UNDERSCORE_REPLACEMENTS[c] = 97 <= c && c <= 122 || 65 <= c && c <= 90 || 48 <= c && c <= 57 ? (int)c : 95;
        }
        NO_STRINGS = new String[0];
        ITEM_PATTERN = Pattern.compile("(,+)|([^\\\\,]+)|\\\\(.)");
    }

    public static final class ResizableByteArray {
        private byte[] array;

        public ResizableByteArray(int initialSize) {
            this.array = new byte[initialSize];
        }

        private byte[] ensureCapacity(int capacity) {
            byte[] array = this.array;
            if (array.length < capacity) {
                byte[] newArray = new byte[capacity];
                this.array = newArray;
                return newArray;
            }
            return array;
        }
    }
}

