/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.common.search;

import io.smallrye.common.function.ObjIntFunction;
import io.smallrye.common.function.ObjIntPredicate;
import io.smallrye.common.function.ObjLongFunction;
import io.smallrye.common.function.ObjLongPredicate;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.BinaryOperator;
import java.util.function.IntBinaryOperator;
import java.util.function.IntPredicate;
import java.util.function.LongBinaryOperator;
import java.util.function.LongPredicate;
import java.util.function.Predicate;

public final class BinarySearch {
    private BinarySearch() {
    }

    public static IntRange intRange() {
        return IntRange.signed;
    }

    public static LongRange longRange() {
        return LongRange.signed;
    }

    public static ObjRange objRange() {
        return ObjRange.instance;
    }

    public static <E> E getFromArray(E[] array, int index) {
        return array[index];
    }

    private static int signedMidpoint(int from, int to) {
        return from + (to - from >> 1);
    }

    private static int unsignedMidpoint(int from, int to) {
        return from + (to - from >>> 1);
    }

    private static long signedMidpoint(long from, long to) {
        return from + (to - from >> 1);
    }

    private static long unsignedMidpoint(long from, long to) {
        return from + (to - from >>> 1);
    }

    private static <T, A, B, C, D> T searchObject(T from, T to, A a, B b, C c, D d, BinaryOperator<T> midpoint, ObjIdxTestFunction<T, A, B, C, D> test) {
        Object mid = midpoint.apply(from, to);
        while (true) {
            Object newMid;
            if (test.test(mid, a, b, c, d)) {
                to = mid;
                newMid = midpoint.apply(from, to);
                if (Objects.equals(mid, newMid)) {
                    return from;
                }
            } else {
                from = mid;
                newMid = midpoint.apply(from, to);
                if (Objects.equals(mid, newMid)) {
                    return to;
                }
            }
            mid = newMid;
        }
    }

    private static <A, B, C, D> long searchLong(long from, long to, A a, B b, C c, D d, LongBinaryOperator midpoint, LongIdxTestFunction<A, B, C, D> test) {
        long mid = midpoint.applyAsLong(from, to);
        while (true) {
            long newMid;
            if (test.test(mid, a, b, c, d)) {
                to = mid;
                newMid = midpoint.applyAsLong(from, to);
                if (mid == newMid) {
                    return from;
                }
            } else {
                from = mid;
                newMid = midpoint.applyAsLong(from, to);
                if (mid == newMid) {
                    return to;
                }
            }
            mid = newMid;
        }
    }

    private static <A, B, C, D> int searchInt(int from, int to, A a, B b, C c, D d, IntBinaryOperator midpoint, IntIdxTestFunction<A, B, C, D> test) {
        int mid = midpoint.applyAsInt(from, to);
        while (true) {
            int newMid;
            if (test.test(mid, a, b, c, d)) {
                to = mid;
                newMid = midpoint.applyAsInt(from, to);
                if (mid == newMid) {
                    return from;
                }
            } else {
                from = mid;
                newMid = midpoint.applyAsInt(from, to);
                if (mid == newMid) {
                    return to;
                }
            }
            mid = newMid;
        }
    }

    public static final class IntRange {
        private final IntBinaryOperator midpoint;
        private final InCollection inCollection;
        private static final IntRange signed = new IntRange((x$0, x$1) -> BinarySearch.signedMidpoint(x$0, x$1));
        private static final IntRange unsigned = new IntRange((x$0, x$1) -> BinarySearch.unsignedMidpoint(x$0, x$1));

        private IntRange(IntBinaryOperator midpoint) {
            this.midpoint = midpoint;
            this.inCollection = new InCollection(midpoint);
        }

        public int find(int from, int to, IntPredicate test) {
            return BinarySearch.searchInt(from, to, test, null, null, null, this.midpoint, IntRange::find0);
        }

        private static boolean find0(int idx, IntPredicate test, Void ignored0, Void ignored1, Void ignored2) {
            return test.test(idx);
        }

        public IntRange signed() {
            return signed;
        }

        public IntRange unsigned() {
            return unsigned;
        }

        public CustomMidpoint customMidpoint() {
            return CustomMidpoint.instance;
        }

        public InCollection inCollection() {
            return this.inCollection;
        }

        public static final class InCollection {
            private final IntBinaryOperator midpoint;
            private final ByKey byKey;

            private InCollection(IntBinaryOperator midpoint) {
                this.midpoint = midpoint;
                this.byKey = new ByKey(midpoint);
            }

            public <C> int find(C collection, int from, int to, ObjIntPredicate<C> test) {
                return BinarySearch.searchInt(from, to, collection, test, null, null, this.midpoint, InCollection::find0);
            }

            public <L extends List<?>> int find(L list, ObjIntPredicate<L> test) {
                return this.find(list, 0, list.size(), test);
            }

            private static <C> boolean find0(int idx, C collection, ObjIntPredicate<C> test, Void ignored0, Void ignored1) {
                return test.test(collection, idx);
            }

            public ByKey byKey() {
                return this.byKey;
            }

            public static final class ByKey {
                private final IntBinaryOperator midpoint;

                private ByKey(IntBinaryOperator midpoint) {
                    this.midpoint = midpoint;
                }

                public <C, K> int find(C collection, int from, int to, ObjIntFunction<C, K> keyExtractor, Predicate<K> keyTester) {
                    return BinarySearch.searchInt(from, to, collection, keyExtractor, keyTester, null, this.midpoint, ByKey::find0);
                }

                private static <C, K> boolean find0(int idx, C collection, ObjIntFunction<C, K> keyExtractor, Predicate<K> keyTester, Void ignored) {
                    return keyTester.test(keyExtractor.apply(collection, idx));
                }

                public <C, K, V> int find(C collection, V searchVal, int from, int to, ObjIntFunction<C, K> keyExtractor, BiPredicate<V, K> keyTester) {
                    return BinarySearch.searchInt(from, to, collection, searchVal, keyExtractor, keyTester, this.midpoint, ByKey::find1);
                }

                private static <C, K, V> boolean find1(int idx, C collection, V searchVal, ObjIntFunction<C, K> keyExtractor, BiPredicate<V, K> keyTester) {
                    return keyTester.test(searchVal, keyExtractor.apply(collection, idx));
                }

                public <C, K extends Comparable<? super K>> int findFirst(C collection, K searchKey, int from, int to, ObjIntFunction<C, K> keyExtractor) {
                    return this.findFirst(collection, searchKey, from, to, keyExtractor, Comparator.naturalOrder());
                }

                public <C, K> int findFirst(C collection, K searchKey, int from, int to, ObjIntFunction<C, K> keyExtractor, Comparator<? super K> cmp) {
                    return BinarySearch.searchInt(from, to, collection, searchKey, keyExtractor, cmp, this.midpoint, ByKey::find2);
                }

                private static <C, K> boolean find2(int idx, C collection, K searchKey, ObjIntFunction<C, K> keyExtractor, Comparator<? super K> cmp) {
                    return cmp.compare(searchKey, keyExtractor.apply(collection, idx)) >= 0;
                }
            }
        }

        public static final class CustomMidpoint {
            private static final CustomMidpoint instance = new CustomMidpoint();

            private CustomMidpoint() {
            }

            public int find(int from, int to, IntBinaryOperator midpoint, IntPredicate test) {
                return BinarySearch.searchInt(from, to, test, null, null, null, midpoint, CustomMidpoint::find0);
            }

            private static boolean find0(int idx, IntPredicate test, Void ignored0, Void ignored1, Void ignored2) {
                return test.test(idx);
            }

            public InCollection inCollection() {
                return InCollection.instance;
            }

            public static final class InCollection {
                private static final InCollection instance = new InCollection();

                private InCollection() {
                }

                public <C> int find(C collection, int from, int to, IntBinaryOperator midpoint, ObjIntPredicate<C> test) {
                    return BinarySearch.searchInt(from, to, collection, test, null, null, midpoint, (x$0, x$1, x$2, x$3, x$4) -> io.smallrye.common.search.BinarySearch$IntRange$InCollection.find0(x$0, x$1, x$2, x$3, x$4));
                }

                public <L extends List<?>> int find(L list, IntBinaryOperator midpoint, ObjIntPredicate<L> test) {
                    return this.find(list, 0, list.size(), midpoint, test);
                }

                public ByKey byKey() {
                    return ByKey.instance;
                }

                public static final class ByKey {
                    private static final ByKey instance = new ByKey();

                    private ByKey() {
                    }

                    public <C, K> int find(C collection, int from, int to, IntBinaryOperator midpoint, ObjIntFunction<C, K> keyExtractor, Predicate<K> keyTester) {
                        return BinarySearch.searchInt(from, to, collection, keyExtractor, keyTester, null, midpoint, (x$0, x$1, x$2, x$3, x$4) -> io.smallrye.common.search.BinarySearch$IntRange$InCollection$ByKey.find0(x$0, x$1, x$2, x$3, x$4));
                    }

                    public <C, K, V> int find(C collection, V searchVal, int from, int to, IntBinaryOperator midpoint, ObjIntFunction<C, K> keyExtractor, BiPredicate<V, K> keyTester) {
                        return BinarySearch.searchInt(from, to, collection, searchVal, keyExtractor, keyTester, midpoint, (x$0, x$1, x$2, x$3, x$4) -> io.smallrye.common.search.BinarySearch$IntRange$InCollection$ByKey.find1(x$0, x$1, x$2, x$3, x$4));
                    }

                    public <C, K extends Comparable<? super K>> int findFirst(C collection, K searchKey, int from, int to, IntBinaryOperator midpoint, ObjIntFunction<C, K> keyExtractor) {
                        return this.findFirst(collection, searchKey, from, to, midpoint, keyExtractor, Comparator.naturalOrder());
                    }

                    public <C, K> int findFirst(C collection, K searchKey, int from, int to, IntBinaryOperator midpoint, ObjIntFunction<C, K> keyExtractor, Comparator<? super K> cmp) {
                        return BinarySearch.searchInt(from, to, collection, searchKey, keyExtractor, cmp, midpoint, (x$0, x$1, x$2, x$3, x$4) -> io.smallrye.common.search.BinarySearch$IntRange$InCollection$ByKey.find2(x$0, x$1, x$2, x$3, x$4));
                    }
                }
            }
        }
    }

    public static final class LongRange {
        private final LongBinaryOperator midpoint;
        private final InCollection inCollection;
        private static final LongRange signed = new LongRange((x$0, x$1) -> BinarySearch.signedMidpoint(x$0, x$1));
        private static final LongRange unsigned = new LongRange((x$0, x$1) -> BinarySearch.unsignedMidpoint(x$0, x$1));

        private LongRange(LongBinaryOperator midpoint) {
            this.midpoint = midpoint;
            this.inCollection = new InCollection(midpoint);
        }

        public long find(long from, long to, LongPredicate test) {
            return BinarySearch.searchLong(from, to, test, null, null, null, this.midpoint, LongRange::find0);
        }

        private static boolean find0(long idx, LongPredicate test, Void ignored0, Void ignored1, Void ignored2) {
            return test.test(idx);
        }

        public LongRange signed() {
            return signed;
        }

        public LongRange unsigned() {
            return unsigned;
        }

        public CustomMidpoint customMidpoint() {
            return CustomMidpoint.instance;
        }

        public InCollection inCollection() {
            return this.inCollection;
        }

        public static final class InCollection {
            private final LongBinaryOperator midpoint;
            private final ByKey byKey;

            private InCollection(LongBinaryOperator midpoint) {
                this.midpoint = midpoint;
                this.byKey = new ByKey(midpoint);
            }

            public <C> long find(C collection, long from, long to, ObjLongPredicate<C> test) {
                return BinarySearch.searchLong(from, to, collection, test, null, null, this.midpoint, InCollection::find0);
            }

            private static <C> boolean find0(long idx, C collection, ObjLongPredicate<C> test, Void ignored0, Void ignored1) {
                return test.test(collection, idx);
            }

            public ByKey byKey() {
                return this.byKey;
            }

            public static final class ByKey {
                private final LongBinaryOperator midpoint;

                private ByKey(LongBinaryOperator midpoint) {
                    this.midpoint = midpoint;
                }

                public <C, K> long find(C collection, long from, long to, ObjLongFunction<C, K> keyExtractor, Predicate<K> keyTester) {
                    return BinarySearch.searchLong(from, to, collection, keyExtractor, keyTester, null, this.midpoint, ByKey::find0);
                }

                private static <C, K> boolean find0(long idx, C collection, ObjLongFunction<C, K> keyExtractor, Predicate<K> keyTester, Void ignored) {
                    return keyTester.test(keyExtractor.apply(collection, idx));
                }

                public <C, K, V> long find(C collection, V searchVal, long from, long to, ObjLongFunction<C, K> keyExtractor, BiPredicate<V, K> keyTester) {
                    return BinarySearch.searchLong(from, to, collection, searchVal, keyExtractor, keyTester, this.midpoint, ByKey::find1);
                }

                private static <C, K, V> boolean find1(long idx, C collection, V searchVal, ObjLongFunction<C, K> keyExtractor, BiPredicate<V, K> keyTester) {
                    return keyTester.test(searchVal, keyExtractor.apply(collection, idx));
                }

                public <C, K extends Comparable<? super K>> long findFirst(C collection, K searchKey, long from, long to, ObjLongFunction<C, K> keyExtractor) {
                    return this.findFirst(collection, searchKey, from, to, keyExtractor, Comparator.naturalOrder());
                }

                public <C, K> long findFirst(C collection, K searchKey, long from, long to, ObjLongFunction<C, K> keyExtractor, Comparator<? super K> cmp) {
                    return BinarySearch.searchLong(from, to, collection, searchKey, keyExtractor, cmp, this.midpoint, ByKey::find2);
                }

                private static <C, K> boolean find2(long idx, C collection, K searchKey, ObjLongFunction<C, K> keyExtractor, Comparator<? super K> cmp) {
                    return cmp.compare(searchKey, keyExtractor.apply(collection, idx)) >= 0;
                }
            }
        }

        public static final class CustomMidpoint {
            private static final CustomMidpoint instance = new CustomMidpoint();

            private CustomMidpoint() {
            }

            public long find(long from, long to, LongBinaryOperator midpoint, LongPredicate test) {
                return BinarySearch.searchLong(from, to, test, null, null, null, midpoint, CustomMidpoint::find0);
            }

            private static boolean find0(long idx, LongPredicate test, Void ignored0, Void ignored1, Void ignored2) {
                return test.test(idx);
            }

            public InCollection inCollection() {
                return InCollection.instance;
            }

            public static final class InCollection {
                private static final InCollection instance = new InCollection();

                private InCollection() {
                }

                public <C> long find(C collection, long from, long to, LongBinaryOperator midpoint, ObjLongPredicate<C> test) {
                    return BinarySearch.searchLong(from, to, collection, test, null, null, midpoint, (x$0, x$1, x$2, x$3, x$4) -> io.smallrye.common.search.BinarySearch$LongRange$InCollection.find0(x$0, x$1, x$2, x$3, x$4));
                }

                public ByKey byKey() {
                    return ByKey.instance;
                }

                public static final class ByKey {
                    private static final ByKey instance = new ByKey();

                    private ByKey() {
                    }

                    public <C, K> long find(C collection, long from, long to, LongBinaryOperator midpoint, ObjLongFunction<C, K> keyExtractor, Predicate<K> keyTester) {
                        return BinarySearch.searchLong(from, to, collection, keyExtractor, keyTester, null, midpoint, (x$0, x$1, x$2, x$3, x$4) -> io.smallrye.common.search.BinarySearch$LongRange$InCollection$ByKey.find0(x$0, x$1, x$2, x$3, x$4));
                    }

                    public <C, K, V> long find(C collection, V searchVal, long from, long to, LongBinaryOperator midpoint, ObjLongFunction<C, K> keyExtractor, BiPredicate<V, K> keyTester) {
                        return BinarySearch.searchLong(from, to, collection, searchVal, keyExtractor, keyTester, midpoint, (x$0, x$1, x$2, x$3, x$4) -> io.smallrye.common.search.BinarySearch$LongRange$InCollection$ByKey.find1(x$0, x$1, x$2, x$3, x$4));
                    }

                    public <C, K extends Comparable<? super K>> long findFirst(C collection, K searchKey, long from, long to, LongBinaryOperator midpoint, ObjLongFunction<C, K> keyExtractor) {
                        return this.findFirst(collection, searchKey, from, to, midpoint, keyExtractor, Comparator.naturalOrder());
                    }

                    public <C, K> long findFirst(C collection, K searchKey, long from, long to, LongBinaryOperator midpoint, ObjLongFunction<C, K> keyExtractor, Comparator<? super K> cmp) {
                        return BinarySearch.searchLong(from, to, collection, searchKey, keyExtractor, cmp, midpoint, (x$0, x$1, x$2, x$3, x$4) -> io.smallrye.common.search.BinarySearch$LongRange$InCollection$ByKey.find2(x$0, x$1, x$2, x$3, x$4));
                    }
                }
            }
        }
    }

    public static final class ObjRange {
        private static final ObjRange instance = new ObjRange();

        private ObjRange() {
        }

        public <T> T find(T from, T to, BinaryOperator<T> midpoint, Predicate<T> test) {
            return (T)BinarySearch.searchObject(from, to, test, null, null, null, midpoint, ObjRange::find0);
        }

        private static <T> boolean find0(T idx, Predicate<T> test, Void ignored0, Void ignored1, Void ignored2) {
            return test.test(idx);
        }

        public static InCollection inCollection() {
            return InCollection.instance;
        }

        public static final class InCollection {
            private static final InCollection instance = new InCollection();

            private InCollection() {
            }

            public <T, C> T find(C collection, T from, T to, BinaryOperator<T> midpoint, BiPredicate<C, T> test) {
                return (T)BinarySearch.searchObject(from, to, collection, test, null, null, midpoint, InCollection::find0);
            }

            private static <T, C> boolean find0(T idx, C collection, BiPredicate<C, T> test, Void ignored0, Void ignored1) {
                return test.test(collection, idx);
            }

            public ByKey byKey() {
                return ByKey.instance;
            }

            public static final class ByKey {
                private static final ByKey instance = new ByKey();

                private ByKey() {
                }

                public <T, C, K> T find(C collection, T from, T to, BinaryOperator<T> midpoint, BiFunction<C, T, K> keyExtractor, Predicate<K> test) {
                    return (T)BinarySearch.searchObject(from, to, collection, keyExtractor, test, null, midpoint, ByKey::find0);
                }

                private static <T, C, K> boolean find0(T idx, C collection, BiFunction<C, T, K> keyExtractor, Predicate<K> test, Void ignored) {
                    return test.test(keyExtractor.apply(collection, idx));
                }

                public <T, C, K, V> T find(C collection, V searchVal, T from, T to, BinaryOperator<T> midpoint, BiFunction<C, T, K> keyExtractor, BiPredicate<V, K> keyTester) {
                    return (T)BinarySearch.searchObject(from, to, collection, searchVal, keyExtractor, keyTester, midpoint, ByKey::find1);
                }

                private static <T, C, K, V> boolean find1(T idx, C collection, V searchVal, BiFunction<C, T, K> keyExtractor, BiPredicate<V, K> test) {
                    return test.test(searchVal, keyExtractor.apply(collection, idx));
                }

                public <T, C, K extends Comparable<? super K>> T findFirst(C collection, K searchKey, T from, T to, BinaryOperator<T> midpoint, BiFunction<C, T, K> keyExtractor) {
                    return this.findFirst(collection, searchKey, from, to, midpoint, keyExtractor, Comparator.naturalOrder());
                }

                public <T, C, K> T findFirst(C collection, K searchKey, T from, T to, BinaryOperator<T> midpoint, BiFunction<C, T, K> keyExtractor, Comparator<? super K> cmp) {
                    return (T)BinarySearch.searchObject(from, to, collection, searchKey, keyExtractor, cmp, midpoint, ByKey::find2);
                }

                private static <T, C, K> boolean find2(T idx, C collection, K searchKey, BiFunction<C, T, K> keyExtractor, Comparator<? super K> cmp) {
                    return cmp.compare(searchKey, keyExtractor.apply(collection, idx)) >= 0;
                }
            }
        }
    }

    private static interface ObjIdxTestFunction<T, A, B, C, D> {
        public boolean test(T var1, A var2, B var3, C var4, D var5);
    }

    private static interface LongIdxTestFunction<A, B, C, D> {
        public boolean test(long var1, A var3, B var4, C var5, D var6);
    }

    private static interface IntIdxTestFunction<A, B, C, D> {
        public boolean test(int var1, A var2, B var3, C var4, D var5);
    }
}

