/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.common.ref;

import io.smallrye.common.ref.Reapable;
import io.smallrye.common.ref.Reaper;
import io.smallrye.common.ref.Reference;
import io.smallrye.common.ref.References;
import java.lang.ref.ReferenceQueue;

public class PhantomReference<T, A>
extends java.lang.ref.PhantomReference<T>
implements Reference<T, A>,
Reapable<T, A> {
    private final A attachment;
    private final Reaper<T, A> reaper;

    public PhantomReference(T referent, A attachment, ReferenceQueue<? super T> q) {
        super(referent, q);
        this.attachment = attachment;
        this.reaper = null;
    }

    public PhantomReference(T referent, A attachment, Reaper<T, A> reaper) {
        super(referent, References.ReaperThread.REAPER_QUEUE);
        this.reaper = reaper;
        this.attachment = attachment;
    }

    @Override
    public A getAttachment() {
        return this.attachment;
    }

    @Override
    public Reference.Type getType() {
        return Reference.Type.PHANTOM;
    }

    @Override
    public Reaper<T, A> getReaper() {
        return this.reaper;
    }

    public String toString() {
        return "phantom reference";
    }
}

