/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.common.process;

import io.smallrye.common.constraint.Assert;
import io.smallrye.common.function.ExceptionConsumer;
import io.smallrye.common.function.ExceptionFunction;
import io.smallrye.common.os.OS;
import io.smallrye.common.process.AbnormalExitException;
import io.smallrye.common.process.PipelineBuilder;
import io.smallrye.common.process.ProcessBuilder;
import io.smallrye.common.process.ProcessRunner;
import io.smallrye.common.process.WaitableProcessHandle;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.IntPredicate;
import java.util.stream.Stream;

final class ProcessBuilderImpl<O>
implements ProcessBuilder<O> {
    final java.lang.ProcessBuilder pb = new java.lang.ProcessBuilder(new String[0]);
    final ProcessBuilderImpl<?> prev;
    final int depth;
    final Path command;
    private volatile boolean locked;
    List<String> arguments = List.of();
    IntPredicate exitCodeChecker = e -> e == 0;
    Duration softExitTimeout = DEFAULT_SOFT_TIMEOUT;
    Duration hardExitTimeout = DEFAULT_HARD_TIMEOUT;
    private ProcessBuilder.Input<O> input;
    ExceptionConsumer<Process, IOException> inputHandler;
    Charset inputCharset;
    private PipelineBuilder.Output<O> output;
    ExceptionFunction<Process, O, IOException> outputHandler;
    Charset outputCharset;
    private PipelineBuilder.Error<O> error;
    ExceptionConsumer<BufferedReader, IOException> errorHandler;
    Charset errorCharset;
    int errorLineLimit = 256;
    boolean errorLogOnSuccess = true;
    boolean errorGatherOnFail = true;
    int errorHeadLines = 5;
    int errorTailLines = 5;
    Consumer<WaitableProcessHandle> whileRunning;

    private ProcessBuilderImpl(ProcessBuilderImpl<?> prev, Path command) {
        this.command = command;
        this.prev = prev;
        this.depth = prev.depth + 1;
        this.softExitTimeout = prev.softExitTimeout;
        this.hardExitTimeout = prev.hardExitTimeout;
        this.pb.redirectInput(ProcessBuilder.Redirect.PIPE);
        this.pb.redirectOutput(ProcessBuilder.Redirect.DISCARD);
        this.pb.redirectError(ProcessBuilder.Redirect.PIPE);
    }

    public ProcessBuilderImpl(Path command) {
        this.command = command;
        this.prev = null;
        this.depth = 1;
        this.pb.redirectInput(ProcessBuilder.Redirect.DISCARD.file());
        this.pb.redirectOutput(ProcessBuilder.Redirect.DISCARD);
        this.pb.redirectError(ProcessBuilder.Redirect.PIPE);
    }

    @Override
    public ProcessBuilder<O> arguments(List<String> arguments) {
        this.check();
        this.arguments = List.copyOf(arguments);
        return this;
    }

    @Override
    public ProcessBuilder<O> directory(Path directory) {
        this.check();
        this.pb.directory(((Path)Assert.checkNotNullParam((String)"directory", (Object)directory)).toFile());
        return this;
    }

    @Override
    public ProcessBuilder<O> modifyEnvironment(Consumer<Map<String, String>> action) {
        this.check();
        action.accept(this.pb.environment());
        return this;
    }

    @Override
    public ProcessBuilder.Input<O> input() {
        this.check();
        if (this.prev != null) {
            throw new UnsupportedOperationException("Input may not be reconfigured on this process builder because it is a stage in a pipeline");
        }
        InputImpl input = this.input;
        if (input == null) {
            input = this.input = new InputImpl();
        }
        return input;
    }

    @Override
    public PipelineBuilder.Output<O> output() {
        this.check();
        OutputImpl output = this.output;
        if (output == null) {
            output = this.output = new OutputImpl();
        }
        return output;
    }

    @Override
    public PipelineBuilder.Error<O> error() {
        this.check();
        ErrorImpl error = this.error;
        if (error == null) {
            error = this.error = new ErrorImpl();
        }
        return error;
    }

    @Override
    public ProcessBuilder<O> exitCodeChecker(IntPredicate checker) {
        this.check();
        this.exitCodeChecker = (IntPredicate)Assert.checkNotNullParam((String)"checker", (Object)checker);
        return this;
    }

    @Override
    public ProcessBuilder<O> softExitTimeout(Duration duration) {
        this.check();
        this.softExitTimeout = (Duration)Assert.checkNotNullParam((String)"duration", (Object)duration);
        return this;
    }

    @Override
    public ProcessBuilder<O> hardExitTimeout(Duration duration) {
        this.check();
        this.hardExitTimeout = (Duration)Assert.checkNotNullParam((String)"duration", (Object)duration);
        return this;
    }

    @Override
    public ProcessBuilder<O> whileRunning(Consumer<WaitableProcessHandle> action) {
        this.check();
        this.whileRunning = (Consumer)Assert.checkNotNullParam((String)"action", action);
        return this;
    }

    @Override
    public O run() {
        this.check();
        this.commitCommand();
        this.locked = true;
        return this.makeRunner().run();
    }

    private ProcessRunner<O> makeRunner() {
        return new ProcessRunner(this, this.prev == null ? null : this.prev.makeRunner());
    }

    private void check() {
        if (this.locked) {
            throw new IllegalStateException("This builder can no longer be configured");
        }
    }

    private void commitCommand() {
        String fileNameString;
        if (OS.current() == OS.WINDOWS && ((fileNameString = this.command.getFileName().toString()).endsWith(".bat") || fileNameString.endsWith(".cmd"))) {
            throw new UnsupportedOperationException("Execution of batch scripts on Windows is not yet supported");
        }
        Stream<String> stream = Stream.concat(Stream.of(this.command.toString()), this.arguments.stream());
        this.pb.command(stream.toList());
    }

    public final class InputImpl
    extends ViewImpl
    implements ProcessBuilder.Input<O> {
        @Override
        public ProcessBuilder.Input<O> empty() {
            ProcessBuilderImpl.this.check();
            ProcessBuilderImpl.this.pb.redirectInput(ProcessBuilder.Redirect.DISCARD.file());
            ProcessBuilderImpl.this.inputHandler = null;
            return this;
        }

        @Override
        public ProcessBuilder.Input<O> inherited() {
            ProcessBuilderImpl.this.check();
            ProcessBuilderImpl.this.pb.redirectInput(ProcessBuilder.Redirect.INHERIT);
            ProcessBuilderImpl.this.inputHandler = null;
            return this;
        }

        @Override
        public ProcessBuilder.Input<O> charset(Charset charset) {
            ProcessBuilderImpl.this.check();
            ProcessBuilderImpl.this.inputCharset = (Charset)Assert.checkNotNullParam((String)"charset", (Object)charset);
            return this;
        }

        @Override
        public ProcessBuilder.Input<O> nativeCharset() {
            ProcessBuilderImpl.this.check();
            ProcessBuilderImpl.this.inputCharset = null;
            return this;
        }

        @Override
        public ProcessBuilder.Input<O> transferFrom(Path path) {
            ProcessBuilderImpl.this.check();
            Assert.checkNotNullParam((String)"path", (Object)path);
            if (path.getFileSystem() == FileSystems.getDefault()) {
                ProcessBuilderImpl.this.pb.redirectInput(ProcessBuilder.Redirect.from(path.toFile()));
                ProcessBuilderImpl.this.inputHandler = null;
            } else {
                this.produceBytesWith((ExceptionConsumer<OutputStream, IOException>)((ExceptionConsumer)os -> {
                    try (InputStream is = Files.newInputStream(path, new OpenOption[0]);){
                        is.transferTo((OutputStream)os);
                    }
                }));
            }
            return this;
        }

        @Override
        public ProcessBuilder.Input<O> produceBytesWith(ExceptionConsumer<OutputStream, IOException> consumer) {
            ProcessBuilderImpl.this.check();
            Assert.checkNotNullParam((String)"consumer", consumer);
            ProcessBuilderImpl.this.inputHandler = proc -> {
                try (OutputStream os = proc.getOutputStream();){
                    consumer.accept((Object)os);
                }
            };
            ProcessBuilderImpl.this.pb.redirectInput(ProcessBuilder.Redirect.PIPE);
            return this;
        }

        @Override
        public ProcessBuilder.Input<O> produceWith(ExceptionConsumer<Writer, IOException> consumer) {
            ProcessBuilderImpl.this.check();
            Assert.checkNotNullParam((String)"consumer", consumer);
            ProcessBuilderImpl.this.inputHandler = proc -> {
                Charset inputCharset = ProcessBuilderImpl.this.inputCharset;
                if (inputCharset == null) {
                    try (BufferedWriter bw = proc.outputWriter();){
                        consumer.accept((Object)bw);
                    }
                }
                try (BufferedWriter bw = proc.outputWriter(inputCharset);){
                    consumer.accept((Object)bw);
                }
            };
            ProcessBuilderImpl.this.pb.redirectInput(ProcessBuilder.Redirect.PIPE);
            return this;
        }
    }

    public final class OutputImpl
    extends ViewImpl
    implements PipelineBuilder.Output<O> {
        @Override
        public PipelineBuilder.Output<Void> discard() {
            ProcessBuilderImpl.this.check();
            ProcessBuilderImpl.this.outputHandler = null;
            ProcessBuilderImpl.this.pb.redirectOutput(ProcessBuilder.Redirect.DISCARD);
            return this;
        }

        @Override
        public PipelineBuilder.Output<Void> inherited() {
            ProcessBuilderImpl.this.check();
            ProcessBuilderImpl.this.outputHandler = null;
            ProcessBuilderImpl.this.pb.redirectOutput(ProcessBuilder.Redirect.INHERIT);
            return this;
        }

        @Override
        public PipelineBuilder.Output<O> charset(Charset charset) {
            ProcessBuilderImpl.this.check();
            ProcessBuilderImpl.this.outputCharset = (Charset)Assert.checkNotNullParam((String)"charset", (Object)charset);
            return this;
        }

        @Override
        public PipelineBuilder.Output<O> nativeCharset() {
            ProcessBuilderImpl.this.check();
            ProcessBuilderImpl.this.outputCharset = null;
            return this;
        }

        @Override
        public PipelineBuilder.Output<String> toSingleString(int maxChars) {
            ProcessBuilderImpl.this.check();
            return this.processWith(br -> {
                long res;
                int ch;
                StringBuilder sb = new StringBuilder(Math.min(192, maxChars));
                for (int n = 0; n < maxChars; ++n) {
                    ch = br.read();
                    if (ch == -1) {
                        return sb.toString();
                    }
                    sb.append((char)ch);
                }
                while ((res = br.skip(Integer.MAX_VALUE)) != 0L || (ch = br.read()) != -1) {
                }
                return sb.toString();
            });
        }

        @Override
        public PipelineBuilder.Output<List<String>> toStringList(int maxLines) {
            ProcessBuilderImpl.this.check();
            return this.processWith(br -> {
                String line;
                ArrayList<String> list = new ArrayList<String>(Math.min(maxLines, 16));
                while ((line = br.readLine()) != null) {
                    list.add(line);
                }
                return List.copyOf(list);
            });
        }

        @Override
        public <O2> PipelineBuilder.Output<O2> processBytesWith(ExceptionFunction<InputStream, O2, IOException> processor) {
            ProcessBuilderImpl.this.check();
            Assert.checkNotNullParam((String)"processor", processor);
            ProcessBuilderImpl.this.pb.redirectOutput(ProcessBuilder.Redirect.PIPE);
            ProcessBuilderImpl.this.outputHandler = proc -> {
                try (InputStream is = proc.getInputStream();){
                    Object object = processor.apply((Object)is);
                    return object;
                }
            };
            return this;
        }

        @Override
        public <O2> PipelineBuilder.Output<O2> processWith(ExceptionFunction<BufferedReader, O2, IOException> processor) {
            ProcessBuilderImpl.this.check();
            Assert.checkNotNullParam((String)"processor", processor);
            ProcessBuilderImpl.this.pb.redirectOutput(ProcessBuilder.Redirect.PIPE);
            ProcessBuilderImpl.this.outputHandler = proc -> {
                Charset outputCharset = ProcessBuilderImpl.this.outputCharset;
                if (outputCharset == null) {
                    try (BufferedReader br = proc.inputReader();){
                        Object object = processor.apply((Object)br);
                        return object;
                    }
                }
                try (BufferedReader br = proc.inputReader(outputCharset);){
                    Object object = processor.apply((Object)br);
                    return object;
                }
            };
            return this;
        }

        @Override
        public PipelineBuilder.Output<Void> transferTo(Path path) {
            this.transferTo(path, false);
            return this;
        }

        @Override
        public PipelineBuilder.Output<Void> appendTo(Path path) {
            this.transferTo(path, true);
            return this;
        }

        private void transferTo(Path path, boolean append) {
            ProcessBuilderImpl.this.check();
            Assert.checkNotNullParam((String)"path", (Object)path);
            if (path.getFileSystem() == FileSystems.getDefault()) {
                ProcessBuilderImpl.this.pb.redirectOutput(append ? ProcessBuilder.Redirect.appendTo(path.toFile()) : ProcessBuilder.Redirect.to(path.toFile()));
                ProcessBuilderImpl.this.outputHandler = null;
            } else {
                this.processBytesWith(is -> {
                    try (OutputStream os = append ? Files.newOutputStream(path, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.APPEND) : Files.newOutputStream(path, new OpenOption[0]);){
                        is.transferTo(os);
                    }
                    return null;
                });
            }
        }

        @Override
        public PipelineBuilder<Void> pipeTo(Path command) {
            ProcessBuilderImpl.this.check();
            ProcessBuilderImpl.this.pb.redirectOutput(ProcessBuilder.Redirect.PIPE);
            ProcessBuilderImpl.this.commitCommand();
            ProcessBuilderImpl.this.outputHandler = null;
            ProcessBuilderImpl.this.locked = true;
            return new ProcessBuilderImpl<Void>(ProcessBuilderImpl.this, command);
        }
    }

    public final class ErrorImpl
    extends ViewImpl
    implements PipelineBuilder.Error<O> {
        @Override
        public PipelineBuilder.Error<O> discard() {
            ProcessBuilderImpl.this.errorHandler = null;
            return this;
        }

        @Override
        public PipelineBuilder.Error<O> inherited() {
            this.consumeWith((ExceptionConsumer<BufferedReader, IOException>)((ExceptionConsumer)br -> {
                String line;
                while ((line = br.readLine()) != null) {
                    System.err.println(line);
                }
            }));
            return this;
        }

        @Override
        public PipelineBuilder.Error<O> charset(Charset charset) {
            ProcessBuilderImpl.this.errorCharset = (Charset)Assert.checkNotNullParam((String)"charset", (Object)charset);
            return this;
        }

        @Override
        public PipelineBuilder.Error<O> nativeCharset() {
            ProcessBuilderImpl.this.errorCharset = null;
            return this;
        }

        @Override
        public PipelineBuilder.Error<O> logOnSuccess(boolean log) {
            ProcessBuilderImpl.this.errorLogOnSuccess = log;
            return this;
        }

        @Override
        public PipelineBuilder.Error<O> gatherOnFail(boolean gather) {
            ProcessBuilderImpl.this.errorGatherOnFail = gather;
            return this;
        }

        @Override
        public PipelineBuilder.Error<O> maxLineLength(int characters) {
            ProcessBuilderImpl.this.errorLineLimit = characters;
            return this;
        }

        @Override
        public PipelineBuilder.Error<O> captureHeadLines(int headLines) {
            ProcessBuilderImpl.this.errorHeadLines = headLines;
            return this;
        }

        @Override
        public PipelineBuilder.Error<O> captureTailLines(int tailLines) {
            ProcessBuilderImpl.this.errorTailLines = tailLines;
            return this;
        }

        @Override
        public PipelineBuilder.Error<O> transferTo(Path path) {
            this.consumeWith((ExceptionConsumer<BufferedReader, IOException>)((ExceptionConsumer)br -> {
                try (BufferedWriter bw = Files.newBufferedWriter(path, new OpenOption[0]);){
                    String line;
                    while ((line = br.readLine()) != null) {
                        bw.write(line);
                        bw.write(System.lineSeparator());
                    }
                }
            }));
            return this;
        }

        @Override
        public PipelineBuilder.Error<O> appendTo(Path path) {
            this.consumeWith((ExceptionConsumer<BufferedReader, IOException>)((ExceptionConsumer)br -> {
                try (BufferedWriter bw = Files.newBufferedWriter(path, StandardOpenOption.CREATE, StandardOpenOption.APPEND);){
                    String line;
                    while ((line = br.readLine()) != null) {
                        bw.write(line);
                        bw.write(System.lineSeparator());
                    }
                }
            }));
            return this;
        }

        @Override
        public PipelineBuilder.Error<O> consumeWith(ExceptionConsumer<BufferedReader, IOException> processor) {
            Assert.checkNotNullParam((String)"processor", processor);
            ProcessBuilderImpl.this.errorHandler = processor;
            return this;
        }

        @Override
        public PipelineBuilder.Error<O> redirect() {
            ProcessBuilderImpl.this.pb.redirectErrorStream(true);
            ProcessBuilderImpl.this.errorHandler = null;
            return this;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public abstract class ViewImpl
    implements ProcessBuilder<O> {
        @Override
        public ProcessBuilder<O> arguments(List<String> command) {
            return ProcessBuilderImpl.this.arguments((List)command);
        }

        @Override
        public ProcessBuilder<O> directory(Path directory) {
            return ProcessBuilderImpl.this.directory(directory);
        }

        @Override
        public ProcessBuilder<O> modifyEnvironment(Consumer<Map<String, String>> action) {
            return ProcessBuilderImpl.this.modifyEnvironment((Consumer)action);
        }

        @Override
        public ProcessBuilder.Input<O> input() {
            return ProcessBuilderImpl.this.input();
        }

        @Override
        public PipelineBuilder.Output<O> output() {
            return ProcessBuilderImpl.this.output();
        }

        @Override
        public PipelineBuilder.Error<O> error() {
            return ProcessBuilderImpl.this.error();
        }

        @Override
        public O run() throws AbnormalExitException {
            return ProcessBuilderImpl.this.run();
        }

        @Override
        public ProcessBuilder<O> exitCodeChecker(IntPredicate checker) {
            return ProcessBuilderImpl.this.exitCodeChecker(checker);
        }

        @Override
        public ProcessBuilder<O> softExitTimeout(Duration duration) {
            return ProcessBuilderImpl.this.softExitTimeout(duration);
        }

        @Override
        public ProcessBuilder<O> hardExitTimeout(Duration duration) {
            return ProcessBuilderImpl.this.hardExitTimeout(duration);
        }

        @Override
        public ProcessBuilder<O> whileRunning(Consumer<WaitableProcessHandle> action) {
            return ProcessBuilderImpl.this.whileRunning((Consumer)action);
        }
    }
}

