/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.common.process;

import io.smallrye.common.constraint.Assert;
import io.smallrye.common.function.ExceptionConsumer;
import io.smallrye.common.process.PipelineBuilder;
import io.smallrye.common.process.ProcessBuilderImpl;
import io.smallrye.common.process.WaitableProcessHandle;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.IntPredicate;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface ProcessBuilder<O>
extends PipelineBuilder<O> {
    public static final Duration DEFAULT_SOFT_TIMEOUT = Duration.of(5L, ChronoUnit.SECONDS);
    public static final Duration DEFAULT_HARD_TIMEOUT = Duration.of(30L, ChronoUnit.SECONDS);

    public static void exec(Path command, String ... args) {
        ProcessBuilder.exec(command, List.of(args));
    }

    public static void exec(Path command, List<String> args) {
        ProcessBuilder.newBuilder(command).arguments((List)args).run();
    }

    public static void exec(String command, String ... args) {
        ProcessBuilder.exec(Path.of(command, new String[0]), args);
    }

    public static void exec(String command, List<String> args) {
        ProcessBuilder.exec(Path.of(command, new String[0]), args);
    }

    public static String execToString(Path command, String ... args) {
        return ProcessBuilder.execToString(command, List.of(args));
    }

    public static String execToString(Path command, List<String> args) {
        return (String)ProcessBuilder.newBuilder(command).arguments((List)args).output().toSingleString(65536).run();
    }

    public static String execToString(String command, String ... args) {
        return ProcessBuilder.execToString(Path.of(command, new String[0]), args);
    }

    public static String execToString(String command, List<String> args) {
        return ProcessBuilder.execToString(Path.of(command, new String[0]), args);
    }

    public static ProcessBuilder<Void> newBuilder(Path command) {
        return new ProcessBuilderImpl<Void>((Path)Assert.checkNotNullParam((String)"command", (Object)command));
    }

    public static ProcessBuilder<Void> newBuilder(Path command, List<String> args) {
        return ProcessBuilder.newBuilder(command).arguments((List)args);
    }

    public static ProcessBuilder<Void> newBuilder(Path command, String ... args) {
        return ProcessBuilder.newBuilder(command).arguments(args);
    }

    public static ProcessBuilder<Void> newBuilder(String command) {
        return ProcessBuilder.newBuilder(Path.of(command, new String[0]));
    }

    public static ProcessBuilder<Void> newBuilder(String command, List<String> args) {
        return ProcessBuilder.newBuilder(Path.of(command, new String[0]), args);
    }

    public static ProcessBuilder<Void> newBuilder(String command, String ... args) {
        return ProcessBuilder.newBuilder(Path.of(command, new String[0]), args);
    }

    @Override
    public ProcessBuilder<O> arguments(List<String> var1);

    @Override
    default public ProcessBuilder<O> arguments(String ... command) {
        return this.arguments((List)List.of(command));
    }

    @Override
    public ProcessBuilder<O> directory(Path var1);

    @Override
    default public ProcessBuilder<O> environment(Map<String, String> newEnvironment) {
        Assert.checkNotNullParam((String)"newEnvironment", newEnvironment);
        return this.modifyEnvironment((T env) -> {
            env.clear();
            env.putAll(newEnvironment);
        });
    }

    @Override
    public ProcessBuilder<O> modifyEnvironment(Consumer<Map<String, String>> var1);

    @Override
    public ProcessBuilder<O> exitCodeChecker(IntPredicate var1);

    @Override
    public ProcessBuilder<O> whileRunning(Consumer<WaitableProcessHandle> var1);

    public Input<O> input();

    public ProcessBuilder<O> softExitTimeout(Duration var1);

    public ProcessBuilder<O> hardExitTimeout(Duration var1);

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface Input<O>
    extends ProcessBuilder<O> {
        public Input<O> empty();

        public Input<O> inherited();

        public Input<O> charset(Charset var1);

        public Input<O> nativeCharset();

        default public Input<O> fromString(String string) {
            return this.produceWith((ExceptionConsumer<Writer, IOException>)((ExceptionConsumer)w -> w.write(string)));
        }

        default public Input<O> fromStrings(Collection<?> strings) {
            return this.produceWith((ExceptionConsumer<Writer, IOException>)((ExceptionConsumer)w -> {
                for (Object s : strings) {
                    w.write(String.valueOf(s));
                    w.write(System.lineSeparator());
                }
            }));
        }

        default public Input<O> transferFrom(InputStream stream) {
            return this.produceBytesWith((ExceptionConsumer<OutputStream, IOException>)((ExceptionConsumer)stream::transferTo));
        }

        default public Input<O> transferFrom(Reader reader) {
            return this.produceWith((ExceptionConsumer<Writer, IOException>)((ExceptionConsumer)reader::transferTo));
        }

        public Input<O> transferFrom(Path var1);

        public Input<O> produceBytesWith(ExceptionConsumer<OutputStream, IOException> var1);

        public Input<O> produceWith(ExceptionConsumer<Writer, IOException> var1);
    }
}

