/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.common.process;

import io.smallrye.common.function.ExceptionConsumer;
import io.smallrye.common.function.Functions;
import io.smallrye.common.process.AbnormalExitException;
import io.smallrye.common.process.Gatherer;
import io.smallrye.common.process.LineProcessor;
import io.smallrye.common.process.Logging;
import io.smallrye.common.process.ProcessBuilderImpl;
import io.smallrye.common.process.ProcessExecutionException;
import io.smallrye.common.process.ProcessHandlerException;
import io.smallrye.common.process.ProcessRunner;
import io.smallrye.common.process.ProcessUtil;
import io.smallrye.common.process.QueueReader;
import io.smallrye.common.process.WaitableProcessHandle;
import io.smallrye.common.process.WaitableProcessHandleImpl;
import java.io.BufferedReader;
import java.io.IOException;
import java.lang.invoke.ConstantBootstraps;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.charset.Charset;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.locks.LockSupport;
import java.util.function.Consumer;

class PipelineRunner<O> {
    private static final VarHandle ioBitsHandle = ConstantBootstraps.fieldVarHandle(MethodHandles.lookup(), "ioBits", VarHandle.class, PipelineRunner.class, Integer.TYPE);
    static final int IO_INPUT = 1;
    static final int IO_OUTPUT = 2;
    static final int IO_ERROR = 4;
    static final int IO_USER_ERROR = 8;
    static final int IO_WHILE_RUNNING = 16;
    final ProcessBuilderImpl<O> processBuilder;
    final PipelineRunner<?> prev;
    private volatile int ioBits;
    private Thread inputThread;
    private Thread errorReaderThread;
    private Thread userErrorThread;
    private Thread whileRunningThread;
    private Thread waitForThread;
    private ProcessHandlerException inputProblem;
    private ProcessHandlerException errorProblem;
    private ProcessHandlerException userErrorProblem;
    private ProcessHandlerException whileRunningProblem;
    private ProcessHandlerException exitCheckerProblem;
    private AbnormalExitException abnormalExit;
    Process process;
    private Gatherer gatherer;

    PipelineRunner(ProcessBuilderImpl<O> processBuilder, PipelineRunner<?> prev) {
        this.processBuilder = processBuilder;
        this.prev = prev;
    }

    void assembleBuilders(ProcessBuilder[] array) {
        array[this.processBuilder.depth - 1] = this.processBuilder.pb;
        if (this.prev != null) {
            this.prev.assembleBuilders(array);
        }
    }

    void setProcesses(List<Process> list) {
        this.process = list.get(this.processBuilder.depth - 1);
        if (this.prev != null) {
            this.prev.setProcesses(list);
        }
    }

    int createInputThread(ThreadFactory tf, ProcessRunner<?> runner) throws IOException {
        ExceptionConsumer<Process, IOException> inputHandler = this.processBuilder.inputHandler;
        if (inputHandler != null) {
            this.inputThread = tf.newThread(() -> {
                if (runner.awaitOk()) {
                    Thread.currentThread().setName("process-input-\"%s\"-%d".formatted(this.processBuilder.command, this.process.pid()));
                    try {
                        inputHandler.accept((Object)this.process);
                    }
                    catch (ProcessHandlerException phe) {
                        this.inputProblem = phe;
                    }
                    catch (Throwable t) {
                        this.inputProblem = new ProcessHandlerException("Input generation failed due to exception", t);
                    }
                    finally {
                        this.ioDone(1);
                        runner.taskComplete();
                    }
                }
            });
            if (this.inputThread == null) {
                throw PipelineRunner.noThread(tf);
            }
            this.inputThread.setName("process-input-\"%s\"-???".formatted(this.processBuilder.command));
            this.ioRegistered(1);
            return 1;
        }
        return 0;
    }

    int createErrorThreads(ThreadFactory tf, ProcessRunner<?> runner) throws IOException {
        Consumer<Object> consumer;
        this.gatherer = new Gatherer(this.processBuilder.errorHeadLines, this.processBuilder.errorTailLines);
        ExceptionConsumer<BufferedReader, IOException> eh = this.processBuilder.errorHandler;
        if (eh != null) {
            QueueReader qr = new QueueReader();
            consumer = this.processBuilder.errorGatherOnFail ? this.gatherer.andThen(qr::handleLine) : qr::handleLine;
            this.userErrorThread = tf.newThread(() -> {
                if (runner.awaitOk()) {
                    Thread.currentThread().setName("process-user-error-\"%s\"-%d".formatted(this.processBuilder.command, this.process.pid()));
                    try {
                        eh.accept((Object)qr);
                    }
                    catch (ProcessHandlerException phe) {
                        this.userErrorProblem = phe;
                    }
                    catch (Throwable t) {
                        this.userErrorProblem = new ProcessHandlerException("User error processing failed due to exception", t);
                    }
                    finally {
                        this.ioDone(8);
                        runner.taskComplete();
                    }
                }
            });
            if (this.userErrorThread == null) {
                throw PipelineRunner.noThread(tf);
            }
            this.userErrorThread.setName("process-user-error-\"%s\"-???".formatted(this.processBuilder.command));
            this.ioRegistered(8);
        } else {
            consumer = this.processBuilder.errorGatherOnFail ? this.gatherer : Functions.discardingConsumer();
        }
        this.errorReaderThread = tf.newThread(() -> {
            block20: {
                if (runner.awaitOk()) {
                    Thread.currentThread().setName("process-error-reader-\"%s\"-%d".formatted(this.processBuilder.command, this.process.pid()));
                    try {
                        Charset errorCharset = this.processBuilder.errorCharset;
                        if (errorCharset == null) {
                            try (BufferedReader reader = this.process.errorReader();){
                                LineProcessor proc = new LineProcessor(reader, this.processBuilder.errorLineLimit, consumer);
                                proc.run();
                                break block20;
                            }
                        }
                        try (BufferedReader reader = this.process.errorReader(errorCharset);){
                            LineProcessor proc = new LineProcessor(reader, this.processBuilder.errorLineLimit, consumer);
                            proc.run();
                        }
                    }
                    catch (ProcessHandlerException phe) {
                        throw phe;
                    }
                    catch (Throwable t) {
                        this.errorProblem = new ProcessHandlerException("Error processing failed due to exception", t);
                    }
                    finally {
                        this.ioDone(4);
                        runner.taskComplete();
                    }
                }
            }
        });
        if (this.errorReaderThread == null) {
            throw PipelineRunner.noThread(tf);
        }
        this.errorReaderThread.setName("process-error-reader-\"%s\"-???".formatted(this.processBuilder.command));
        this.ioRegistered(4);
        return eh == null ? 1 : 2;
    }

    int createWhileRunningThread(ThreadFactory tf, ProcessRunner<?> runner) throws IOException {
        Consumer<WaitableProcessHandle> whileRunning = this.processBuilder.whileRunning;
        if (whileRunning != null) {
            this.whileRunningThread = tf.newThread(() -> {
                if (runner.awaitOk()) {
                    Thread.currentThread().setName("process-while-running-\"%s\"-%d".formatted(this.processBuilder.command, this.process.pid()));
                    try {
                        whileRunning.accept(new WaitableProcessHandleImpl(this.process, this.processBuilder.command, this.processBuilder.arguments));
                    }
                    catch (ProcessHandlerException phe) {
                        this.whileRunningProblem = phe;
                    }
                    catch (Throwable t) {
                        this.whileRunningProblem = new ProcessHandlerException("While-running task failed due to exception", t);
                    }
                    finally {
                        this.ioDone(16);
                        runner.taskComplete();
                    }
                }
            });
            this.whileRunningThread.setName("process-while-running-\"%s\"-???".formatted(this.processBuilder.command));
            this.ioRegistered(16);
            if (this.whileRunningThread == null) {
                throw PipelineRunner.noThread(tf);
            }
            return 1;
        }
        return 0;
    }

    int createWaitForThread(ThreadFactory tf, ProcessRunner<?> runner) throws IOException {
        this.waitForThread = tf.newThread(() -> {
            block19: {
                if (runner.awaitOk()) {
                    Thread.currentThread().setName("process-waiter-\"%s\"-%d".formatted(this.processBuilder.command, this.process.pid()));
                    try {
                        boolean result;
                        int exitCode;
                        boolean ste = false;
                        boolean hte = false;
                        this.awaitIoDone();
                        if (this.process.isAlive() && this.processBuilder.softExitTimeout != null && ProcessUtil.stillRunningAfter(this.process, this.processBuilder.softExitTimeout.get(ChronoUnit.NANOS))) {
                            ste = true;
                            if (this.process.supportsNormalTermination()) {
                                this.process.destroy();
                            }
                        }
                        if (this.process.isAlive() && this.processBuilder.hardExitTimeout != null && ProcessUtil.stillRunningAfter(this.process, this.processBuilder.hardExitTimeout.get(ChronoUnit.NANOS))) {
                            hte = true;
                            ProcessUtil.destroyAllForcibly(this.process.toHandle());
                        }
                        while (true) {
                            try {
                                exitCode = this.process.waitFor();
                            }
                            catch (InterruptedException interruptedException) {
                                continue;
                            }
                            break;
                        }
                        List<String> errorLines = this.gatherer.toList();
                        try {
                            result = this.processBuilder.exitCodeChecker.test(exitCode);
                        }
                        catch (ProcessHandlerException phe) {
                            this.exitCheckerProblem = phe;
                            runner.taskComplete();
                            return;
                        }
                        catch (Throwable t) {
                            this.exitCheckerProblem = new ProcessHandlerException("Exit code checker task failed due to exception", t);
                            runner.taskComplete();
                            return;
                        }
                        if (!result) {
                            AbnormalExitException aee = new AbnormalExitException("Process exited abnormally");
                            aee.setExitCode(exitCode);
                            aee.setSoftTimeoutElapsed(ste);
                            aee.setHardTimeoutElapsed(hte);
                            if (this.processBuilder.errorGatherOnFail) {
                                aee.setErrorOutput(errorLines);
                            }
                            aee.setCommand(this.processBuilder.command);
                            aee.setArguments(this.processBuilder.arguments);
                            aee.setPid(this.process.pid());
                            this.abnormalExit = aee;
                        } else if (this.processBuilder.errorLogOnSuccess && !errorLines.isEmpty()) {
                            StringBuilder sb = new StringBuilder(512);
                            errorLines.forEach(line -> sb.append("\n\t").append((String)line));
                            Logging.log.logErrors(this.processBuilder.command, this.process.pid(), sb);
                        }
                        break block19;
                        {
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                    }
                    finally {
                        runner.taskComplete();
                    }
                }
            }
        });
        if (this.waitForThread == null) {
            throw PipelineRunner.noThread(tf);
        }
        this.waitForThread.setName("process-waiter-\"%s\"-???".formatted(this.processBuilder.command));
        return 1;
    }

    void startThreads() {
        PipelineRunner.startThread(this.inputThread);
        PipelineRunner.startThread(this.errorReaderThread);
        PipelineRunner.startThread(this.userErrorThread);
        PipelineRunner.startThread(this.whileRunningThread);
        PipelineRunner.startThread(this.waitForThread);
        if (this.prev != null) {
            this.prev.startThreads();
        }
    }

    static void startThread(Thread thread) {
        if (thread != null) {
            thread.start();
        }
    }

    private void awaitIoDone() {
        int ioBits = this.ioBits;
        while (ioBits != 0) {
            LockSupport.park(this);
            ioBits = this.ioBits;
        }
    }

    void ioRegistered(int bit) {
        this.ioBits |= bit;
    }

    void ioDone(int bit) {
        int oldVal = ioBitsHandle.getAndBitwiseAnd(this, ~bit);
        if (oldVal == bit) {
            LockSupport.unpark(this.waitForThread);
        }
    }

    static IOException noThread(ThreadFactory tf) {
        return new IOException("Thread factory %s did not create a thread".formatted(tf));
    }

    void unpark() {
        LockSupport.unpark(this.inputThread);
        LockSupport.unpark(this.errorReaderThread);
        LockSupport.unpark(this.userErrorThread);
        LockSupport.unpark(this.whileRunningThread);
        LockSupport.unpark(this.waitForThread);
        if (this.prev != null) {
            this.prev.unpark();
        }
    }

    void collectProblems(List<ProcessExecutionException> problems, ProcessHandlerException outputProblem) {
        ProcessExecutionException pe;
        if (this.prev != null) {
            this.prev.collectProblems(problems, null);
        }
        if ((pe = this.abnormalExit) == null && (this.inputProblem != null || this.exitCheckerProblem != null || this.errorProblem != null || this.userErrorProblem != null || this.whileRunningProblem != null || outputProblem != null)) {
            pe = this.newProcessException("Process handle failure");
        }
        if (pe != null) {
            ArrayList<ProcessHandlerException> causes = new ArrayList<ProcessHandlerException>(6);
            if (this.inputProblem != null) {
                causes.add(this.inputProblem);
            }
            if (outputProblem != null) {
                causes.add(outputProblem);
            }
            if (this.errorProblem != null) {
                causes.add(this.errorProblem);
            }
            if (this.userErrorProblem != null) {
                causes.add(this.userErrorProblem);
            }
            if (this.whileRunningProblem != null) {
                causes.add(this.whileRunningProblem);
            }
            if (this.exitCheckerProblem != null) {
                causes.add(this.exitCheckerProblem);
            }
            switch (causes.size()) {
                case 0: {
                    break;
                }
                case 1: {
                    pe.initCause((Throwable)causes.get(0));
                    break;
                }
                default: {
                    causes.forEach(pe::addSuppressed);
                }
            }
            problems.add(pe);
        }
    }

    ProcessExecutionException newProcessException(String message, Throwable cause) {
        ProcessExecutionException pe = this.newProcessException(message);
        pe.initCause(cause);
        return pe;
    }

    ProcessExecutionException newProcessException(String message) {
        ProcessExecutionException pe = new ProcessExecutionException(message);
        if (this.process != null) {
            pe.setPid(this.process.pid());
        }
        pe.setCommand(this.processBuilder.command);
        pe.setArguments(this.processBuilder.arguments);
        return pe;
    }

    int createThreads(ThreadFactory tf, ProcessRunner<?> runner) throws IOException {
        int cnt = this.createInputThread(tf, runner) + this.createErrorThreads(tf, runner) + this.createWhileRunningThread(tf, runner) + this.createWaitForThread(tf, runner);
        return this.prev == null ? cnt : cnt + this.prev.createThreads(tf, runner);
    }
}

