/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.common.process;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Stream;

final class Gatherer
implements Consumer<Object> {
    private final int headLines;
    private final int tailLines;
    private final ArrayList<String> head;
    private final ArrayDeque<String> tail;
    private int skipped;

    Gatherer(int headLines, int tailLines) {
        this.headLines = headLines;
        this.head = new ArrayList(headLines);
        this.tailLines = tailLines;
        this.tail = new ArrayDeque(tailLines);
    }

    @Override
    public void accept(Object obj) {
        if (obj instanceof String) {
            String line = (String)obj;
            if (this.head.size() < this.headLines) {
                this.head.add(line);
            } else if (this.tailLines > 0) {
                if (this.tail.size() == this.tailLines) {
                    this.tail.removeFirst();
                    ++this.skipped;
                }
                this.tail.addLast(line);
            } else {
                ++this.skipped;
            }
        }
    }

    public List<String> toList() {
        Optional opt = this.skipped == 0 ? Optional.empty() : Optional.of("\u2026 (skipped " + this.skipped + " line(s)) \u2026");
        return Stream.concat(Stream.concat(this.head.stream(), opt.stream()), this.tail.stream()).toList();
    }
}

