/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.common.process;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
enum ArgumentRule {
    DEFAULT{

        @Override
        void checkArguments(List<String> arguments) throws IllegalArgumentException {
        }

        @Override
        List<String> formatArguments(Path command, List<String> arguments) throws IllegalArgumentException {
            return Stream.concat(Stream.of(command.toString()), arguments.stream()).toList();
        }
    }
    ,
    BATCH{

        @Override
        void checkArguments(List<String> arguments) throws IllegalArgumentException {
            for (String argument : arguments) {
                int cp;
                int len = argument.length();
                if (len == 0) {
                    throw this.invalidCharacter(argument, 0);
                }
                boolean qs = argument.startsWith("\"");
                boolean qe = argument.endsWith("\"");
                if (qs && !qe) {
                    throw this.invalidCharacter(argument, 0);
                }
                if (qe && !qs) {
                    throw this.invalidCharacter(argument, argument.length() - 1);
                }
                for (int i = 0; i < len; i += Character.charCount(cp)) {
                    cp = argument.codePointAt(i);
                    if (!Character.isISOControl(cp) && cp != 37) continue;
                    throw this.invalidCharacter(argument, i);
                }
            }
        }

        @Override
        List<String> formatArguments(Path command, List<String> arguments) throws IllegalArgumentException {
            ArrayList<String> list = new ArrayList<String>(arguments.size() + 5);
            StringBuilder sb = new StringBuilder();
            list.add(this.quote(command.toString(), sb));
            for (String argument : arguments) {
                list.add(this.quote(argument, sb));
            }
            return list;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String quote(String str, StringBuilder sb) {
            int cp;
            if (str.startsWith("\"") && str.endsWith("\"")) {
                str = str.substring(1, str.length() - 1);
            }
            boolean quoting = false;
            int start = sb.length();
            block6: for (int i = 0; i < str.length(); i += Character.charCount(cp)) {
                cp = str.codePointAt(i);
                switch (cp) {
                    case 33: 
                    case 34: 
                    case 38: 
                    case 39: 
                    case 43: 
                    case 44: 
                    case 59: 
                    case 60: 
                    case 61: 
                    case 62: 
                    case 91: 
                    case 93: 
                    case 94: 
                    case 96: 
                    case 123: 
                    case 125: 
                    case 126: {
                        sb.append('^').appendCodePoint(cp);
                        if (quoting) continue block6;
                        quoting = true;
                        sb.insert(start, '\"');
                        continue block6;
                    }
                    default: {
                        sb.appendCodePoint(cp);
                    }
                }
            }
            if (quoting) {
                sb.append('\"');
            }
            try {
                String string = sb.toString();
                return string;
            }
            finally {
                sb.setLength(0);
            }
        }
    }
    ,
    POWERSHELL{

        @Override
        void checkArguments(List<String> arguments) throws IllegalArgumentException {
        }

        @Override
        List<String> formatArguments(Path command, List<String> arguments) throws IllegalArgumentException {
            return Stream.concat(Stream.of("powershell.exe", "-ExecutionPolicy", "Bypass", "-File", command.toString()), arguments.stream()).toList();
        }
    };


    IllegalArgumentException invalidCharacter(String argument, int idx) {
        return new IllegalArgumentException("Argument \"%s\" has an invalid character at index %d for argument rule %s".formatted(new Object[]{argument, idx, this}));
    }

    abstract void checkArguments(List<String> var1) throws IllegalArgumentException;

    abstract List<String> formatArguments(Path var1, List<String> var2) throws IllegalArgumentException;
}

