/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.certs;

import io.smallrye.certs.AliasRequest;
import io.smallrye.certs.Format;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class CertificateRequest {
    private String name;
    private String password;
    private List<Format> formats = new ArrayList<Format>();
    private Duration duration = Duration.ofDays(2L);
    private String cn = "localhost";
    private boolean client = false;
    private final Map<String, AliasRequest> aliases = new HashMap<String, AliasRequest>();
    private final List<String> sans = new ArrayList<String>();
    private boolean signed;
    private Issuer issuer;

    public CertificateRequest withName(String name) {
        this.name = name;
        return this;
    }

    public CertificateRequest withPassword(String password) {
        this.password = password;
        return this;
    }

    public CertificateRequest withFormats(List<Format> formats) {
        this.formats = formats;
        return this;
    }

    public CertificateRequest withFormat(Format format) {
        this.formats.add(format);
        return this;
    }

    public CertificateRequest withDuration(Duration duration) {
        this.duration = duration;
        return this;
    }

    public CertificateRequest withCN(String cn) {
        this.cn = cn;
        return this;
    }

    public CertificateRequest withClientCertificate() {
        this.client = true;
        return this;
    }

    public CertificateRequest withClientCertificate(boolean client) {
        this.client = client;
        return this;
    }

    public CertificateRequest withSubjectAlternativeName(String name) {
        this.sans.add(name);
        return this;
    }

    public CertificateRequest withAlias(String alias, AliasRequest request) {
        if (alias.equals(this.name)) {
            throw new IllegalArgumentException("The alias cannot be the same as the name of the main certificate");
        }
        this.aliases.put(alias, request);
        return this;
    }

    public CertificateRequest signedWith(X509Certificate issuer, PrivateKey issuerPrivateKey) {
        this.signed = true;
        this.issuer = new Issuer(issuer, issuerPrivateKey);
        return this;
    }

    void validate() {
        if (this.cn == null || this.cn.isEmpty()) {
            this.cn = "localhost";
        }
    }

    public String getCN() {
        return this.cn;
    }

    public Duration getDuration() {
        return this.duration;
    }

    public String name() {
        return this.name;
    }

    public String getPassword() {
        return this.password;
    }

    public List<Format> formats() {
        return this.formats;
    }

    public boolean hasClient() {
        return this.client;
    }

    public List<String> getSubjectAlternativeNames() {
        return this.sans;
    }

    public Map<String, AliasRequest> aliases() {
        return this.aliases;
    }

    public boolean isSelfSigned() {
        return !this.signed;
    }

    public Issuer issuer() {
        return this.issuer;
    }

    public record Issuer(X509Certificate issuer, PrivateKey issuerPrivateKey) {
    }
}

