package io.slugstack.publishingplugin

import io.slugstack.publishingplugin.core.ProjectType
import io.slugstack.publishingplugin.license.LicensePlugin
import nebula.plugin.contacts.ContactsPlugin
import nebula.plugin.info.InfoPlugin
import nebula.plugin.publishing.publications.JavadocJarPlugin
import nebula.plugin.publishing.publications.SourceJarPlugin
import nebula.plugin.release.NetflixOssStrategies
import nebula.plugin.release.ReleasePlugin
import nebula.plugin.release.git.base.ReleasePluginExtension
import org.gradle.api.Plugin
import org.gradle.api.Project

/**
 * Entrypoint to chain our other configurations
 */
class ProjectPublishingPlugin implements Plugin<Project> {
    @Override
    void apply(Project project) {
        ProjectType type = new ProjectType(project)

        if (type.isLeafProject || type.isRootProject) {
            // release plugin
            project.pluginManager.apply(ReleasePlugin.class)
            if (type.isRootProject) {
                ReleasePluginExtension releaseExtension = project.extensions.findByType(ReleasePluginExtension)
                releaseExtension?.defaultVersionStrategy = NetflixOssStrategies.SNAPSHOT(project)
            }
            if (type.isLeafProject) {
                project.pluginManager.apply(JavadocJarPlugin.class)
                project.pluginManager.apply(SourceJarPlugin.class)
            }
        }

        // project properties
        if (!project.group) {
            project.group = "io.slugstack.oss"
        }
        if (!project.description) {
            project.description = project.name
        }

        // contacts
        project.pluginManager.apply(ContactsPlugin.class)
        if (type.isRootProject) {
            if (!project.contacts) {
                project.contacts {
                    'aegershman@gmail.com' {
                        github 'aegershman'
                        moniker 'Aaron Gershman'
                    }
                }
            }
        }

        project.pluginManager.apply(InfoPlugin.class)

        if (type.isLeafProject) {
            project.pluginManager.apply(LicensePlugin.class) // our license plugin delegate
        }

    }
}
