package io.slugstack.publishingplugin

import nebula.plugin.release.NetflixOssStrategies
import nebula.plugin.release.ReleasePlugin
import nebula.plugin.release.git.base.ReleasePluginExtension
import org.gradle.api.Plugin
import org.gradle.api.Project

/**
 * Plugin applied only to the root project that controls version calculation and adds `snapshot`, `candidate`, and `final` tasks.
 */
class SlugstackVersioningPlugin implements Plugin<Project> {
    @Override
    void apply(Project project) {
        project.plugins.apply ReleasePlugin

        ReleasePluginExtension releaseExtension = project.extensions.findByType(ReleasePluginExtension)
        releaseExtension?.defaultVersionStrategy = NetflixOssStrategies.SNAPSHOT(project)

//        project.extensions.findByType(ReleasePluginExtension).with {
//            defaultVersionStrategy = NetflixOssStrategies.SNAPSHOT(project)
//        }
    }
}
