package io.slugstack.publishingplugin

import nebula.plugin.contacts.ContactsPlugin
import nebula.plugin.info.InfoPlugin
import nebula.plugin.publishing.maven.license.MavenApacheLicensePlugin
import nebula.plugin.publishing.publications.JavadocJarPlugin
import nebula.plugin.publishing.publications.SourceJarPlugin
import org.gradle.api.Plugin
import org.gradle.api.Project

/**
 * Entrypoint to chain our other configurations
 */
class SlugstackPublishingPlugin implements Plugin<Project> {
    @Override
    void apply(Project project) {
        project.pluginManager.apply(SlugstackVersioningPlugin.class)
        project.pluginManager.apply(ProjectPropertiesPlugin.class)

        project.pluginManager.apply(ContactsPlugin.class)
        if (!project.contacts) {
            project.contacts {
                'aaron@moderne.io' {
                    github 'aegershman'
                    moniker 'Aaron Gershman'
                }
            }
        }
        project.pluginManager.apply(InfoPlugin.class)
        project.pluginManager.apply(MavenApacheLicensePlugin.class)
        project.pluginManager.apply(JavadocJarPlugin.class)
        project.pluginManager.apply(SourceJarPlugin.class)
    }
}
