package io.slugstack.publishingplugin;

import io.slugstack.publishingplugin.demo.DemoTask;
import io.slugstack.publishingplugin.github.InitGithubActionsCiTask;
import io.slugstack.publishingplugin.github.InitGithubActionsGradleWrapperValidationTask;
import io.slugstack.publishingplugin.github.InitGithubActionsPublishTask;
import io.slugstack.publishingplugin.github.InitGithubDependabotTask;
import org.gradle.api.Plugin;
import org.gradle.api.Project;

/**
 * A "*Plugin" is considered the entrypoint to the actual logic which performs stuff, whereas
 * a "*PluginExtension" is where we store off data enabling configuration to be overridden by downstream users.
 */
public class SlugstackPublishingPlugin implements Plugin<Project> {
    @Override
    public void apply(Project project) {
        // note that in this case, the configuration block in the build.gradle would be referenced as "demoSetting {...}"
        project.getExtensions().create("demoSetting", SlugstackPublishingPluginExtension.class);
        project.getTasks().create("demo", DemoTask.class);
        project.getTasks().create("initGithubDependabot", InitGithubDependabotTask.class);
        project.getTasks().create("initGithubActionsCi", InitGithubActionsCiTask.class);
        project.getTasks().create("initGithubActionsGradleWrapperValidation", InitGithubActionsGradleWrapperValidationTask.class);
        project.getTasks().create("initGithubActionsPublish", InitGithubActionsPublishTask.class);

        // chain our other configurations
        project.getPluginManager().apply(SlugstackVersioningPlugin.class);
    }
}
