/*
 * Decompiled with CFR 0.152.
 */
package io.skygear.plugins.chat.ui.utils;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.util.Base64;
import android.widget.ImageView;
import com.squareup.picasso.Picasso;
import com.squareup.picasso.RequestCreator;
import com.squareup.picasso.Transformation;
import io.skygear.plugins.chat.ui.utils.AvatarBuilder;
import io.skygear.plugins.chat.ui.utils.ImageLoaderKt;
import io.skygear.plugins.chat.ui.utils.ImageUtilsKt;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001c\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016JG\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00102\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00132\b\u0010\u0015\u001a\u0004\u0018\u00010\u0013\u00a2\u0006\u0002\u0010\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0017"}, d2={"Lio/skygear/plugins/chat/ui/utils/ImageLoader;", "Lio/skygear/chatkit/commons/ImageLoader;", "context", "Landroid/content/Context;", "avatarBuilder", "Lio/skygear/plugins/chat/ui/utils/AvatarBuilder;", "(Landroid/content/Context;Lio/skygear/plugins/chat/ui/utils/AvatarBuilder;)V", "getAvatarBuilder", "()Lio/skygear/plugins/chat/ui/utils/AvatarBuilder;", "getContext", "()Landroid/content/Context;", "loadImage", "", "imageView", "Landroid/widget/ImageView;", "url", "", "thumbnail", "width", "", "height", "orientation", "(Landroid/widget/ImageView;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Integer;)V", "chat_ui_release"})
public final class ImageLoader
implements io.skygear.chatkit.commons.ImageLoader {
    @NotNull
    private final Context context;
    @NotNull
    private final AvatarBuilder avatarBuilder;

    public void loadImage(@Nullable ImageView imageView, @Nullable String url) {
        if (url == null) {
            return;
        }
        if (this.avatarBuilder.isValidAvatarBuilderUri(url)) {
            Bitmap bm = this.avatarBuilder.avatarForUri(url);
            ImageView imageView2 = imageView;
            if (imageView2 != null) {
                imageView2.setImageBitmap(bm);
            }
            return;
        }
        RequestCreator creator = Picasso.with((Context)this.context).load(url);
        creator.into(imageView);
    }

    /*
     * WARNING - void declaration
     */
    public final void loadImage(@Nullable ImageView imageView, @Nullable String url, @Nullable String thumbnail, @Nullable Integer width, @Nullable Integer height, @Nullable Integer orientation) {
        void matrix;
        Ref.ObjectRef bitmap;
        Charset charset;
        String imageDataBytes;
        void creator;
        double w;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = Picasso.with((Context)this.context).load(url);
        Integer n = height;
        double h = n != null ? (double)n.intValue() : 0.0;
        Integer n2 = width;
        double d = w = n2 != null ? (double)n2.intValue() : 0.0;
        if (0.0 < h && 0.0 < w) {
            ImageView imageView2;
            ImageView imageView3;
            if (h > ImageLoaderKt.access$getDISPLAY_IMAGE_SIZE$p() || w > ImageLoaderKt.access$getDISPLAY_IMAGE_SIZE$p()) {
                double ratio = h / w;
                if (ratio > 1.0) {
                    h = ImageLoaderKt.access$getDISPLAY_IMAGE_SIZE$p();
                    w = ImageLoaderKt.access$getDISPLAY_IMAGE_SIZE$p() / ratio;
                } else {
                    h = ImageLoaderKt.access$getDISPLAY_IMAGE_SIZE$p() * ratio;
                    w = ImageLoaderKt.access$getDISPLAY_IMAGE_SIZE$p();
                }
            }
            if ((imageView3 = imageView) != null && (imageView3 = imageView3.getLayoutParams()) != null) {
                imageView3.height = (int)h;
            }
            if ((imageView2 = imageView) != null && (imageView2 = imageView2.getLayoutParams()) != null) {
                imageView2.width = (int)w;
            }
            ((RequestCreator)creator.element).fit().centerInside();
        }
        if ((imageDataBytes = thumbnail) != null) {
            String string2 = imageDataBytes;
            charset = Charsets.UTF_8;
            byte[] byArray = string2.getBytes(charset);
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            byte[] bytes = Base64.decode((byte[])byArray, (int)0);
            bitmap = BitmapFactory.decodeByteArray((byte[])bytes, (int)0, (int)bytes.length);
            if (bitmap != null) {
                ((RequestCreator)creator.element).placeholder((Drawable)new BitmapDrawable(this.context.getResources(), (Bitmap)bitmap));
            }
        }
        Integer n3 = orientation;
        int o = n3 != null ? n3 : 1;
        bitmap = new Ref.ObjectRef();
        bitmap.element = ImageUtilsKt.matrixFromRotation(o);
        Matrix matrix2 = (Matrix)matrix.element;
        if (matrix2 != null) {
            Charset it = charset = matrix2;
            ((RequestCreator)creator.element).transform(new Transformation((Ref.ObjectRef)creator, (Ref.ObjectRef)matrix){
                final /* synthetic */ Ref.ObjectRef $creator$inlined;
                final /* synthetic */ Ref.ObjectRef $matrix$inlined;
                {
                    this.$creator$inlined = objectRef;
                    this.$matrix$inlined = objectRef2;
                }

                @NotNull
                public String key() {
                    return "orientation";
                }

                @NotNull
                public Bitmap transform(@Nullable Bitmap source) {
                    Bitmap bitmap = source;
                    if (bitmap == null) {
                        Intrinsics.throwNpe();
                    }
                    Bitmap bmRotated = Bitmap.createBitmap((Bitmap)source, (int)0, (int)0, (int)bitmap.getWidth(), (int)source.getHeight(), (Matrix)((Matrix)this.$matrix$inlined.element), (boolean)true);
                    source.recycle();
                    Bitmap bitmap2 = bmRotated;
                    Intrinsics.checkExpressionValueIsNotNull((Object)bitmap2, (String)"bmRotated");
                    return bitmap2;
                }
            });
        }
        ((RequestCreator)creator.element).into(imageView);
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @NotNull
    public final AvatarBuilder getAvatarBuilder() {
        return this.avatarBuilder;
    }

    public ImageLoader(@NotNull Context context, @NotNull AvatarBuilder avatarBuilder) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)avatarBuilder, (String)"avatarBuilder");
        this.context = context;
        this.avatarBuilder = avatarBuilder;
    }
}

