/*
 * Decompiled with CFR 0.152.
 */
package io.skygear.plugins.chat.ui.holder;

import android.content.Context;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.v4.content.ContextCompat;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import io.skygear.chatkit.R;
import io.skygear.plugins.chat.ui.R;
import io.skygear.plugins.chat.ui.model.Message;
import io.skygear.plugins.chat.ui.model.MessageBubbleStyle;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\u0011\u001a\u0004\u0018\u00010\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0015R\u0013\u0010\u0016\u001a\u0004\u0018\u00010\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0014\u00a8\u0006\u001f"}, d2={"Lio/skygear/plugins/chat/ui/holder/BaseBubbleMessageView;", "", "itemView", "Landroid/view/View;", "drawable", "", "isIncoming", "", "(Landroid/view/View;IZ)V", "background", "Landroid/graphics/drawable/Drawable;", "getBackground", "()Landroid/graphics/drawable/Drawable;", "bubble", "Landroid/view/ViewGroup;", "getBubble", "()Landroid/view/ViewGroup;", "durationText", "Landroid/widget/TextView;", "getDurationText", "()Landroid/widget/TextView;", "()Z", "messageText", "getMessageText", "backgroundColor", "style", "Lio/skygear/plugins/chat/ui/model/MessageBubbleStyle;", "onBind", "", "message", "Lio/skygear/plugins/chat/ui/model/Message;", "chat_ui_release"})
public class BaseBubbleMessageView {
    @Nullable
    private final ViewGroup bubble;
    @NotNull
    private final Drawable background;
    private final boolean isIncoming;
    @Nullable
    private final TextView messageText;
    @Nullable
    private final TextView durationText;

    @Nullable
    public final ViewGroup getBubble() {
        return this.bubble;
    }

    @NotNull
    public final Drawable getBackground() {
        return this.background;
    }

    public final boolean isIncoming() {
        return this.isIncoming;
    }

    @Nullable
    public final TextView getMessageText() {
        return this.messageText;
    }

    @Nullable
    public final TextView getDurationText() {
        return this.durationText;
    }

    public final void onBind(@NotNull Message message) {
        block4: {
            Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
            int color2 = this.backgroundColor(message.getStyle().getBubbleStyle());
            if (Build.VERSION.SDK_INT >= 21) {
                DrawableCompat.setTint((Drawable)this.background, (int)color2);
            } else {
                this.background.mutate().setColorFilter(color2, PorterDuff.Mode.SRC_IN);
            }
            ViewGroup viewGroup = this.bubble;
            if (viewGroup != null) {
                viewGroup.setBackground(this.background);
            }
            int textColor = this.isIncoming ? message.getStyle().getBubbleStyle().getTextColorForIncomingMessages() : message.getStyle().getBubbleStyle().getTextColorForOutgoingMessages();
            TextView textView = this.messageText;
            if (textView != null) {
                textView.setTextColor(textColor);
            }
            TextView textView2 = this.durationText;
            if (textView2 == null) break block4;
            textView2.setTextColor(textColor);
        }
    }

    public int backgroundColor(@NotNull MessageBubbleStyle style) {
        Intrinsics.checkParameterIsNotNull((Object)style, (String)"style");
        return -1;
    }

    public BaseBubbleMessageView(@NotNull View itemView, int drawable, boolean isIncoming) {
        Intrinsics.checkParameterIsNotNull((Object)itemView, (String)"itemView");
        this.bubble = (ViewGroup)itemView.findViewById(R.id.bubble);
        this.messageText = (TextView)itemView.findViewById(R.id.messageText);
        this.durationText = (TextView)itemView.findViewById(R.id.duration);
        Drawable drawable2 = ContextCompat.getDrawable((Context)itemView.getContext(), (int)drawable);
        Intrinsics.checkExpressionValueIsNotNull((Object)drawable2, (String)"ContextCompat.getDrawabl\u2026emView.context, drawable)");
        Drawable drawable3 = drawable2.getConstantState().newDrawable();
        Intrinsics.checkExpressionValueIsNotNull((Object)drawable3, (String)"ContextCompat.getDrawabl\u2026nstantState.newDrawable()");
        this.background = drawable3;
        this.isIncoming = isIncoming;
    }
}

