/*
 * Decompiled with CFR 0.152.
 */
package io.skygear.plugins.chat.ui.utils;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.util.Base64;
import android.widget.ImageView;
import com.squareup.picasso.Picasso;
import com.squareup.picasso.RequestCreator;
import com.squareup.picasso.Transformation;
import io.skygear.plugins.chat.ui.utils.AvatarBuilder;
import io.skygear.plugins.chat.ui.utils.ImageLoaderKt;
import io.skygear.plugins.chat.ui.utils.ImageUtilsKt;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001c\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0011"}, d2={"Lio/skygear/plugins/chat/ui/utils/ImageLoader;", "Lio/skygear/chatkit/commons/ImageLoader;", "context", "Landroid/content/Context;", "avatarBuilder", "Lio/skygear/plugins/chat/ui/utils/AvatarBuilder;", "(Landroid/content/Context;Lio/skygear/plugins/chat/ui/utils/AvatarBuilder;)V", "getAvatarBuilder", "()Lio/skygear/plugins/chat/ui/utils/AvatarBuilder;", "getContext", "()Landroid/content/Context;", "loadImage", "", "imageView", "Landroid/widget/ImageView;", "url", "", "chat_ui_release"})
public final class ImageLoader
implements io.skygear.chatkit.commons.ImageLoader {
    @NotNull
    private final Context context;
    @NotNull
    private final AvatarBuilder avatarBuilder;

    /*
     * WARNING - void declaration
     */
    public void loadImage(@Nullable ImageView imageView, @Nullable String url) {
        void matrix;
        int n;
        String bitmap;
        Charset charset;
        String imageDataBytes;
        void creator;
        double width;
        double d;
        double d2;
        if (url == null) {
            return;
        }
        if (this.avatarBuilder.isValidAvatarBuilderUri(url)) {
            Bitmap bm = this.avatarBuilder.avatarForUri(url);
            ImageView imageView2 = imageView;
            if (imageView2 != null) {
                imageView2.setImageBitmap(bm);
            }
            return;
        }
        Ref.ObjectRef bm = new Ref.ObjectRef();
        bm.element = Picasso.with((Context)this.context).load(url);
        Uri builtUri = Uri.parse((String)url);
        String string2 = builtUri.getQueryParameter("height");
        if (string2 != null) {
            String string3 = string2;
            d2 = Double.parseDouble(string3);
        } else {
            d2 = 0.0;
        }
        double height = d2;
        String string4 = builtUri.getQueryParameter("width");
        if (string4 != null) {
            String string5 = string4;
            d = Double.parseDouble(string5);
        } else {
            d = width = 0.0;
        }
        if (0.0 < height && 0.0 < width) {
            ImageView imageView3;
            ImageView imageView4;
            if (height > ImageLoaderKt.access$getDISPLAY_IMAGE_SIZE$p() || width > ImageLoaderKt.access$getDISPLAY_IMAGE_SIZE$p()) {
                double ratio = height / width;
                if (ratio > 1.0) {
                    height = ImageLoaderKt.access$getDISPLAY_IMAGE_SIZE$p();
                    width = ImageLoaderKt.access$getDISPLAY_IMAGE_SIZE$p() / ratio;
                } else {
                    height = ImageLoaderKt.access$getDISPLAY_IMAGE_SIZE$p() * ratio;
                    width = ImageLoaderKt.access$getDISPLAY_IMAGE_SIZE$p();
                }
            }
            if ((imageView4 = imageView) != null && (imageView4 = imageView4.getLayoutParams()) != null) {
                imageView4.height = (int)height;
            }
            if ((imageView3 = imageView) != null && (imageView3 = imageView3.getLayoutParams()) != null) {
                imageView3.width = (int)width;
            }
            ((RequestCreator)creator.element).fit().centerInside();
        }
        if ((imageDataBytes = builtUri.getQueryParameter("thumbnail")) != null) {
            String string6 = imageDataBytes;
            charset = Charsets.UTF_8;
            byte[] byArray = string6.getBytes(charset);
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            byte[] bytes = Base64.decode((byte[])byArray, (int)0);
            bitmap = BitmapFactory.decodeByteArray((byte[])bytes, (int)0, (int)bytes.length);
            if (bitmap != null) {
                ((RequestCreator)creator.element).placeholder((Drawable)new BitmapDrawable(this.context.getResources(), (Bitmap)bitmap));
            }
        }
        String string7 = builtUri.getQueryParameter("orientation");
        if (string7 != null) {
            bitmap = string7;
            n = Integer.parseInt(bitmap);
        } else {
            n = 1;
        }
        int orientation = n;
        bitmap = new Ref.ObjectRef();
        ((Ref.ObjectRef)bitmap).element = ImageUtilsKt.matrixFromRotation(orientation);
        Matrix matrix2 = (Matrix)matrix.element;
        if (matrix2 != null) {
            Charset it = charset = matrix2;
            ((RequestCreator)creator.element).transform(new Transformation((Ref.ObjectRef)creator, (Ref.ObjectRef)matrix){
                final /* synthetic */ Ref.ObjectRef $creator$inlined;
                final /* synthetic */ Ref.ObjectRef $matrix$inlined;
                {
                    this.$creator$inlined = objectRef;
                    this.$matrix$inlined = objectRef2;
                }

                @NotNull
                public String key() {
                    return "orientation";
                }

                @NotNull
                public Bitmap transform(@Nullable Bitmap source) {
                    Bitmap bitmap = source;
                    if (bitmap == null) {
                        Intrinsics.throwNpe();
                    }
                    Bitmap bmRotated = Bitmap.createBitmap((Bitmap)source, (int)0, (int)0, (int)bitmap.getWidth(), (int)source.getHeight(), (Matrix)((Matrix)this.$matrix$inlined.element), (boolean)true);
                    source.recycle();
                    Bitmap bitmap2 = bmRotated;
                    Intrinsics.checkExpressionValueIsNotNull((Object)bitmap2, (String)"bmRotated");
                    return bitmap2;
                }
            });
        }
        ((RequestCreator)creator.element).into(imageView);
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @NotNull
    public final AvatarBuilder getAvatarBuilder() {
        return this.avatarBuilder;
    }

    public ImageLoader(@NotNull Context context, @NotNull AvatarBuilder avatarBuilder) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)avatarBuilder, (String)"avatarBuilder");
        this.context = context;
        this.avatarBuilder = avatarBuilder;
    }
}

