/*
 * Decompiled with CFR 0.152.
 */
package io.skygear.plugins.chat.ui;

import android.util.SparseArray;
import io.skygear.chatkit.commons.ImageLoader;
import io.skygear.chatkit.messages.MessageHolders;
import io.skygear.chatkit.messages.MessagesListAdapter;
import io.skygear.chatkit.utils.DateFormatter;
import io.skygear.plugins.chat.ui.model.Message;
import io.skygear.plugins.chat.ui.model.User;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SortedMessageListAdapter
extends MessagesListAdapter<Message> {
    public SortedMessageListAdapter(String senderId, MessageHolders holders, ImageLoader imageLoader) {
        super(senderId, holders, imageLoader);
    }

    public void merge(List<Message> messages) {
        this.merge(messages, new Comparator<Message>(){

            @Override
            public int compare(Message m1, Message m2) {
                return m2.getCreatedAt().compareTo(m1.getCreatedAt());
            }
        });
    }

    public void merge(List<Message> messages, final Comparator<Message> comparator) {
        for (Message message : messages) {
            this.items.add(new MessagesListAdapter.Wrapper((MessagesListAdapter)this, (Object)message));
        }
        this.removeDateHeaders();
        Collections.sort(this.items, new Comparator<MessagesListAdapter.Wrapper>(){

            @Override
            public int compare(MessagesListAdapter.Wrapper o1, MessagesListAdapter.Wrapper o2) {
                Message m1 = (Message)o1.item;
                Message m2 = (Message)o2.item;
                return comparator.compare(m1, m2);
            }
        });
        this.regenerateDateHeaders();
        this.notifyDataSetChanged();
    }

    public void updateMessagesAuthor(Map<String, User> authors) {
        for (MessagesListAdapter.Wrapper item : this.items) {
            Message message;
            String ownerId;
            User author;
            if (!(item.item instanceof Message) || (author = authors.get(ownerId = (message = (Message)item.item).getChatMessage().getRecord().getOwnerId())) == null) continue;
            message.setAuthor(author);
        }
        this.notifyDataSetChanged();
    }

    private void removeDateHeaders() {
        Iterator each = this.items.iterator();
        while (each.hasNext()) {
            MessagesListAdapter.Wrapper next = (MessagesListAdapter.Wrapper)each.next();
            if (!(next.item instanceof Date)) continue;
            each.remove();
        }
    }

    private void regenerateDateHeaders() {
        int i;
        ArrayList<Integer> indicesToInsert = new ArrayList<Integer>();
        SparseArray indicesOfDate = new SparseArray();
        for (i = 0; i < this.items.size(); ++i) {
            Message message = (Message)((MessagesListAdapter.Wrapper)this.items.get((int)i)).item;
            if (this.items.size() > i + 1) {
                Message nextMessage = (Message)((MessagesListAdapter.Wrapper)this.items.get((int)(i + 1))).item;
                if (DateFormatter.isSameDay((Date)message.getCreatedAt(), (Date)nextMessage.getCreatedAt())) continue;
                indicesToInsert.add(i + 1);
                indicesOfDate.put(i + 1, (Object)message.getCreatedAt());
                continue;
            }
            indicesToInsert.add(i + 1);
            indicesOfDate.put(i + 1, (Object)message.getCreatedAt());
        }
        for (i = indicesToInsert.size() - 1; i >= 0; --i) {
            Integer index = (Integer)indicesToInsert.get(i);
            Date date = (Date)indicesOfDate.get(index.intValue());
            if (date == null) continue;
            this.items.add(index, new MessagesListAdapter.Wrapper((MessagesListAdapter)this, (Object)date));
        }
    }
}

