/*
 * Decompiled with CFR 0.152.
 */
package io.skygear.plugins.chat.ui.utils;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.util.Base64;
import android.widget.ImageView;
import com.squareup.picasso.Picasso;
import com.squareup.picasso.RequestCreator;
import io.skygear.plugins.chat.ui.utils.AvatarBuilder;
import io.skygear.plugins.chat.ui.utils.ImageLoaderKt;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001c\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0011"}, d2={"Lio/skygear/plugins/chat/ui/utils/ImageLoader;", "Lio/skygear/chatkit/commons/ImageLoader;", "context", "Landroid/content/Context;", "avatarBuilder", "Lio/skygear/plugins/chat/ui/utils/AvatarBuilder;", "(Landroid/content/Context;Lio/skygear/plugins/chat/ui/utils/AvatarBuilder;)V", "getAvatarBuilder", "()Lio/skygear/plugins/chat/ui/utils/AvatarBuilder;", "getContext", "()Landroid/content/Context;", "loadImage", "", "imageView", "Landroid/widget/ImageView;", "url", "", "chat_ui_release"})
public final class ImageLoader
implements io.skygear.chatkit.commons.ImageLoader {
    @NotNull
    private final Context context;
    @NotNull
    private final AvatarBuilder avatarBuilder;

    public void loadImage(@Nullable ImageView imageView, @Nullable String url) {
        String imageDataBytes;
        double width;
        double d;
        double d2;
        if (url == null) {
            return;
        }
        if (this.avatarBuilder.isValidAvatarBuilderUri(url)) {
            Bitmap bm = this.avatarBuilder.avatarForUri(url);
            ImageView imageView2 = imageView;
            if (imageView2 != null) {
                imageView2.setImageBitmap(bm);
            }
            return;
        }
        RequestCreator creator = Picasso.with((Context)this.context).load(url);
        Uri builtUri = Uri.parse((String)url);
        String string2 = builtUri.getQueryParameter("height");
        if (string2 != null) {
            String string3 = string2;
            d2 = Double.parseDouble(string3);
        } else {
            d2 = 0.0;
        }
        double height = d2;
        String string4 = builtUri.getQueryParameter("width");
        if (string4 != null) {
            String string5 = string4;
            d = Double.parseDouble(string5);
        } else {
            d = width = 0.0;
        }
        if (0.0 < height && 0.0 < width) {
            ImageView imageView3;
            ImageView imageView4;
            if (height > ImageLoaderKt.access$getDISPLAY_IMAGE_SIZE$p() || width > ImageLoaderKt.access$getDISPLAY_IMAGE_SIZE$p()) {
                double ratio = height / width;
                if (ratio > 1.0) {
                    height = ImageLoaderKt.access$getDISPLAY_IMAGE_SIZE$p();
                    width = ImageLoaderKt.access$getDISPLAY_IMAGE_SIZE$p() / ratio;
                } else {
                    height = ImageLoaderKt.access$getDISPLAY_IMAGE_SIZE$p() * ratio;
                    width = ImageLoaderKt.access$getDISPLAY_IMAGE_SIZE$p();
                }
            }
            if ((imageView4 = imageView) != null && (imageView4 = imageView4.getLayoutParams()) != null) {
                imageView4.height = (int)height;
            }
            if ((imageView3 = imageView) != null && (imageView3 = imageView3.getLayoutParams()) != null) {
                imageView3.width = (int)width;
            }
            creator.fit().centerCrop();
        }
        if ((imageDataBytes = builtUri.getQueryParameter("thumbnail")) != null) {
            String string6 = imageDataBytes;
            Charset charset = Charsets.UTF_8;
            byte[] byArray = string6.getBytes(charset);
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            byte[] bytes = Base64.decode((byte[])byArray, (int)0);
            Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])bytes, (int)0, (int)bytes.length);
            if (bitmap != null) {
                creator.placeholder((Drawable)new BitmapDrawable(this.context.getResources(), bitmap));
            }
        }
        creator.into(imageView);
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @NotNull
    public final AvatarBuilder getAvatarBuilder() {
        return this.avatarBuilder;
    }

    public ImageLoader(@NotNull Context context, @NotNull AvatarBuilder avatarBuilder) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)avatarBuilder, (String)"avatarBuilder");
        this.context = context;
        this.avatarBuilder = avatarBuilder;
    }
}

