/*
 * Decompiled with CFR 0.152.
 */
package io.skygear.plugins.chat;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import io.skygear.plugins.chat.Message;
import io.skygear.skygear.Error;
import java.util.Date;
import java.util.UUID;

public class MessageOperation {
    final Message message;
    String operationId;
    String conversationId;
    Type type;
    Status status;
    Error error;
    Date sendDate;

    public MessageOperation(@NonNull String operationId, @NonNull Message message, @NonNull String conversationId, @NonNull Type type, @NonNull Status status, @NonNull Date sendDate, @Nullable Error error) {
        this.operationId = operationId;
        this.message = message;
        this.conversationId = conversationId;
        this.type = type;
        this.status = status;
        this.sendDate = sendDate;
        this.error = error;
    }

    public MessageOperation(@NonNull Message message, @NonNull String conversationId, @NonNull Type type) {
        this.operationId = UUID.randomUUID().toString();
        this.message = message;
        this.conversationId = conversationId;
        this.type = type;
        this.status = Status.PENDING;
        this.sendDate = new Date();
        this.error = null;
    }

    @NonNull
    public String getId() {
        return this.operationId;
    }

    @NonNull
    public String getConversationId() {
        return this.conversationId;
    }

    @Nullable
    public Status getStatus() {
        return this.status;
    }

    @Nullable
    protected void setStatus(Status status) {
        this.status = status;
    }

    @Nullable
    public Type getType() {
        return this.type;
    }

    @Nullable
    protected void setType(Type type) {
        this.type = type;
    }

    public Date getSendDate() {
        return this.sendDate;
    }

    public Message getMessage() {
        return this.message;
    }

    public Error getError() {
        return this.error;
    }

    public static enum Type {
        ADD("add"),
        EDIT("edit"),
        DELETE("delete");

        private final String name;

        public String getName() {
            return this.name;
        }

        private Type(String name) {
            this.name = name;
        }

        @Nullable
        static Type fromName(String name) {
            Type type = null;
            for (Type eachType : Type.values()) {
                if (!eachType.getName().equals(name)) continue;
                type = eachType;
                break;
            }
            return type;
        }
    }

    public static enum Status {
        PENDING("pending"),
        FAILED("failed"),
        SUCCESS("success");

        private final String name;

        public String getName() {
            return this.name;
        }

        private Status(String name) {
            this.name = name;
        }

        @Nullable
        static Status fromName(String name) {
            Status status = null;
            for (Status eachStatus : Status.values()) {
                if (!eachStatus.getName().equals(name)) continue;
                status = eachStatus;
                break;
            }
            return status;
        }
    }
}

