/*
 * Decompiled with CFR 0.152.
 */
package io.skygear.plugins.chat;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import io.realm.RealmQuery;
import io.skygear.plugins.chat.Conversation;
import io.skygear.plugins.chat.GetCallback;
import io.skygear.plugins.chat.Message;
import io.skygear.plugins.chat.MessageCacheObject;
import io.skygear.plugins.chat.MessageOperation;
import io.skygear.plugins.chat.MessageOperationCacheObject;
import io.skygear.plugins.chat.Participant;
import io.skygear.plugins.chat.RealmStore;
import io.skygear.skygear.Error;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;

class CacheController {
    private static CacheController sharedInstance;
    RealmStore store;

    static CacheController getInstance() {
        if (sharedInstance == null) {
            RealmStore store = new RealmStore("SKYChatCache", false);
            sharedInstance = new CacheController(store);
        }
        return sharedInstance;
    }

    CacheController(RealmStore store) {
        this.store = store;
    }

    void cleanUpOnLaunch() {
        this.markPendingMessageOperationsAsFailed();
    }

    void getMessages(@NonNull Conversation conversation, int limit, @Nullable Date before, @Nullable String order, @Nullable GetCallback<List<Message>> callback) {
        this.getMessages(conversation, limit, before, null, order, callback);
    }

    void getMessages(final @NonNull Conversation conversation, int limit, final @Nullable Date before, final @Nullable Integer beforeMessageIdSeq, @Nullable String order, @Nullable GetCallback<List<Message>> callback) {
        RealmStore.QueryBuilder<MessageCacheObject> queryBuilder = new RealmStore.QueryBuilder<MessageCacheObject>(){

            @Override
            public RealmQuery<MessageCacheObject> buildQueryFrom(RealmQuery<MessageCacheObject> baseQuery) {
                RealmQuery query = baseQuery.equalTo(MessageCacheObject.KEY_CONVERSATION_ID, conversation.getId()).equalTo(MessageCacheObject.KEY_DELETED, Boolean.valueOf(false));
                if (before != null) {
                    query.lessThan(MessageCacheObject.KEY_CREATION_DATE, before);
                }
                if (beforeMessageIdSeq != null) {
                    query.lessThan(MessageCacheObject.KEY_SEQUENCE, beforeMessageIdSeq.intValue());
                }
                return query;
            }
        };
        this.getMessages(queryBuilder, limit, order, callback);
    }

    void getMessages(final @NonNull Conversation conversation, final int limit, @Nullable String beforeMessageId, final @Nullable String order, final @Nullable GetCallback<List<Message>> callback) {
        if (callback != null) {
            if (beforeMessageId != null) {
                this.getMessage(beforeMessageId, new GetCallback<List<Message>>(){

                    @Override
                    public void onSuccess(@Nullable List<Message> messages) {
                        if (messages.isEmpty()) {
                            callback.onSuccess(new ArrayList());
                        } else {
                            Message message = messages.get(0);
                            CacheController.this.getMessages(conversation, limit, null, message.getSequence(), order, callback);
                        }
                    }

                    @Override
                    public void onFail(@NonNull Error error) {
                        callback.onSuccess(new ArrayList());
                    }
                });
            } else {
                this.getMessages(conversation, limit, null, null, order, callback);
            }
        }
    }

    private void getMessage(final @NonNull String messageId, @Nullable GetCallback<List<Message>> callback) {
        RealmStore.QueryBuilder<MessageCacheObject> queryBuilder = new RealmStore.QueryBuilder<MessageCacheObject>(){

            @Override
            public RealmQuery<MessageCacheObject> buildQueryFrom(RealmQuery<MessageCacheObject> baseQuery) {
                RealmQuery query = baseQuery.equalTo(MessageCacheObject.KEY_RECORD_ID, messageId);
                return query;
            }
        };
        this.getMessages(queryBuilder, 1, null, callback);
    }

    private void getMessages(@NonNull RealmStore.QueryBuilder<MessageCacheObject> queryBuilder, int limit, String order, final @Nullable GetCallback<List<Message>> callback) {
        if (callback != null) {
            String resolvedOrder = order;
            resolvedOrder = resolvedOrder != null && resolvedOrder.equalsIgnoreCase("edited_at") ? MessageCacheObject.KEY_EDITION_DATE : MessageCacheObject.KEY_CREATION_DATE;
            this.store.getMessages(queryBuilder, limit, resolvedOrder, new RealmStore.ResultCallback<Message[]>(){

                @Override
                public void onResultGet(Message[] messages) {
                    callback.onSuccess(Arrays.asList(messages));
                }
            });
        }
    }

    void didGetMessages(Message[] messages, Message[] deletedMessages) {
        this.store.setMessages(messages);
        this.store.setMessages(deletedMessages);
    }

    void didSaveMessage(Message message) {
        this.store.setMessages(new Message[]{message});
    }

    void didDeleteMessage(Message message) {
        this.store.setMessages(new Message[]{message});
    }

    void handleMessageChange(Message message, String eventType) {
        if (eventType.equals("create")) {
            this.didSaveMessage(message);
        }
        if (eventType.equals("update")) {
            this.didSaveMessage(message);
        }
        if (eventType.equals("delete")) {
            this.didDeleteMessage(message);
        }
    }

    private void fetchMessageOperations(@NonNull RealmStore.QueryBuilder<MessageOperationCacheObject> queryBuilder, final @Nullable GetCallback<List<MessageOperation>> callback) {
        this.store.getMessageOperations(queryBuilder, -1, MessageOperationCacheObject.KEY_SEND_DATE, new RealmStore.ResultCallback<MessageOperation[]>(){

            @Override
            public void onResultGet(MessageOperation[] operations) {
                if (callback != null) {
                    callback.onSuccess(Arrays.asList(operations));
                }
            }
        });
    }

    void fetchMessageOperations(final @NonNull Conversation conversation, final @NonNull MessageOperation.Type operationType, @Nullable GetCallback<List<MessageOperation>> callback) {
        RealmStore.QueryBuilder<MessageOperationCacheObject> queryBuilder = new RealmStore.QueryBuilder<MessageOperationCacheObject>(){

            @Override
            public RealmQuery<MessageOperationCacheObject> buildQueryFrom(RealmQuery<MessageOperationCacheObject> baseQuery) {
                RealmQuery query = baseQuery.equalTo(MessageOperationCacheObject.KEY_CONVERSATION_ID, conversation.getId()).equalTo(MessageOperationCacheObject.KEY_TYPE, operationType.getName());
                return query;
            }
        };
        this.fetchMessageOperations(queryBuilder, callback);
    }

    void fetchMessageOperations(final @NonNull Message message, final @NonNull MessageOperation.Type operationType, @Nullable GetCallback<List<MessageOperation>> callback) {
        RealmStore.QueryBuilder<MessageOperationCacheObject> queryBuilder = new RealmStore.QueryBuilder<MessageOperationCacheObject>(){

            @Override
            public RealmQuery<MessageOperationCacheObject> buildQueryFrom(RealmQuery<MessageOperationCacheObject> baseQuery) {
                RealmQuery query = baseQuery.equalTo(MessageOperationCacheObject.KEY_MESSAGE_ID, message.getId()).equalTo(MessageOperationCacheObject.KEY_TYPE, operationType.getName());
                return query;
            }
        };
        this.fetchMessageOperations(queryBuilder, callback);
    }

    MessageOperation didStartMessageOperation(@NonNull Message message, @NonNull String conversationId, @NonNull MessageOperation.Type type) {
        MessageOperation operation = new MessageOperation(message, conversationId, type);
        this.store.setMessageOperations(new MessageOperation[]{operation});
        return operation;
    }

    void didCompleteMessageOperation(@NonNull MessageOperation operation) {
        operation.status = MessageOperation.Status.SUCCESS;
        this.store.deleteMessageOperations(new MessageOperation[]{operation});
    }

    void didFailMessageOperation(@NonNull MessageOperation operation, @Nullable Error error) {
        operation.status = MessageOperation.Status.FAILED;
        operation.error = error;
        this.store.setMessageOperations(new MessageOperation[]{operation});
    }

    void didCancelMessageOperation(@NonNull MessageOperation operation) {
        this.store.deleteMessageOperations(new MessageOperation[]{operation});
    }

    void markPendingMessageOperationsAsFailed() {
        RealmStore.QueryBuilder<MessageOperationCacheObject> queryBuilder = new RealmStore.QueryBuilder<MessageOperationCacheObject>(){

            @Override
            public RealmQuery<MessageOperationCacheObject> buildQueryFrom(RealmQuery<MessageOperationCacheObject> baseQuery) {
                RealmQuery query = baseQuery.equalTo(MessageOperationCacheObject.KEY_STATUS, MessageOperation.Status.PENDING.toString());
                return query;
            }
        };
        this.store.markMessageOperationsAsFailed(queryBuilder, null);
    }

    void didFetchParticipants(Collection<Participant> participants) {
        this.store.setParticipants(participants);
    }

    void fetchParticipants(Collection<String> participantIds, @Nullable GetCallback<Map<String, Participant>> callback) {
        this.store.getParticipantsWithIds(participantIds, callback);
    }
}

