/*
 * Decompiled with CFR 0.152.
 */
package io.skygear.plugins.chat;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import io.skygear.plugins.chat.Conversation;
import io.skygear.plugins.chat.SubscriptionCallback;
import io.skygear.plugins.chat.Typing;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class TypingSubscriptionCallback
implements SubscriptionCallback {
    public static final String EVENT_TYPE_TYPING = "typing";
    static final String[] SUPPORTED_EVENT_TYPES = new String[]{"typing"};
    private static final String TAG = "SkygearChatSubscription";
    static final DateTimeFormatter dateTimeFormatter = ISODateTimeFormat.dateTime().withZoneUTC();
    private final String conversationId;

    public TypingSubscriptionCallback(@NonNull Conversation conversation) {
        this.conversationId = conversation.getId();
    }

    @Override
    @NonNull
    public String[] supportingEventTypes() {
        return SUPPORTED_EVENT_TYPES;
    }

    @Override
    public void notify(String eventType, @Nullable JSONObject data) {
        if (data == null) {
            return;
        }
        Iterator dataKeys = data.keys();
        JSONObject typingData = data.optJSONObject("conversation/" + this.conversationId);
        if (typingData == null) {
            return;
        }
        HashMap<String, Typing> typingMap = new HashMap<String, Typing>();
        Iterator typingDataKeys = typingData.keys();
        while (typingDataKeys.hasNext()) {
            String eachTypingUserId = (String)typingDataKeys.next();
            String[] userIdSplits = eachTypingUserId.split("/", 2);
            if (userIdSplits.length < 2 || !userIdSplits[0].equalsIgnoreCase("user")) {
                Log.w((String)TAG, (String)"Invalid format for user ID for typing event");
                continue;
            }
            try {
                JSONObject userTypingData = typingData.getJSONObject(eachTypingUserId);
                String eventName = userTypingData.getString("event");
                String eventTimeString = userTypingData.optString("at");
                Date eventTime = null;
                if (eventTimeString != null) {
                    eventTime = dateTimeFormatter.parseDateTime(eventTimeString).toDate();
                }
                String userId = userIdSplits[1];
                typingMap.put(userId, new Typing(userId, Typing.State.fromName(eventName), eventTime));
            }
            catch (JSONException e) {
                Log.w((String)TAG, (String)"Fail to parse typing event payload", (Throwable)e);
            }
        }
        if (typingMap.size() > 0) {
            this.notify(typingMap);
        }
    }

    public abstract void notify(@NonNull Map<String, Typing> var1);
}

