/*
 * Decompiled with CFR 0.152.
 */
package io.skygear.plugins.chat;

import android.util.Log;
import io.realm.OrderedCollectionChangeSet;
import io.realm.OrderedRealmCollectionChangeListener;
import io.realm.OrderedRealmCollectionSnapshot;
import io.realm.Realm;
import io.realm.RealmConfiguration;
import io.realm.RealmMigration;
import io.realm.RealmQuery;
import io.realm.RealmResults;
import io.realm.Sort;
import io.realm.annotations.RealmModule;
import io.skygear.plugins.chat.ErrorSerializer;
import io.skygear.plugins.chat.GetCallback;
import io.skygear.plugins.chat.Message;
import io.skygear.plugins.chat.MessageCacheObject;
import io.skygear.plugins.chat.MessageOperation;
import io.skygear.plugins.chat.MessageOperationCacheObject;
import io.skygear.plugins.chat.Participant;
import io.skygear.plugins.chat.ParticipantCacheObject;
import io.skygear.plugins.chat.ParticipantMigration;
import io.skygear.plugins.chat.SequenceMigration;
import io.skygear.skygear.Error;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.json.JSONException;

class RealmStore {
    static String TAG = "RealmStore";
    private final String name;
    private final boolean inMemory;
    private final boolean async;

    RealmStore(String name, boolean inMemory) {
        this.name = name;
        this.inMemory = inMemory;
        this.async = true;
    }

    RealmStore(String name, boolean inMemory, boolean async) {
        this.name = name;
        this.inMemory = inMemory;
        this.async = async;
    }

    Realm getRealm() {
        RealmConfiguration.Builder configBuilder = new RealmConfiguration.Builder().name(this.name).schemaVersion(1L).modules((Object)new SkygearChatModule(), new Object[0]).schemaVersion(2L).migration((RealmMigration)new SequenceMigration()).schemaVersion(3L).migration((RealmMigration)new ParticipantMigration());
        if (this.inMemory) {
            configBuilder = configBuilder.inMemory();
        }
        return Realm.getInstance((RealmConfiguration)configBuilder.build());
    }

    private void getMessages(RealmResults<MessageCacheObject> results, int limit, ResultCallback<Message[]> callback) {
        OrderedRealmCollectionSnapshot snapshot = results.createSnapshot();
        int resolvedLimit = limit;
        int size = snapshot.size();
        if (limit == -1 || limit > size) {
            resolvedLimit = size;
        }
        ArrayList<Message> messages = new ArrayList<Message>(resolvedLimit);
        ArrayList<MessageCacheObject> faultyCacheObjects = new ArrayList<MessageCacheObject>();
        for (int i = 0; i < resolvedLimit; ++i) {
            MessageCacheObject cacheObject = (MessageCacheObject)snapshot.get(i);
            if (cacheObject == null) {
                throw new RuntimeException("Unexpected null object when getting message query result");
            }
            try {
                Message message = cacheObject.toMessage();
                messages.add(message);
                continue;
            }
            catch (Exception e) {
                MessageCacheObject messageCacheObject = cacheObject;
                String string = null;
                string = messageCacheObject.realmGet$recordID();
                Log.e((String)TAG, (String)("Faulty Message Found: " + string), (Throwable)e);
                faultyCacheObjects.add(cacheObject);
            }
        }
        if (faultyCacheObjects.size() > 0) {
            Realm realm = this.getRealm();
            realm.beginTransaction();
            for (MessageCacheObject cacheObject : faultyCacheObjects) {
                cacheObject.deleteFromRealm();
            }
            realm.commitTransaction();
        }
        Message[] messageArray = new Message[messages.size()];
        callback.onResultGet(messages.toArray(messageArray));
    }

    void getMessages(@Nonnull QueryBuilder<MessageCacheObject> queryBuilder, final int limit, @Nonnull String order, final @Nonnull ResultCallback<Message[]> callback) {
        RealmQuery<MessageCacheObject> query = this.getRealm().where(MessageCacheObject.class);
        query = queryBuilder.buildQueryFrom(query);
        if (this.async) {
            final RealmResults results = query.findAllSortedAsync(order, Sort.DESCENDING);
            results.addChangeListener((OrderedRealmCollectionChangeListener)new OrderedRealmCollectionChangeListener<RealmResults<MessageCacheObject>>(){

                public void onChange(RealmResults<MessageCacheObject> messageCacheObjects, @Nullable OrderedCollectionChangeSet changeSet) {
                    results.removeAllChangeListeners();
                    RealmStore.this.getMessages((RealmResults<MessageCacheObject>)messageCacheObjects, limit, callback);
                }
            });
        } else {
            RealmResults results = query.findAllSorted(order, Sort.DESCENDING);
            this.getMessages((RealmResults<MessageCacheObject>)results, limit, callback);
        }
    }

    void getMessageWithID(@Nonnull String messageID, final @Nonnull ResultCallback<Message> callback) {
        final ResultCallback<Message[]> wrappedCallback = new ResultCallback<Message[]>(){

            @Override
            public void onResultGet(Message[] result) {
                if (result.length == 0) {
                    callback.onResultGet(null);
                } else {
                    callback.onResultGet(result[0]);
                }
            }
        };
        if (this.async) {
            final RealmResults results = this.getRealm().where(MessageCacheObject.class).equalTo(MessageCacheObject.KEY_RECORD_ID, messageID).findAllAsync();
            results.addChangeListener((OrderedRealmCollectionChangeListener)new OrderedRealmCollectionChangeListener<RealmResults<MessageCacheObject>>(){

                public void onChange(RealmResults<MessageCacheObject> messageCacheObjects, @Nullable OrderedCollectionChangeSet changeSet) {
                    results.removeAllChangeListeners();
                    RealmStore.this.getMessages((RealmResults<MessageCacheObject>)messageCacheObjects, 1, wrappedCallback);
                }
            });
        } else {
            RealmResults results = this.getRealm().where(MessageCacheObject.class).equalTo(MessageCacheObject.KEY_RECORD_ID, messageID).findAll();
            this.getMessages((RealmResults<MessageCacheObject>)results, 1, wrappedCallback);
        }
    }

    private void setMessages(Realm realm, Message[] messages) {
        ArrayList<MessageCacheObject> cacheObjects = new ArrayList<MessageCacheObject>(messages.length);
        for (Message message : messages) {
            MessageCacheObject cacheObject = new MessageCacheObject(message);
            cacheObjects.add(cacheObject);
        }
        realm.insertOrUpdate(cacheObjects);
    }

    void setMessages(final Message[] messages) {
        Realm.Transaction transaction = new Realm.Transaction(){

            public void execute(Realm realm) {
                RealmStore.this.setMessages(realm, messages);
            }
        };
        if (this.async) {
            this.getRealm().executeTransactionAsync(transaction);
        } else {
            this.getRealm().executeTransaction(transaction);
        }
    }

    private void deleteMessages(Realm realm, Message[] messages) {
        String[] messageIDs = new String[messages.length];
        for (int i = 0; i < messages.length; ++i) {
            messageIDs[i] = messages[i].getId();
        }
        RealmResults cacheObjects = realm.where(MessageCacheObject.class).in(MessageCacheObject.KEY_RECORD_ID, messageIDs).findAll();
        cacheObjects.deleteAllFromRealm();
    }

    void deleteMessages(final Message[] messages) {
        Realm.Transaction transaction = new Realm.Transaction(){

            public void execute(Realm realm) {
                RealmStore.this.deleteMessages(realm, messages);
            }
        };
        if (this.async) {
            this.getRealm().executeTransactionAsync(transaction);
        } else {
            this.getRealm().executeTransaction(transaction);
        }
    }

    private void getMessageOperations(RealmResults<MessageOperationCacheObject> results, int limit, ResultCallback<MessageOperation[]> callback) {
        OrderedRealmCollectionSnapshot snapshot = results.createSnapshot();
        int resolvedLimit = limit;
        int size = snapshot.size();
        if (limit == -1 || limit > size) {
            resolvedLimit = size;
        }
        ArrayList<MessageOperation> operations = new ArrayList<MessageOperation>(resolvedLimit);
        ArrayList<MessageOperationCacheObject> faultyCacheObjects = new ArrayList<MessageOperationCacheObject>();
        for (int i = 0; i < resolvedLimit; ++i) {
            MessageOperationCacheObject cacheObject = (MessageOperationCacheObject)snapshot.get(i);
            if (cacheObject == null) {
                throw new RuntimeException("Unexpected null object when getting message query result");
            }
            try {
                MessageOperation operation = cacheObject.toMessageOperation();
                operations.add(operation);
                continue;
            }
            catch (Exception e) {
                MessageOperationCacheObject messageOperationCacheObject = cacheObject;
                String string = null;
                string = messageOperationCacheObject.realmGet$operationID();
                Log.e((String)TAG, (String)("Faulty Operation Found: " + string), (Throwable)e);
                faultyCacheObjects.add(cacheObject);
            }
        }
        if (faultyCacheObjects.size() > 0) {
            Realm realm = this.getRealm();
            realm.beginTransaction();
            for (MessageOperationCacheObject cacheObject : faultyCacheObjects) {
                cacheObject.deleteFromRealm();
            }
            realm.commitTransaction();
        }
        MessageOperation[] operationArray = new MessageOperation[operations.size()];
        callback.onResultGet(operations.toArray(operationArray));
    }

    void getMessageOperations(@Nonnull QueryBuilder<MessageOperationCacheObject> queryBuilder, final int limit, @Nonnull String order, final @Nonnull ResultCallback<MessageOperation[]> callback) {
        RealmQuery<MessageOperationCacheObject> query = this.getRealm().where(MessageOperationCacheObject.class);
        query = queryBuilder.buildQueryFrom(query);
        if (this.async) {
            final RealmResults results = query.findAllSortedAsync(order, Sort.DESCENDING);
            results.addChangeListener((OrderedRealmCollectionChangeListener)new OrderedRealmCollectionChangeListener<RealmResults<MessageOperationCacheObject>>(){

                public void onChange(RealmResults<MessageOperationCacheObject> operationCacheObjects, @Nullable OrderedCollectionChangeSet changeSet) {
                    results.removeAllChangeListeners();
                    RealmStore.this.getMessageOperations((RealmResults<MessageOperationCacheObject>)operationCacheObjects, limit, callback);
                }
            });
        } else {
            RealmResults results = query.findAllSorted(order, Sort.DESCENDING);
            this.getMessageOperations((RealmResults<MessageOperationCacheObject>)results, limit, callback);
        }
    }

    void getMessageOperationWithID(@Nonnull String operationID, final @Nonnull ResultCallback<MessageOperation> callback) {
        final ResultCallback<MessageOperation[]> wrappedCallback = new ResultCallback<MessageOperation[]>(){

            @Override
            public void onResultGet(MessageOperation[] result) {
                if (result.length == 0) {
                    callback.onResultGet(null);
                } else {
                    callback.onResultGet(result[0]);
                }
            }
        };
        if (this.async) {
            final RealmResults results = this.getRealm().where(MessageOperationCacheObject.class).equalTo(MessageOperationCacheObject.KEY_OPERATION_ID, operationID).findAllAsync();
            results.addChangeListener((OrderedRealmCollectionChangeListener)new OrderedRealmCollectionChangeListener<RealmResults<MessageOperationCacheObject>>(){

                public void onChange(RealmResults<MessageOperationCacheObject> operationCacheObjects, @Nullable OrderedCollectionChangeSet changeSet) {
                    results.removeAllChangeListeners();
                    RealmStore.this.getMessageOperations((RealmResults<MessageOperationCacheObject>)operationCacheObjects, 1, wrappedCallback);
                }
            });
        } else {
            RealmResults results = this.getRealm().where(MessageOperationCacheObject.class).equalTo(MessageOperationCacheObject.KEY_OPERATION_ID, operationID).findAll();
            this.getMessageOperations((RealmResults<MessageOperationCacheObject>)results, 1, wrappedCallback);
        }
    }

    private void setMessageOperations(Realm realm, MessageOperation[] operations) {
        ArrayList<MessageOperationCacheObject> cacheObjects = new ArrayList<MessageOperationCacheObject>(operations.length);
        for (MessageOperation operation : operations) {
            MessageOperationCacheObject cacheObject = new MessageOperationCacheObject(operation);
            cacheObjects.add(cacheObject);
        }
        realm.insertOrUpdate(cacheObjects);
    }

    void setMessageOperations(final MessageOperation[] operations) {
        Realm.Transaction transaction = new Realm.Transaction(){

            public void execute(Realm realm) {
                RealmStore.this.setMessageOperations(realm, operations);
            }
        };
        if (this.async) {
            this.getRealm().executeTransactionAsync(transaction);
        } else {
            this.getRealm().executeTransaction(transaction);
        }
    }

    private void deleteMessageOperations(Realm realm, MessageOperation[] operations) {
        String[] operationIDs = new String[operations.length];
        for (int i = 0; i < operations.length; ++i) {
            operationIDs[i] = operations[i].getId();
        }
        RealmResults cacheObjects = realm.where(MessageOperationCacheObject.class).in(MessageOperationCacheObject.KEY_OPERATION_ID, operationIDs).findAll();
        cacheObjects.deleteAllFromRealm();
    }

    void deleteMessageOperations(final MessageOperation[] operations) {
        Realm.Transaction transaction = new Realm.Transaction(){

            public void execute(Realm realm) {
                RealmStore.this.deleteMessageOperations(realm, operations);
            }
        };
        if (this.async) {
            this.getRealm().executeTransactionAsync(transaction);
        } else {
            this.getRealm().executeTransaction(transaction);
        }
    }

    private void markMessageOperationsAsFailed(Realm realm, @Nonnull QueryBuilder<MessageOperationCacheObject> queryBuilder, @Nullable Error error) {
        RealmQuery<MessageOperationCacheObject> query = realm.where(MessageOperationCacheObject.class);
        query = queryBuilder.buildQueryFrom(query);
        RealmResults results = query.findAll();
        for (MessageOperationCacheObject cacheObject : results) {
            String string = MessageOperation.Status.FAILED.toString();
            MessageOperationCacheObject messageOperationCacheObject = cacheObject;
            messageOperationCacheObject.realmSet$status(string);
            string = error != null ? ErrorSerializer.serialize(error).toString() : null;
            messageOperationCacheObject = cacheObject;
            messageOperationCacheObject.realmSet$errorData(string);
        }
        realm.copyToRealmOrUpdate((Iterable)results);
    }

    void markMessageOperationsAsFailed(final @Nonnull QueryBuilder<MessageOperationCacheObject> queryBuilder, final @Nullable Error error) {
        Realm.Transaction transaction = new Realm.Transaction(){

            public void execute(Realm realm) {
                RealmStore.this.markMessageOperationsAsFailed(realm, queryBuilder, error);
            }
        };
        this.getRealm().executeTransaction(transaction);
    }

    void deleteAll() {
        Realm.Transaction transaction = new Realm.Transaction(){

            public void execute(Realm realm) {
                realm.deleteAll();
            }
        };
        if (this.async) {
            this.getRealm().executeTransactionAsync(transaction);
        } else {
            this.getRealm().executeTransaction(transaction);
        }
    }

    void setParticipants(final Collection<Participant> participants) {
        Realm.Transaction transaction = new Realm.Transaction(){

            public void execute(Realm realm) {
                RealmStore.this.setParticipants(realm, participants);
            }
        };
        if (this.async) {
            this.getRealm().executeTransactionAsync(transaction);
        } else {
            this.getRealm().executeTransaction(transaction);
        }
    }

    private void setParticipants(Realm realm, Collection<Participant> participants) {
        ArrayList<ParticipantCacheObject> cacheObjects = new ArrayList<ParticipantCacheObject>(participants.size());
        for (Participant participant : participants) {
            ParticipantCacheObject cacheObject = new ParticipantCacheObject(participant);
            cacheObjects.add(cacheObject);
        }
        realm.insertOrUpdate(cacheObjects);
    }

    void getParticipantsWithIds(@Nonnull Collection<String> participantIds, final @Nonnull GetCallback<Map<String, Participant>> callback) {
        if (callback != null) {
            RealmQuery query = null;
            query = participantIds == null || participantIds.isEmpty() ? this.getRealm().where(ParticipantCacheObject.class) : this.getRealm().where(ParticipantCacheObject.class).in(ParticipantCacheObject.KEY_RECORD_ID, participantIds.toArray(new String[participantIds.size()]));
            if (this.async) {
                final RealmResults results = query.findAllAsync();
                results.addChangeListener((OrderedRealmCollectionChangeListener)new OrderedRealmCollectionChangeListener<RealmResults<ParticipantCacheObject>>(){

                    public void onChange(RealmResults<ParticipantCacheObject> participantCacheObjects, @Nullable OrderedCollectionChangeSet changeSet) {
                        results.removeAllChangeListeners();
                        RealmStore.this.getParticipants(participantCacheObjects, callback);
                    }
                });
            } else {
                RealmResults results = query.findAll();
                this.getParticipants((RealmResults<ParticipantCacheObject>)results, callback);
            }
        }
    }

    void getParticipants(RealmResults<ParticipantCacheObject> results, GetCallback<Map<String, Participant>> callback) {
        HashMap<String, Participant> participantsMap = new HashMap<String, Participant>();
        for (ParticipantCacheObject object : results) {
            try {
                ParticipantCacheObject participantCacheObject = object;
                String string = null;
                string = participantCacheObject.realmGet$recordID();
                participantsMap.put(string, object.toParticipant());
            }
            catch (JSONException e) {
                Log.e((String)TAG, (String)("Failed to serialize Chat User, reason: " + e.getMessage()));
            }
        }
        callback.onSuccess(participantsMap);
    }

    @RealmModule(library=true, classes={MessageCacheObject.class, MessageOperationCacheObject.class, ParticipantCacheObject.class})
    private static class SkygearChatModule {
        private SkygearChatModule() {
        }
    }

    static interface ResultCallback<T> {
        public void onResultGet(T var1);
    }

    static interface QueryBuilder<T> {
        public RealmQuery<T> buildQueryFrom(RealmQuery<T> var1);
    }
}

