/*
 * Decompiled with CFR 0.152.
 */
package io.skygear.plugins.chat;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import io.skygear.plugins.chat.Conversation;
import io.skygear.plugins.chat.SubscriptionCallback;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class ConversationSubscriptionCallback
implements SubscriptionCallback {
    public static final String EVENT_TYPE_CREATE = "create";
    public static final String EVENT_TYPE_UPDATE = "update";
    public static final String EVENT_TYPE_DELETE = "delete";
    static final String[] SUPPORTED_EVENT_TYPES = new String[]{"create", "update", "delete"};
    private static final String RECORD_TYPE = "conversation";
    private static final String TAG = "ConversationSubscribe";
    static final DateTimeFormatter dateTimeFormatter = ISODateTimeFormat.dateTime().withZoneUTC();

    @Override
    @NonNull
    public String[] supportingEventTypes() {
        return SUPPORTED_EVENT_TYPES;
    }

    @Override
    public void notify(String eventType, @Nullable JSONObject data) {
        String recordType = data.optString("record_type");
        if (RECORD_TYPE.equals(recordType)) {
            JSONObject object = data.optJSONObject("record");
            if (object != null) {
                try {
                    Conversation conversation = Conversation.fromJson(object);
                    this.notify(eventType, conversation);
                }
                catch (JSONException e) {
                    Log.w((String)TAG, (String)"Cannot parse conversation.", (Throwable)e);
                }
            } else {
                Log.w((String)TAG, (String)"Record not found.");
            }
        } else {
            Log.w((String)TAG, (String)String.format("record_type is %s, not %s", recordType, RECORD_TYPE));
        }
    }

    public abstract void notify(@NonNull String var1, @NonNull Conversation var2);
}

