/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import android.annotation.TargetApi;
import android.util.JsonReader;
import android.util.JsonToken;
import io.realm.BaseRealm;
import io.realm.MessageOperationCacheObjectRealmProxyInterface;
import io.realm.ProxyState;
import io.realm.Realm;
import io.realm.RealmFieldType;
import io.realm.RealmModel;
import io.realm.RealmObject;
import io.realm.exceptions.RealmException;
import io.realm.internal.ColumnInfo;
import io.realm.internal.OsObject;
import io.realm.internal.OsObjectSchemaInfo;
import io.realm.internal.OsSchemaInfo;
import io.realm.internal.RealmObjectProxy;
import io.realm.internal.Row;
import io.realm.internal.Table;
import io.realm.internal.android.JsonUtils;
import io.skygear.plugins.chat.MessageOperationCacheObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class MessageOperationCacheObjectRealmProxy
extends MessageOperationCacheObject
implements RealmObjectProxy,
MessageOperationCacheObjectRealmProxyInterface {
    private static final OsObjectSchemaInfo expectedObjectSchemaInfo = MessageOperationCacheObjectRealmProxy.createExpectedObjectSchemaInfo();
    private static final List<String> FIELD_NAMES;
    private MessageOperationCacheObjectColumnInfo columnInfo;
    private ProxyState<MessageOperationCacheObject> proxyState;

    MessageOperationCacheObjectRealmProxy() {
        this.proxyState.setConstructionFinished();
    }

    public void realm$injectObjectContext() {
        if (this.proxyState != null) {
            return;
        }
        BaseRealm.RealmObjectContext context = (BaseRealm.RealmObjectContext)BaseRealm.objectContext.get();
        this.columnInfo = (MessageOperationCacheObjectColumnInfo)context.getColumnInfo();
        this.proxyState = new ProxyState((RealmModel)this);
        this.proxyState.setRealm$realm(context.getRealm());
        this.proxyState.setRow$realm(context.getRow());
        this.proxyState.setAcceptDefaultValue$realm(context.getAcceptDefaultValue());
        this.proxyState.setExcludeFields$realm(context.getExcludeFields());
    }

    @Override
    public String realmGet$operationID() {
        this.proxyState.getRealm$realm().checkIfValid();
        return this.proxyState.getRow$realm().getString(this.columnInfo.operationIDIndex);
    }

    @Override
    public void realmSet$operationID(String value) {
        if (this.proxyState.isUnderConstruction()) {
            return;
        }
        this.proxyState.getRealm$realm().checkIfValid();
        throw new RealmException("Primary key field 'operationID' cannot be changed after object was created.");
    }

    @Override
    public String realmGet$messageID() {
        this.proxyState.getRealm$realm().checkIfValid();
        return this.proxyState.getRow$realm().getString(this.columnInfo.messageIDIndex);
    }

    @Override
    public void realmSet$messageID(String value) {
        if (this.proxyState.isUnderConstruction()) {
            if (!this.proxyState.getAcceptDefaultValue$realm()) {
                return;
            }
            Row row = this.proxyState.getRow$realm();
            if (value == null) {
                row.getTable().setNull(this.columnInfo.messageIDIndex, row.getIndex(), true);
                return;
            }
            row.getTable().setString(this.columnInfo.messageIDIndex, row.getIndex(), value, true);
            return;
        }
        this.proxyState.getRealm$realm().checkIfValid();
        if (value == null) {
            this.proxyState.getRow$realm().setNull(this.columnInfo.messageIDIndex);
            return;
        }
        this.proxyState.getRow$realm().setString(this.columnInfo.messageIDIndex, value);
    }

    @Override
    public String realmGet$conversationID() {
        this.proxyState.getRealm$realm().checkIfValid();
        return this.proxyState.getRow$realm().getString(this.columnInfo.conversationIDIndex);
    }

    @Override
    public void realmSet$conversationID(String value) {
        if (this.proxyState.isUnderConstruction()) {
            if (!this.proxyState.getAcceptDefaultValue$realm()) {
                return;
            }
            Row row = this.proxyState.getRow$realm();
            if (value == null) {
                row.getTable().setNull(this.columnInfo.conversationIDIndex, row.getIndex(), true);
                return;
            }
            row.getTable().setString(this.columnInfo.conversationIDIndex, row.getIndex(), value, true);
            return;
        }
        this.proxyState.getRealm$realm().checkIfValid();
        if (value == null) {
            this.proxyState.getRow$realm().setNull(this.columnInfo.conversationIDIndex);
            return;
        }
        this.proxyState.getRow$realm().setString(this.columnInfo.conversationIDIndex, value);
    }

    @Override
    public String realmGet$type() {
        this.proxyState.getRealm$realm().checkIfValid();
        return this.proxyState.getRow$realm().getString(this.columnInfo.typeIndex);
    }

    @Override
    public void realmSet$type(String value) {
        if (this.proxyState.isUnderConstruction()) {
            if (!this.proxyState.getAcceptDefaultValue$realm()) {
                return;
            }
            Row row = this.proxyState.getRow$realm();
            if (value == null) {
                row.getTable().setNull(this.columnInfo.typeIndex, row.getIndex(), true);
                return;
            }
            row.getTable().setString(this.columnInfo.typeIndex, row.getIndex(), value, true);
            return;
        }
        this.proxyState.getRealm$realm().checkIfValid();
        if (value == null) {
            this.proxyState.getRow$realm().setNull(this.columnInfo.typeIndex);
            return;
        }
        this.proxyState.getRow$realm().setString(this.columnInfo.typeIndex, value);
    }

    @Override
    public String realmGet$status() {
        this.proxyState.getRealm$realm().checkIfValid();
        return this.proxyState.getRow$realm().getString(this.columnInfo.statusIndex);
    }

    @Override
    public void realmSet$status(String value) {
        if (this.proxyState.isUnderConstruction()) {
            if (!this.proxyState.getAcceptDefaultValue$realm()) {
                return;
            }
            Row row = this.proxyState.getRow$realm();
            if (value == null) {
                row.getTable().setNull(this.columnInfo.statusIndex, row.getIndex(), true);
                return;
            }
            row.getTable().setString(this.columnInfo.statusIndex, row.getIndex(), value, true);
            return;
        }
        this.proxyState.getRealm$realm().checkIfValid();
        if (value == null) {
            this.proxyState.getRow$realm().setNull(this.columnInfo.statusIndex);
            return;
        }
        this.proxyState.getRow$realm().setString(this.columnInfo.statusIndex, value);
    }

    @Override
    public Date realmGet$sendDate() {
        this.proxyState.getRealm$realm().checkIfValid();
        if (this.proxyState.getRow$realm().isNull(this.columnInfo.sendDateIndex)) {
            return null;
        }
        return this.proxyState.getRow$realm().getDate(this.columnInfo.sendDateIndex);
    }

    @Override
    public void realmSet$sendDate(Date value) {
        if (this.proxyState.isUnderConstruction()) {
            if (!this.proxyState.getAcceptDefaultValue$realm()) {
                return;
            }
            Row row = this.proxyState.getRow$realm();
            if (value == null) {
                row.getTable().setNull(this.columnInfo.sendDateIndex, row.getIndex(), true);
                return;
            }
            row.getTable().setDate(this.columnInfo.sendDateIndex, row.getIndex(), value, true);
            return;
        }
        this.proxyState.getRealm$realm().checkIfValid();
        if (value == null) {
            this.proxyState.getRow$realm().setNull(this.columnInfo.sendDateIndex);
            return;
        }
        this.proxyState.getRow$realm().setDate(this.columnInfo.sendDateIndex, value);
    }

    @Override
    public String realmGet$jsonData() {
        this.proxyState.getRealm$realm().checkIfValid();
        return this.proxyState.getRow$realm().getString(this.columnInfo.jsonDataIndex);
    }

    @Override
    public void realmSet$jsonData(String value) {
        if (this.proxyState.isUnderConstruction()) {
            if (!this.proxyState.getAcceptDefaultValue$realm()) {
                return;
            }
            Row row = this.proxyState.getRow$realm();
            if (value == null) {
                row.getTable().setNull(this.columnInfo.jsonDataIndex, row.getIndex(), true);
                return;
            }
            row.getTable().setString(this.columnInfo.jsonDataIndex, row.getIndex(), value, true);
            return;
        }
        this.proxyState.getRealm$realm().checkIfValid();
        if (value == null) {
            this.proxyState.getRow$realm().setNull(this.columnInfo.jsonDataIndex);
            return;
        }
        this.proxyState.getRow$realm().setString(this.columnInfo.jsonDataIndex, value);
    }

    @Override
    public String realmGet$errorData() {
        this.proxyState.getRealm$realm().checkIfValid();
        return this.proxyState.getRow$realm().getString(this.columnInfo.errorDataIndex);
    }

    @Override
    public void realmSet$errorData(String value) {
        if (this.proxyState.isUnderConstruction()) {
            if (!this.proxyState.getAcceptDefaultValue$realm()) {
                return;
            }
            Row row = this.proxyState.getRow$realm();
            if (value == null) {
                row.getTable().setNull(this.columnInfo.errorDataIndex, row.getIndex(), true);
                return;
            }
            row.getTable().setString(this.columnInfo.errorDataIndex, row.getIndex(), value, true);
            return;
        }
        this.proxyState.getRealm$realm().checkIfValid();
        if (value == null) {
            this.proxyState.getRow$realm().setNull(this.columnInfo.errorDataIndex);
            return;
        }
        this.proxyState.getRow$realm().setString(this.columnInfo.errorDataIndex, value);
    }

    private static OsObjectSchemaInfo createExpectedObjectSchemaInfo() {
        OsObjectSchemaInfo.Builder builder = new OsObjectSchemaInfo.Builder("MessageOperationCacheObject", 8, 0);
        builder.addPersistedProperty("operationID", RealmFieldType.STRING, true, true, false);
        builder.addPersistedProperty("messageID", RealmFieldType.STRING, false, false, false);
        builder.addPersistedProperty("conversationID", RealmFieldType.STRING, false, false, false);
        builder.addPersistedProperty("type", RealmFieldType.STRING, false, false, false);
        builder.addPersistedProperty("status", RealmFieldType.STRING, false, false, false);
        builder.addPersistedProperty("sendDate", RealmFieldType.DATE, false, false, false);
        builder.addPersistedProperty("jsonData", RealmFieldType.STRING, false, false, false);
        builder.addPersistedProperty("errorData", RealmFieldType.STRING, false, false, false);
        return builder.build();
    }

    public static OsObjectSchemaInfo getExpectedObjectSchemaInfo() {
        return expectedObjectSchemaInfo;
    }

    public static MessageOperationCacheObjectColumnInfo createColumnInfo(OsSchemaInfo schemaInfo) {
        return new MessageOperationCacheObjectColumnInfo(schemaInfo);
    }

    public static String getSimpleClassName() {
        return "MessageOperationCacheObject";
    }

    public static List<String> getFieldNames() {
        return FIELD_NAMES;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MessageOperationCacheObject createOrUpdateUsingJsonObject(Realm realm, JSONObject json, boolean update) throws JSONException {
        List excludeFields = Collections.emptyList();
        MessageOperationCacheObjectRealmProxy obj = null;
        if (update) {
            Table table = realm.getTable(MessageOperationCacheObject.class);
            MessageOperationCacheObjectColumnInfo columnInfo = (MessageOperationCacheObjectColumnInfo)realm.getSchema().getColumnInfo(MessageOperationCacheObject.class);
            long pkColumnIndex = columnInfo.operationIDIndex;
            long rowIndex = -1L;
            rowIndex = json.isNull("operationID") ? table.findFirstNull(pkColumnIndex) : table.findFirstString(pkColumnIndex, json.getString("operationID"));
            if (rowIndex != -1L) {
                BaseRealm.RealmObjectContext objectContext = (BaseRealm.RealmObjectContext)BaseRealm.objectContext.get();
                try {
                    objectContext.set((BaseRealm)realm, (Row)table.getUncheckedRow(rowIndex), realm.getSchema().getColumnInfo(MessageOperationCacheObject.class), false, Collections.emptyList());
                    obj = new MessageOperationCacheObjectRealmProxy();
                }
                finally {
                    objectContext.clear();
                }
            }
        }
        if (obj == null) {
            if (json.has("operationID")) {
                obj = json.isNull("operationID") ? (MessageOperationCacheObjectRealmProxy)realm.createObjectInternal(MessageOperationCacheObject.class, null, true, excludeFields) : (MessageOperationCacheObjectRealmProxy)realm.createObjectInternal(MessageOperationCacheObject.class, (Object)json.getString("operationID"), true, excludeFields);
            } else {
                throw new IllegalArgumentException("JSON object doesn't have the primary key field 'operationID'.");
            }
        }
        MessageOperationCacheObjectRealmProxyInterface objProxy = obj;
        if (json.has("messageID")) {
            if (json.isNull("messageID")) {
                objProxy.realmSet$messageID(null);
            } else {
                objProxy.realmSet$messageID(json.getString("messageID"));
            }
        }
        if (json.has("conversationID")) {
            if (json.isNull("conversationID")) {
                objProxy.realmSet$conversationID(null);
            } else {
                objProxy.realmSet$conversationID(json.getString("conversationID"));
            }
        }
        if (json.has("type")) {
            if (json.isNull("type")) {
                objProxy.realmSet$type(null);
            } else {
                objProxy.realmSet$type(json.getString("type"));
            }
        }
        if (json.has("status")) {
            if (json.isNull("status")) {
                objProxy.realmSet$status(null);
            } else {
                objProxy.realmSet$status(json.getString("status"));
            }
        }
        if (json.has("sendDate")) {
            if (json.isNull("sendDate")) {
                objProxy.realmSet$sendDate(null);
            } else {
                Object timestamp = json.get("sendDate");
                if (timestamp instanceof String) {
                    objProxy.realmSet$sendDate(JsonUtils.stringToDate((String)((String)timestamp)));
                } else {
                    objProxy.realmSet$sendDate(new Date(json.getLong("sendDate")));
                }
            }
        }
        if (json.has("jsonData")) {
            if (json.isNull("jsonData")) {
                objProxy.realmSet$jsonData(null);
            } else {
                objProxy.realmSet$jsonData(json.getString("jsonData"));
            }
        }
        if (json.has("errorData")) {
            if (json.isNull("errorData")) {
                objProxy.realmSet$errorData(null);
            } else {
                objProxy.realmSet$errorData(json.getString("errorData"));
            }
        }
        return obj;
    }

    @TargetApi(value=11)
    public static MessageOperationCacheObject createUsingJsonStream(Realm realm, JsonReader reader) throws IOException {
        boolean jsonHasPrimaryKey = false;
        MessageOperationCacheObject obj = new MessageOperationCacheObject();
        MessageOperationCacheObjectRealmProxyInterface objProxy = obj;
        reader.beginObject();
        while (reader.hasNext()) {
            String name = reader.nextName();
            if (name.equals("operationID")) {
                if (reader.peek() != JsonToken.NULL) {
                    objProxy.realmSet$operationID(reader.nextString());
                } else {
                    reader.skipValue();
                    objProxy.realmSet$operationID(null);
                }
                jsonHasPrimaryKey = true;
                continue;
            }
            if (name.equals("messageID")) {
                if (reader.peek() != JsonToken.NULL) {
                    objProxy.realmSet$messageID(reader.nextString());
                    continue;
                }
                reader.skipValue();
                objProxy.realmSet$messageID(null);
                continue;
            }
            if (name.equals("conversationID")) {
                if (reader.peek() != JsonToken.NULL) {
                    objProxy.realmSet$conversationID(reader.nextString());
                    continue;
                }
                reader.skipValue();
                objProxy.realmSet$conversationID(null);
                continue;
            }
            if (name.equals("type")) {
                if (reader.peek() != JsonToken.NULL) {
                    objProxy.realmSet$type(reader.nextString());
                    continue;
                }
                reader.skipValue();
                objProxy.realmSet$type(null);
                continue;
            }
            if (name.equals("status")) {
                if (reader.peek() != JsonToken.NULL) {
                    objProxy.realmSet$status(reader.nextString());
                    continue;
                }
                reader.skipValue();
                objProxy.realmSet$status(null);
                continue;
            }
            if (name.equals("sendDate")) {
                if (reader.peek() == JsonToken.NULL) {
                    reader.skipValue();
                    objProxy.realmSet$sendDate(null);
                    continue;
                }
                if (reader.peek() == JsonToken.NUMBER) {
                    long timestamp = reader.nextLong();
                    if (timestamp <= -1L) continue;
                    objProxy.realmSet$sendDate(new Date(timestamp));
                    continue;
                }
                objProxy.realmSet$sendDate(JsonUtils.stringToDate((String)reader.nextString()));
                continue;
            }
            if (name.equals("jsonData")) {
                if (reader.peek() != JsonToken.NULL) {
                    objProxy.realmSet$jsonData(reader.nextString());
                    continue;
                }
                reader.skipValue();
                objProxy.realmSet$jsonData(null);
                continue;
            }
            if (name.equals("errorData")) {
                if (reader.peek() != JsonToken.NULL) {
                    objProxy.realmSet$errorData(reader.nextString());
                    continue;
                }
                reader.skipValue();
                objProxy.realmSet$errorData(null);
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
        if (!jsonHasPrimaryKey) {
            throw new IllegalArgumentException("JSON object doesn't have the primary key field 'operationID'.");
        }
        return (MessageOperationCacheObject)realm.copyToRealm((RealmModel)obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MessageOperationCacheObject copyOrUpdate(Realm realm, MessageOperationCacheObject object, boolean update, Map<RealmModel, RealmObjectProxy> cache) {
        if (object instanceof RealmObjectProxy && ((RealmObjectProxy)object).realmGet$proxyState().getRealm$realm() != null) {
            BaseRealm otherRealm = ((RealmObjectProxy)object).realmGet$proxyState().getRealm$realm();
            if (otherRealm.threadId != realm.threadId) {
                throw new IllegalArgumentException("Objects which belong to Realm instances in other threads cannot be copied into this Realm instance.");
            }
            if (otherRealm.getPath().equals(realm.getPath())) {
                return object;
            }
        }
        BaseRealm.RealmObjectContext objectContext = (BaseRealm.RealmObjectContext)BaseRealm.objectContext.get();
        RealmObjectProxy cachedRealmObject = cache.get(object);
        if (cachedRealmObject != null) {
            return (MessageOperationCacheObject)cachedRealmObject;
        }
        MessageOperationCacheObjectRealmProxy realmObject = null;
        boolean canUpdate = update;
        if (canUpdate) {
            Table table = realm.getTable(MessageOperationCacheObject.class);
            MessageOperationCacheObjectColumnInfo columnInfo = (MessageOperationCacheObjectColumnInfo)realm.getSchema().getColumnInfo(MessageOperationCacheObject.class);
            long pkColumnIndex = columnInfo.operationIDIndex;
            String value = ((MessageOperationCacheObjectRealmProxyInterface)object).realmGet$operationID();
            long rowIndex = -1L;
            rowIndex = value == null ? table.findFirstNull(pkColumnIndex) : table.findFirstString(pkColumnIndex, value);
            if (rowIndex == -1L) {
                canUpdate = false;
            } else {
                try {
                    objectContext.set((BaseRealm)realm, (Row)table.getUncheckedRow(rowIndex), realm.getSchema().getColumnInfo(MessageOperationCacheObject.class), false, Collections.emptyList());
                    realmObject = new MessageOperationCacheObjectRealmProxy();
                    cache.put((RealmModel)object, realmObject);
                }
                finally {
                    objectContext.clear();
                }
            }
        }
        return canUpdate ? MessageOperationCacheObjectRealmProxy.update(realm, realmObject, object, cache) : MessageOperationCacheObjectRealmProxy.copy(realm, object, update, cache);
    }

    public static MessageOperationCacheObject copy(Realm realm, MessageOperationCacheObject newObject, boolean update, Map<RealmModel, RealmObjectProxy> cache) {
        RealmObjectProxy cachedRealmObject = cache.get(newObject);
        if (cachedRealmObject != null) {
            return (MessageOperationCacheObject)cachedRealmObject;
        }
        MessageOperationCacheObject realmObject = (MessageOperationCacheObject)realm.createObjectInternal(MessageOperationCacheObject.class, (Object)((MessageOperationCacheObjectRealmProxyInterface)newObject).realmGet$operationID(), false, Collections.emptyList());
        cache.put((RealmModel)newObject, (RealmObjectProxy)realmObject);
        MessageOperationCacheObjectRealmProxyInterface realmObjectSource = newObject;
        MessageOperationCacheObjectRealmProxyInterface realmObjectCopy = realmObject;
        realmObjectCopy.realmSet$messageID(realmObjectSource.realmGet$messageID());
        realmObjectCopy.realmSet$conversationID(realmObjectSource.realmGet$conversationID());
        realmObjectCopy.realmSet$type(realmObjectSource.realmGet$type());
        realmObjectCopy.realmSet$status(realmObjectSource.realmGet$status());
        realmObjectCopy.realmSet$sendDate(realmObjectSource.realmGet$sendDate());
        realmObjectCopy.realmSet$jsonData(realmObjectSource.realmGet$jsonData());
        realmObjectCopy.realmSet$errorData(realmObjectSource.realmGet$errorData());
        return realmObject;
    }

    public static long insert(Realm realm, MessageOperationCacheObject object, Map<RealmModel, Long> cache) {
        String realmGet$errorData;
        String realmGet$jsonData;
        Date realmGet$sendDate;
        String realmGet$status;
        String realmGet$type;
        String realmGet$conversationID;
        if (object instanceof RealmObjectProxy && ((RealmObjectProxy)object).realmGet$proxyState().getRealm$realm() != null && ((RealmObjectProxy)object).realmGet$proxyState().getRealm$realm().getPath().equals(realm.getPath())) {
            return ((RealmObjectProxy)object).realmGet$proxyState().getRow$realm().getIndex();
        }
        Table table = realm.getTable(MessageOperationCacheObject.class);
        long tableNativePtr = table.getNativePtr();
        MessageOperationCacheObjectColumnInfo columnInfo = (MessageOperationCacheObjectColumnInfo)realm.getSchema().getColumnInfo(MessageOperationCacheObject.class);
        long pkColumnIndex = columnInfo.operationIDIndex;
        String primaryKeyValue = ((MessageOperationCacheObjectRealmProxyInterface)object).realmGet$operationID();
        long rowIndex = -1L;
        rowIndex = primaryKeyValue == null ? Table.nativeFindFirstNull((long)tableNativePtr, (long)pkColumnIndex) : Table.nativeFindFirstString((long)tableNativePtr, (long)pkColumnIndex, (String)primaryKeyValue);
        if (rowIndex == -1L) {
            rowIndex = OsObject.createRowWithPrimaryKey((Table)table, (long)pkColumnIndex, (Object)primaryKeyValue);
        } else {
            Table.throwDuplicatePrimaryKeyException((Object)primaryKeyValue);
        }
        cache.put((RealmModel)object, rowIndex);
        String realmGet$messageID = ((MessageOperationCacheObjectRealmProxyInterface)object).realmGet$messageID();
        if (realmGet$messageID != null) {
            Table.nativeSetString((long)tableNativePtr, (long)columnInfo.messageIDIndex, (long)rowIndex, (String)realmGet$messageID, (boolean)false);
        }
        if ((realmGet$conversationID = ((MessageOperationCacheObjectRealmProxyInterface)object).realmGet$conversationID()) != null) {
            Table.nativeSetString((long)tableNativePtr, (long)columnInfo.conversationIDIndex, (long)rowIndex, (String)realmGet$conversationID, (boolean)false);
        }
        if ((realmGet$type = ((MessageOperationCacheObjectRealmProxyInterface)object).realmGet$type()) != null) {
            Table.nativeSetString((long)tableNativePtr, (long)columnInfo.typeIndex, (long)rowIndex, (String)realmGet$type, (boolean)false);
        }
        if ((realmGet$status = ((MessageOperationCacheObjectRealmProxyInterface)object).realmGet$status()) != null) {
            Table.nativeSetString((long)tableNativePtr, (long)columnInfo.statusIndex, (long)rowIndex, (String)realmGet$status, (boolean)false);
        }
        if ((realmGet$sendDate = ((MessageOperationCacheObjectRealmProxyInterface)object).realmGet$sendDate()) != null) {
            Table.nativeSetTimestamp((long)tableNativePtr, (long)columnInfo.sendDateIndex, (long)rowIndex, (long)realmGet$sendDate.getTime(), (boolean)false);
        }
        if ((realmGet$jsonData = ((MessageOperationCacheObjectRealmProxyInterface)object).realmGet$jsonData()) != null) {
            Table.nativeSetString((long)tableNativePtr, (long)columnInfo.jsonDataIndex, (long)rowIndex, (String)realmGet$jsonData, (boolean)false);
        }
        if ((realmGet$errorData = ((MessageOperationCacheObjectRealmProxyInterface)object).realmGet$errorData()) != null) {
            Table.nativeSetString((long)tableNativePtr, (long)columnInfo.errorDataIndex, (long)rowIndex, (String)realmGet$errorData, (boolean)false);
        }
        return rowIndex;
    }

    public static void insert(Realm realm, Iterator<? extends RealmModel> objects, Map<RealmModel, Long> cache) {
        Table table = realm.getTable(MessageOperationCacheObject.class);
        long tableNativePtr = table.getNativePtr();
        MessageOperationCacheObjectColumnInfo columnInfo = (MessageOperationCacheObjectColumnInfo)realm.getSchema().getColumnInfo(MessageOperationCacheObject.class);
        long pkColumnIndex = columnInfo.operationIDIndex;
        MessageOperationCacheObject object = null;
        while (objects.hasNext()) {
            String realmGet$errorData;
            String realmGet$jsonData;
            Date realmGet$sendDate;
            String realmGet$status;
            String realmGet$type;
            String realmGet$conversationID;
            object = (MessageOperationCacheObject)objects.next();
            if (cache.containsKey(object)) continue;
            if (object instanceof RealmObjectProxy && ((RealmObjectProxy)object).realmGet$proxyState().getRealm$realm() != null && ((RealmObjectProxy)object).realmGet$proxyState().getRealm$realm().getPath().equals(realm.getPath())) {
                cache.put((RealmModel)object, ((RealmObjectProxy)object).realmGet$proxyState().getRow$realm().getIndex());
                continue;
            }
            String primaryKeyValue = ((MessageOperationCacheObjectRealmProxyInterface)object).realmGet$operationID();
            long rowIndex = -1L;
            rowIndex = primaryKeyValue == null ? Table.nativeFindFirstNull((long)tableNativePtr, (long)pkColumnIndex) : Table.nativeFindFirstString((long)tableNativePtr, (long)pkColumnIndex, (String)primaryKeyValue);
            if (rowIndex == -1L) {
                rowIndex = OsObject.createRowWithPrimaryKey((Table)table, (long)pkColumnIndex, (Object)primaryKeyValue);
            } else {
                Table.throwDuplicatePrimaryKeyException((Object)primaryKeyValue);
            }
            cache.put((RealmModel)object, rowIndex);
            String realmGet$messageID = ((MessageOperationCacheObjectRealmProxyInterface)object).realmGet$messageID();
            if (realmGet$messageID != null) {
                Table.nativeSetString((long)tableNativePtr, (long)columnInfo.messageIDIndex, (long)rowIndex, (String)realmGet$messageID, (boolean)false);
            }
            if ((realmGet$conversationID = ((MessageOperationCacheObjectRealmProxyInterface)object).realmGet$conversationID()) != null) {
                Table.nativeSetString((long)tableNativePtr, (long)columnInfo.conversationIDIndex, (long)rowIndex, (String)realmGet$conversationID, (boolean)false);
            }
            if ((realmGet$type = ((MessageOperationCacheObjectRealmProxyInterface)object).realmGet$type()) != null) {
                Table.nativeSetString((long)tableNativePtr, (long)columnInfo.typeIndex, (long)rowIndex, (String)realmGet$type, (boolean)false);
            }
            if ((realmGet$status = ((MessageOperationCacheObjectRealmProxyInterface)object).realmGet$status()) != null) {
                Table.nativeSetString((long)tableNativePtr, (long)columnInfo.statusIndex, (long)rowIndex, (String)realmGet$status, (boolean)false);
            }
            if ((realmGet$sendDate = ((MessageOperationCacheObjectRealmProxyInterface)object).realmGet$sendDate()) != null) {
                Table.nativeSetTimestamp((long)tableNativePtr, (long)columnInfo.sendDateIndex, (long)rowIndex, (long)realmGet$sendDate.getTime(), (boolean)false);
            }
            if ((realmGet$jsonData = ((MessageOperationCacheObjectRealmProxyInterface)object).realmGet$jsonData()) != null) {
                Table.nativeSetString((long)tableNativePtr, (long)columnInfo.jsonDataIndex, (long)rowIndex, (String)realmGet$jsonData, (boolean)false);
            }
            if ((realmGet$errorData = ((MessageOperationCacheObjectRealmProxyInterface)object).realmGet$errorData()) == null) continue;
            Table.nativeSetString((long)tableNativePtr, (long)columnInfo.errorDataIndex, (long)rowIndex, (String)realmGet$errorData, (boolean)false);
        }
    }

    public static long insertOrUpdate(Realm realm, MessageOperationCacheObject object, Map<RealmModel, Long> cache) {
        if (object instanceof RealmObjectProxy && ((RealmObjectProxy)object).realmGet$proxyState().getRealm$realm() != null && ((RealmObjectProxy)object).realmGet$proxyState().getRealm$realm().getPath().equals(realm.getPath())) {
            return ((RealmObjectProxy)object).realmGet$proxyState().getRow$realm().getIndex();
        }
        Table table = realm.getTable(MessageOperationCacheObject.class);
        long tableNativePtr = table.getNativePtr();
        MessageOperationCacheObjectColumnInfo columnInfo = (MessageOperationCacheObjectColumnInfo)realm.getSchema().getColumnInfo(MessageOperationCacheObject.class);
        long pkColumnIndex = columnInfo.operationIDIndex;
        String primaryKeyValue = ((MessageOperationCacheObjectRealmProxyInterface)object).realmGet$operationID();
        long rowIndex = -1L;
        rowIndex = primaryKeyValue == null ? Table.nativeFindFirstNull((long)tableNativePtr, (long)pkColumnIndex) : Table.nativeFindFirstString((long)tableNativePtr, (long)pkColumnIndex, (String)primaryKeyValue);
        if (rowIndex == -1L) {
            rowIndex = OsObject.createRowWithPrimaryKey((Table)table, (long)pkColumnIndex, (Object)primaryKeyValue);
        }
        cache.put((RealmModel)object, rowIndex);
        String realmGet$messageID = ((MessageOperationCacheObjectRealmProxyInterface)object).realmGet$messageID();
        if (realmGet$messageID != null) {
            Table.nativeSetString((long)tableNativePtr, (long)columnInfo.messageIDIndex, (long)rowIndex, (String)realmGet$messageID, (boolean)false);
        } else {
            Table.nativeSetNull((long)tableNativePtr, (long)columnInfo.messageIDIndex, (long)rowIndex, (boolean)false);
        }
        String realmGet$conversationID = ((MessageOperationCacheObjectRealmProxyInterface)object).realmGet$conversationID();
        if (realmGet$conversationID != null) {
            Table.nativeSetString((long)tableNativePtr, (long)columnInfo.conversationIDIndex, (long)rowIndex, (String)realmGet$conversationID, (boolean)false);
        } else {
            Table.nativeSetNull((long)tableNativePtr, (long)columnInfo.conversationIDIndex, (long)rowIndex, (boolean)false);
        }
        String realmGet$type = ((MessageOperationCacheObjectRealmProxyInterface)object).realmGet$type();
        if (realmGet$type != null) {
            Table.nativeSetString((long)tableNativePtr, (long)columnInfo.typeIndex, (long)rowIndex, (String)realmGet$type, (boolean)false);
        } else {
            Table.nativeSetNull((long)tableNativePtr, (long)columnInfo.typeIndex, (long)rowIndex, (boolean)false);
        }
        String realmGet$status = ((MessageOperationCacheObjectRealmProxyInterface)object).realmGet$status();
        if (realmGet$status != null) {
            Table.nativeSetString((long)tableNativePtr, (long)columnInfo.statusIndex, (long)rowIndex, (String)realmGet$status, (boolean)false);
        } else {
            Table.nativeSetNull((long)tableNativePtr, (long)columnInfo.statusIndex, (long)rowIndex, (boolean)false);
        }
        Date realmGet$sendDate = ((MessageOperationCacheObjectRealmProxyInterface)object).realmGet$sendDate();
        if (realmGet$sendDate != null) {
            Table.nativeSetTimestamp((long)tableNativePtr, (long)columnInfo.sendDateIndex, (long)rowIndex, (long)realmGet$sendDate.getTime(), (boolean)false);
        } else {
            Table.nativeSetNull((long)tableNativePtr, (long)columnInfo.sendDateIndex, (long)rowIndex, (boolean)false);
        }
        String realmGet$jsonData = ((MessageOperationCacheObjectRealmProxyInterface)object).realmGet$jsonData();
        if (realmGet$jsonData != null) {
            Table.nativeSetString((long)tableNativePtr, (long)columnInfo.jsonDataIndex, (long)rowIndex, (String)realmGet$jsonData, (boolean)false);
        } else {
            Table.nativeSetNull((long)tableNativePtr, (long)columnInfo.jsonDataIndex, (long)rowIndex, (boolean)false);
        }
        String realmGet$errorData = ((MessageOperationCacheObjectRealmProxyInterface)object).realmGet$errorData();
        if (realmGet$errorData != null) {
            Table.nativeSetString((long)tableNativePtr, (long)columnInfo.errorDataIndex, (long)rowIndex, (String)realmGet$errorData, (boolean)false);
        } else {
            Table.nativeSetNull((long)tableNativePtr, (long)columnInfo.errorDataIndex, (long)rowIndex, (boolean)false);
        }
        return rowIndex;
    }

    public static void insertOrUpdate(Realm realm, Iterator<? extends RealmModel> objects, Map<RealmModel, Long> cache) {
        Table table = realm.getTable(MessageOperationCacheObject.class);
        long tableNativePtr = table.getNativePtr();
        MessageOperationCacheObjectColumnInfo columnInfo = (MessageOperationCacheObjectColumnInfo)realm.getSchema().getColumnInfo(MessageOperationCacheObject.class);
        long pkColumnIndex = columnInfo.operationIDIndex;
        MessageOperationCacheObject object = null;
        while (objects.hasNext()) {
            object = (MessageOperationCacheObject)objects.next();
            if (cache.containsKey(object)) continue;
            if (object instanceof RealmObjectProxy && ((RealmObjectProxy)object).realmGet$proxyState().getRealm$realm() != null && ((RealmObjectProxy)object).realmGet$proxyState().getRealm$realm().getPath().equals(realm.getPath())) {
                cache.put((RealmModel)object, ((RealmObjectProxy)object).realmGet$proxyState().getRow$realm().getIndex());
                continue;
            }
            String primaryKeyValue = ((MessageOperationCacheObjectRealmProxyInterface)object).realmGet$operationID();
            long rowIndex = -1L;
            rowIndex = primaryKeyValue == null ? Table.nativeFindFirstNull((long)tableNativePtr, (long)pkColumnIndex) : Table.nativeFindFirstString((long)tableNativePtr, (long)pkColumnIndex, (String)primaryKeyValue);
            if (rowIndex == -1L) {
                rowIndex = OsObject.createRowWithPrimaryKey((Table)table, (long)pkColumnIndex, (Object)primaryKeyValue);
            }
            cache.put((RealmModel)object, rowIndex);
            String realmGet$messageID = ((MessageOperationCacheObjectRealmProxyInterface)object).realmGet$messageID();
            if (realmGet$messageID != null) {
                Table.nativeSetString((long)tableNativePtr, (long)columnInfo.messageIDIndex, (long)rowIndex, (String)realmGet$messageID, (boolean)false);
            } else {
                Table.nativeSetNull((long)tableNativePtr, (long)columnInfo.messageIDIndex, (long)rowIndex, (boolean)false);
            }
            String realmGet$conversationID = ((MessageOperationCacheObjectRealmProxyInterface)object).realmGet$conversationID();
            if (realmGet$conversationID != null) {
                Table.nativeSetString((long)tableNativePtr, (long)columnInfo.conversationIDIndex, (long)rowIndex, (String)realmGet$conversationID, (boolean)false);
            } else {
                Table.nativeSetNull((long)tableNativePtr, (long)columnInfo.conversationIDIndex, (long)rowIndex, (boolean)false);
            }
            String realmGet$type = ((MessageOperationCacheObjectRealmProxyInterface)object).realmGet$type();
            if (realmGet$type != null) {
                Table.nativeSetString((long)tableNativePtr, (long)columnInfo.typeIndex, (long)rowIndex, (String)realmGet$type, (boolean)false);
            } else {
                Table.nativeSetNull((long)tableNativePtr, (long)columnInfo.typeIndex, (long)rowIndex, (boolean)false);
            }
            String realmGet$status = ((MessageOperationCacheObjectRealmProxyInterface)object).realmGet$status();
            if (realmGet$status != null) {
                Table.nativeSetString((long)tableNativePtr, (long)columnInfo.statusIndex, (long)rowIndex, (String)realmGet$status, (boolean)false);
            } else {
                Table.nativeSetNull((long)tableNativePtr, (long)columnInfo.statusIndex, (long)rowIndex, (boolean)false);
            }
            Date realmGet$sendDate = ((MessageOperationCacheObjectRealmProxyInterface)object).realmGet$sendDate();
            if (realmGet$sendDate != null) {
                Table.nativeSetTimestamp((long)tableNativePtr, (long)columnInfo.sendDateIndex, (long)rowIndex, (long)realmGet$sendDate.getTime(), (boolean)false);
            } else {
                Table.nativeSetNull((long)tableNativePtr, (long)columnInfo.sendDateIndex, (long)rowIndex, (boolean)false);
            }
            String realmGet$jsonData = ((MessageOperationCacheObjectRealmProxyInterface)object).realmGet$jsonData();
            if (realmGet$jsonData != null) {
                Table.nativeSetString((long)tableNativePtr, (long)columnInfo.jsonDataIndex, (long)rowIndex, (String)realmGet$jsonData, (boolean)false);
            } else {
                Table.nativeSetNull((long)tableNativePtr, (long)columnInfo.jsonDataIndex, (long)rowIndex, (boolean)false);
            }
            String realmGet$errorData = ((MessageOperationCacheObjectRealmProxyInterface)object).realmGet$errorData();
            if (realmGet$errorData != null) {
                Table.nativeSetString((long)tableNativePtr, (long)columnInfo.errorDataIndex, (long)rowIndex, (String)realmGet$errorData, (boolean)false);
                continue;
            }
            Table.nativeSetNull((long)tableNativePtr, (long)columnInfo.errorDataIndex, (long)rowIndex, (boolean)false);
        }
    }

    public static MessageOperationCacheObject createDetachedCopy(MessageOperationCacheObject realmObject, int currentDepth, int maxDepth, Map<RealmModel, RealmObjectProxy.CacheData<RealmModel>> cache) {
        MessageOperationCacheObject unmanagedObject;
        if (currentDepth > maxDepth || realmObject == null) {
            return null;
        }
        RealmObjectProxy.CacheData<RealmModel> cachedObject = cache.get(realmObject);
        if (cachedObject == null) {
            unmanagedObject = new MessageOperationCacheObject();
            cache.put((RealmModel)realmObject, (RealmObjectProxy.CacheData<RealmModel>)new RealmObjectProxy.CacheData(currentDepth, (RealmModel)unmanagedObject));
        } else {
            if (currentDepth >= cachedObject.minDepth) {
                return (MessageOperationCacheObject)cachedObject.object;
            }
            unmanagedObject = (MessageOperationCacheObject)cachedObject.object;
            cachedObject.minDepth = currentDepth;
        }
        MessageOperationCacheObjectRealmProxyInterface unmanagedCopy = unmanagedObject;
        MessageOperationCacheObjectRealmProxyInterface realmSource = realmObject;
        unmanagedCopy.realmSet$operationID(realmSource.realmGet$operationID());
        unmanagedCopy.realmSet$messageID(realmSource.realmGet$messageID());
        unmanagedCopy.realmSet$conversationID(realmSource.realmGet$conversationID());
        unmanagedCopy.realmSet$type(realmSource.realmGet$type());
        unmanagedCopy.realmSet$status(realmSource.realmGet$status());
        unmanagedCopy.realmSet$sendDate(realmSource.realmGet$sendDate());
        unmanagedCopy.realmSet$jsonData(realmSource.realmGet$jsonData());
        unmanagedCopy.realmSet$errorData(realmSource.realmGet$errorData());
        return unmanagedObject;
    }

    static MessageOperationCacheObject update(Realm realm, MessageOperationCacheObject realmObject, MessageOperationCacheObject newObject, Map<RealmModel, RealmObjectProxy> cache) {
        MessageOperationCacheObjectRealmProxyInterface realmObjectTarget = realmObject;
        MessageOperationCacheObjectRealmProxyInterface realmObjectSource = newObject;
        realmObjectTarget.realmSet$messageID(realmObjectSource.realmGet$messageID());
        realmObjectTarget.realmSet$conversationID(realmObjectSource.realmGet$conversationID());
        realmObjectTarget.realmSet$type(realmObjectSource.realmGet$type());
        realmObjectTarget.realmSet$status(realmObjectSource.realmGet$status());
        realmObjectTarget.realmSet$sendDate(realmObjectSource.realmGet$sendDate());
        realmObjectTarget.realmSet$jsonData(realmObjectSource.realmGet$jsonData());
        realmObjectTarget.realmSet$errorData(realmObjectSource.realmGet$errorData());
        return realmObject;
    }

    public String toString() {
        if (!RealmObject.isValid((RealmModel)this)) {
            return "Invalid object";
        }
        StringBuilder stringBuilder = new StringBuilder("MessageOperationCacheObject = proxy[");
        stringBuilder.append("{operationID:");
        stringBuilder.append(this.realmGet$operationID() != null ? this.realmGet$operationID() : "null");
        stringBuilder.append("}");
        stringBuilder.append(",");
        stringBuilder.append("{messageID:");
        stringBuilder.append(this.realmGet$messageID() != null ? this.realmGet$messageID() : "null");
        stringBuilder.append("}");
        stringBuilder.append(",");
        stringBuilder.append("{conversationID:");
        stringBuilder.append(this.realmGet$conversationID() != null ? this.realmGet$conversationID() : "null");
        stringBuilder.append("}");
        stringBuilder.append(",");
        stringBuilder.append("{type:");
        stringBuilder.append(this.realmGet$type() != null ? this.realmGet$type() : "null");
        stringBuilder.append("}");
        stringBuilder.append(",");
        stringBuilder.append("{status:");
        stringBuilder.append(this.realmGet$status() != null ? this.realmGet$status() : "null");
        stringBuilder.append("}");
        stringBuilder.append(",");
        stringBuilder.append("{sendDate:");
        stringBuilder.append(this.realmGet$sendDate() != null ? this.realmGet$sendDate() : "null");
        stringBuilder.append("}");
        stringBuilder.append(",");
        stringBuilder.append("{jsonData:");
        stringBuilder.append(this.realmGet$jsonData() != null ? this.realmGet$jsonData() : "null");
        stringBuilder.append("}");
        stringBuilder.append(",");
        stringBuilder.append("{errorData:");
        stringBuilder.append(this.realmGet$errorData() != null ? this.realmGet$errorData() : "null");
        stringBuilder.append("}");
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public ProxyState<?> realmGet$proxyState() {
        return this.proxyState;
    }

    public int hashCode() {
        String realmName = this.proxyState.getRealm$realm().getPath();
        String tableName = this.proxyState.getRow$realm().getTable().getName();
        long rowIndex = this.proxyState.getRow$realm().getIndex();
        int result = 17;
        result = 31 * result + (realmName != null ? realmName.hashCode() : 0);
        result = 31 * result + (tableName != null ? tableName.hashCode() : 0);
        result = 31 * result + (int)(rowIndex ^ rowIndex >>> 32);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MessageOperationCacheObjectRealmProxy aMessageOperationCacheObject = (MessageOperationCacheObjectRealmProxy)o;
        String path = this.proxyState.getRealm$realm().getPath();
        String otherPath = aMessageOperationCacheObject.proxyState.getRealm$realm().getPath();
        if (path != null ? !path.equals(otherPath) : otherPath != null) {
            return false;
        }
        String tableName = this.proxyState.getRow$realm().getTable().getName();
        String otherTableName = aMessageOperationCacheObject.proxyState.getRow$realm().getTable().getName();
        if (tableName != null ? !tableName.equals(otherTableName) : otherTableName != null) {
            return false;
        }
        return this.proxyState.getRow$realm().getIndex() == aMessageOperationCacheObject.proxyState.getRow$realm().getIndex();
    }

    static {
        ArrayList<String> fieldNames = new ArrayList<String>(8);
        fieldNames.add("operationID");
        fieldNames.add("messageID");
        fieldNames.add("conversationID");
        fieldNames.add("type");
        fieldNames.add("status");
        fieldNames.add("sendDate");
        fieldNames.add("jsonData");
        fieldNames.add("errorData");
        FIELD_NAMES = Collections.unmodifiableList(fieldNames);
    }

    static final class MessageOperationCacheObjectColumnInfo
    extends ColumnInfo {
        long operationIDIndex;
        long messageIDIndex;
        long conversationIDIndex;
        long typeIndex;
        long statusIndex;
        long sendDateIndex;
        long jsonDataIndex;
        long errorDataIndex;

        MessageOperationCacheObjectColumnInfo(OsSchemaInfo schemaInfo) {
            super(8);
            OsObjectSchemaInfo objectSchemaInfo = schemaInfo.getObjectSchemaInfo("MessageOperationCacheObject");
            this.operationIDIndex = this.addColumnDetails("operationID", objectSchemaInfo);
            this.messageIDIndex = this.addColumnDetails("messageID", objectSchemaInfo);
            this.conversationIDIndex = this.addColumnDetails("conversationID", objectSchemaInfo);
            this.typeIndex = this.addColumnDetails("type", objectSchemaInfo);
            this.statusIndex = this.addColumnDetails("status", objectSchemaInfo);
            this.sendDateIndex = this.addColumnDetails("sendDate", objectSchemaInfo);
            this.jsonDataIndex = this.addColumnDetails("jsonData", objectSchemaInfo);
            this.errorDataIndex = this.addColumnDetails("errorData", objectSchemaInfo);
        }

        MessageOperationCacheObjectColumnInfo(ColumnInfo src, boolean mutable) {
            super(src, mutable);
            this.copy(src, this);
        }

        protected final ColumnInfo copy(boolean mutable) {
            return new MessageOperationCacheObjectColumnInfo(this, mutable);
        }

        protected final void copy(ColumnInfo rawSrc, ColumnInfo rawDst) {
            MessageOperationCacheObjectColumnInfo src = (MessageOperationCacheObjectColumnInfo)rawSrc;
            MessageOperationCacheObjectColumnInfo dst = (MessageOperationCacheObjectColumnInfo)rawDst;
            dst.operationIDIndex = src.operationIDIndex;
            dst.messageIDIndex = src.messageIDIndex;
            dst.conversationIDIndex = src.conversationIDIndex;
            dst.typeIndex = src.typeIndex;
            dst.statusIndex = src.statusIndex;
            dst.sendDateIndex = src.sendDateIndex;
            dst.jsonDataIndex = src.jsonDataIndex;
            dst.errorDataIndex = src.errorDataIndex;
        }
    }
}

