/*
 * Decompiled with CFR 0.152.
 */
package io.skygear.plugins.chat;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.util.Date;

public class Typing {
    private final String userId;
    private final State state;
    private final Date time;

    public Typing(@NonNull String userId, @NonNull State state, @Nullable Date time) {
        this.userId = userId;
        this.state = state;
        this.time = time == null ? new Date() : time;
    }

    public String getUserId() {
        return this.userId;
    }

    public State getState() {
        return this.state;
    }

    public Date getTime() {
        return this.time;
    }

    public static enum State {
        BEGIN("begin"),
        PAUSE("pause"),
        FINISHED("finished");

        private final String name;

        private State(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        static State fromName(String name) {
            State[] states;
            for (State eachState : states = State.values()) {
                if (!eachState.getName().equals(name)) continue;
                return eachState;
            }
            throw new IllegalArgumentException(String.format("Unknown typing state: %s", name));
        }
    }
}

