/*
 * Decompiled with CFR 0.152.
 */
package io.skygear.plugins.chat;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import io.skygear.plugins.chat.SubscriptionCallback;
import io.skygear.skygear.PubsubContainer;
import io.skygear.skygear.PubsubHandler;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

final class Subscription {
    private static final String TAG = "SkygearChatSubscription";
    private final String conversationId;
    private final String channel;
    private final PubsubHandler handler;
    private final Map<String, SubscriptionCallback> callbackMap;

    Subscription(@NonNull String conversationId, @NonNull String channel, @Nullable SubscriptionCallback callback) {
        this.conversationId = conversationId;
        this.channel = channel;
        this.callbackMap = new HashMap<String, SubscriptionCallback>();
        this.addCallBack(callback);
        this.handler = new PubsubHandler(){

            public void handle(JSONObject data) {
                if (data != null) {
                    Subscription.this.handleEvent(data);
                }
            }
        };
    }

    void addCallBack(@Nullable SubscriptionCallback callback) {
        String[] eventTypes;
        if (callback == null) {
            return;
        }
        for (String eachEventType : eventTypes = callback.supportingEventTypes()) {
            this.callbackMap.put(eachEventType, callback);
        }
    }

    void attach(PubsubContainer pubsub) {
        pubsub.subscribe(this.channel, this.handler);
    }

    void detach(PubsubContainer pubsub) {
        pubsub.unsubscribe(this.channel, this.handler);
    }

    void handleEvent(JSONObject data) {
        String eventName = data.optString("event");
        if (eventName != null) {
            JSONObject eventData = data.optJSONObject("data");
            SubscriptionCallback callback = this.callbackMap.get(eventName);
            if (callback != null) {
                callback.notify(eventName, eventData);
            }
        }
    }
}

