/*
 * Decompiled with CFR 0.152.
 */
package io.skygear.plugins.chat;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import io.skygear.plugins.chat.Conversation;
import io.skygear.plugins.chat.Message;
import io.skygear.plugins.chat.SubscriptionCallback;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class MessageSubscriptionCallback
implements SubscriptionCallback {
    public static final String EVENT_TYPE_CREATE = "create";
    public static final String EVENT_TYPE_UPDATE = "update";
    public static final String EVENT_TYPE_DELETE = "delete";
    static final String[] SUPPORTED_EVENT_TYPES = new String[]{"create", "update", "delete"};
    private static final String TAG = "SkygearChatSubscription";
    private final String conversationId;

    public MessageSubscriptionCallback(@NonNull Conversation conversation) {
        this.conversationId = conversation.getId();
    }

    @Override
    @NonNull
    public String[] supportingEventTypes() {
        return SUPPORTED_EVENT_TYPES;
    }

    @Override
    public void notify(String eventType, @Nullable JSONObject data) {
        if (data == null) {
            return;
        }
        String dataType = data.optString("type");
        if (!"record".equals(dataType)) {
            Log.w((String)TAG, (String)"Received non-record event. Ignore it.");
            return;
        }
        String recordType = data.optString("record_type");
        JSONObject recordData = data.optJSONObject("record");
        if (!"message".equals(recordType)) {
            return;
        }
        Message message = null;
        if (recordData != null) {
            try {
                message = Message.fromJson(recordData);
            }
            catch (JSONException e) {
                Log.w((String)TAG, (String)"Fail parsing message payload", (Throwable)e);
            }
        }
        if (message != null && message.getConversationId().equals(this.conversationId)) {
            this.notify(eventType, message);
        }
    }

    public abstract void notify(@NonNull String var1, @NonNull Message var2);
}

