/*
 * Decompiled with CFR 0.152.
 */
package io.skygear.plugins.chat;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import io.realm.RealmQuery;
import io.skygear.plugins.chat.Conversation;
import io.skygear.plugins.chat.GetCallback;
import io.skygear.plugins.chat.Message;
import io.skygear.plugins.chat.MessageCacheObject;
import io.skygear.plugins.chat.RealmStore;
import io.skygear.plugins.chat.SaveCallback;
import io.skygear.skygear.Error;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

class CacheController {
    private static CacheController sharedInstance;
    RealmStore store;

    static CacheController getInstance() {
        if (sharedInstance == null) {
            RealmStore store = new RealmStore("SKYChatCache", false);
            sharedInstance = new CacheController(store);
        }
        return sharedInstance;
    }

    CacheController(RealmStore store) {
        this.store = store;
    }

    void getMessages(final @NonNull Conversation conversation, int limit, final @Nullable Date before, @Nullable String order, final @Nullable GetCallback<List<Message>> callback) {
        RealmStore.QueryBuilder<MessageCacheObject> queryBuilder = new RealmStore.QueryBuilder<MessageCacheObject>(){

            @Override
            public RealmQuery<MessageCacheObject> buildQueryFrom(RealmQuery<MessageCacheObject> baseQuery) {
                RealmQuery query = baseQuery.equalTo(MessageCacheObject.KEY_CONVERSATION_ID, conversation.getId()).equalTo(MessageCacheObject.KEY_DELETED, Boolean.valueOf(false)).beginGroup().beginGroup().equalTo(MessageCacheObject.KEY_ALREADY_SYNC_TO_SERVER, Boolean.valueOf(true)).equalTo(MessageCacheObject.KEY_FAIL, Boolean.valueOf(false)).endGroup().or().isNull(MessageCacheObject.KEY_SEND_DATE).endGroup();
                if (before != null) {
                    query.lessThan(MessageCacheObject.KEY_CREATION_DATE, before);
                }
                return query;
            }
        };
        String resolvedOrder = order;
        resolvedOrder = resolvedOrder != null && resolvedOrder.equalsIgnoreCase("edited_at") ? MessageCacheObject.KEY_EDITION_DATE : MessageCacheObject.KEY_CREATION_DATE;
        if (callback != null) {
            this.store.getMessages(queryBuilder, limit, resolvedOrder, new RealmStore.ResultCallback<Message[]>(){

                @Override
                public void onResultGet(Message[] messages) {
                    callback.onSucc(Arrays.asList(messages));
                }
            });
        }
    }

    void didGetMessages(Message[] messages, Message[] deletedMessages) {
        this.store.setMessages(messages);
        this.store.setMessages(deletedMessages);
    }

    void saveMessage(Message message, @Nullable SaveCallback<Message> callback) {
        this.store.setMessages(new Message[]{message});
        if (callback != null) {
            callback.onSucc(message);
        }
    }

    void didSaveMessage(Message message, @Nullable Error error) {
        if (error != null) {
            message.alreadySyncToServer = false;
            message.fail = true;
        } else {
            message.alreadySyncToServer = true;
            message.fail = false;
        }
        this.store.setMessages(new Message[]{message});
    }

    void didDeleteMessage(Message message) {
        this.store.setMessages(new Message[]{message});
    }

    void handleMessageChange(Message message, String eventType) {
        if (eventType.equals("create")) {
            this.didSaveMessage(message, null);
        }
        if (eventType.equals("update")) {
            this.didSaveMessage(message, null);
        }
        if (eventType.equals("delete")) {
            this.didDeleteMessage(message);
        }
    }

    void getUnsentMessages(final Conversation conversation, final GetCallback<List<Message>> callback) {
        RealmStore.QueryBuilder<MessageCacheObject> queryBuilder = new RealmStore.QueryBuilder<MessageCacheObject>(){

            @Override
            public RealmQuery<MessageCacheObject> buildQueryFrom(RealmQuery<MessageCacheObject> baseQuery) {
                RealmQuery query = baseQuery.equalTo(MessageCacheObject.KEY_CONVERSATION_ID, conversation.getId()).isNotNull(MessageCacheObject.KEY_SEND_DATE).beginGroup().equalTo(MessageCacheObject.KEY_ALREADY_SYNC_TO_SERVER, Boolean.valueOf(false)).or().equalTo(MessageCacheObject.KEY_FAIL, Boolean.valueOf(true)).endGroup();
                return query;
            }
        };
        if (callback != null) {
            this.store.getMessages(queryBuilder, -1, "creationDate", new RealmStore.ResultCallback<Message[]>(){

                @Override
                public void onResultGet(Message[] messages) {
                    callback.onSucc(Arrays.asList(messages));
                }
            });
        }
    }
}

