/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.map.binary.sourcemapper;

import io.siddhi.annotation.Example;
import io.siddhi.annotation.Extension;
import io.siddhi.core.config.SiddhiAppContext;
import io.siddhi.core.event.Event;
import io.siddhi.core.exception.MappingFailedException;
import io.siddhi.core.exception.SiddhiAppCreationException;
import io.siddhi.core.stream.input.source.AttributeMapping;
import io.siddhi.core.stream.input.source.InputEventHandler;
import io.siddhi.core.stream.input.source.SourceMapper;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.core.util.error.handler.model.ErroneousEvent;
import io.siddhi.core.util.transport.OptionHolder;
import io.siddhi.extension.map.binary.sourcemapper.SiddhiEventConverter;
import io.siddhi.extension.map.binary.utils.EventDefinitionConverterUtil;
import io.siddhi.query.api.definition.Attribute;
import io.siddhi.query.api.definition.StreamDefinition;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

@Extension(name="binary", namespace="sourceMapper", description="This extension is a binary input mapper that converts events received in `binary` format to Siddhi events before they are processed.", examples={@Example(syntax="@source(type='inMemory', topic='WSO2', @map(type='binary'))define stream FooStream (symbol string, price float, volume long); ", description="This query performs a mapping to convert an event of the `binary` format to a Siddhi event. ")})
public class BinarySourceMapper
extends SourceMapper {
    private Attribute.Type[] types;
    private StreamDefinition streamDefinition;

    public void init(StreamDefinition streamDefinition, OptionHolder optionHolder, List<AttributeMapping> attributeMappings, ConfigReader configReader, SiddhiAppContext siddhiAppContext) {
        this.types = EventDefinitionConverterUtil.generateAttributeTypeArray(streamDefinition.getAttributeList());
        if (attributeMappings != null && attributeMappings.size() > 0) {
            throw new SiddhiAppCreationException("'binary' source-mapper does not support custom mapping, but found at stream '" + streamDefinition.getId() + "'");
        }
        this.streamDefinition = streamDefinition;
    }

    protected void mapAndProcess(Object o, InputEventHandler inputEventHandler) throws InterruptedException, MappingFailedException {
        ArrayList<ErroneousEvent> failedEvents = new ArrayList<ErroneousEvent>(0);
        try {
            if (o != null) {
                Event[] events = o instanceof ByteBuffer ? SiddhiEventConverter.toConvertToSiddhiEvents((ByteBuffer)o, this.types) : SiddhiEventConverter.toConvertToSiddhiEvents(ByteBuffer.wrap((byte[])o), this.types);
                inputEventHandler.sendEvents(events);
            }
        }
        catch (Throwable t) {
            String errStr = "Error at binary source mapper of '" + this.streamDefinition.getId() + "' " + t.getMessage();
            SiddhiEventConverter.LOG.error(errStr, t);
            failedEvents.add(new ErroneousEvent(o, t, errStr));
        }
        if (!failedEvents.isEmpty()) {
            throw new MappingFailedException(failedEvents);
        }
    }

    protected boolean allowNullInTransportProperties() {
        return false;
    }

    public Class[] getSupportedInputEventClasses() {
        return new Class[]{ByteBuffer.class, byte[].class};
    }
}

