/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.map.binary.sinkmapper;

import io.siddhi.annotation.Example;
import io.siddhi.annotation.Extension;
import io.siddhi.core.config.SiddhiAppContext;
import io.siddhi.core.event.Event;
import io.siddhi.core.exception.SiddhiAppCreationException;
import io.siddhi.core.stream.output.sink.SinkListener;
import io.siddhi.core.stream.output.sink.SinkMapper;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.core.util.transport.OptionHolder;
import io.siddhi.core.util.transport.TemplateBuilder;
import io.siddhi.extension.map.binary.sinkmapper.BinaryEventConverter;
import io.siddhi.extension.map.binary.utils.EventDefinitionConverterUtil;
import io.siddhi.query.api.definition.Attribute;
import io.siddhi.query.api.definition.StreamDefinition;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Map;
import org.apache.log4j.Logger;

@Extension(name="binary", namespace="sinkMapper", description="This section explains how to map events processed via Siddhi in order to publish them in the `binary` format.", examples={@Example(syntax="@sink(type='inMemory', topic='WSO2', @map(type='binary')) define stream FooStream (symbol string, price float, volume long); ", description="This will publish Siddhi event in binary format.")})
public class BinarySinkMapper
extends SinkMapper {
    private static final Logger LOG = Logger.getLogger(BinarySinkMapper.class);
    private StreamDefinition streamDefinition;
    private Attribute.Type[] types;

    public void init(StreamDefinition streamDefinition, OptionHolder optionHolder, Map<String, TemplateBuilder> payloadTemplateBuilderMap, ConfigReader configReader, SiddhiAppContext siddhiAppContext) {
        this.streamDefinition = streamDefinition;
        this.types = EventDefinitionConverterUtil.generateAttributeTypeArray(streamDefinition.getAttributeList());
        if (payloadTemplateBuilderMap != null) {
            throw new SiddhiAppCreationException("Binary sink-mapper does not support @payload mapping, error at the mapper of '" + streamDefinition.getId() + "'");
        }
    }

    public String[] getSupportedDynamicOptions() {
        return new String[0];
    }

    public Class[] getOutputEventClasses() {
        return new Class[]{ByteBuffer.class};
    }

    public void mapAndSend(Event[] events, OptionHolder optionHolder, Map<String, TemplateBuilder> payloadTemplateBuilderMap, SinkListener sinkListener) {
        try {
            sinkListener.publish((Object)BinaryEventConverter.convertToBinaryMessage(events, this.types));
        }
        catch (Throwable e) {
            LOG.error((Object)("Error in converting event '" + Arrays.deepToString(events) + "' to binary format at binary SinkMapper of " + this.streamDefinition.getId()), e);
        }
    }

    public void mapAndSend(Event event, OptionHolder optionHolder, Map<String, TemplateBuilder> payloadTemplateBuilderMap, SinkListener sinkListener) {
        this.mapAndSend(new Event[]{event}, optionHolder, payloadTemplateBuilderMap, sinkListener);
    }
}

