/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.map.binary.sourcemapper;

import io.siddhi.core.event.Event;
import io.siddhi.core.exception.MappingFailedException;
import io.siddhi.extension.map.binary.utils.BinaryMessageConverterUtil;
import io.siddhi.query.api.definition.Attribute;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import org.apache.log4j.Logger;

public class SiddhiEventConverter {
    static final Logger LOG = Logger.getLogger(SiddhiEventConverter.class);

    public static Event[] toConvertToSiddhiEvents(ByteBuffer messageBuffer, Attribute.Type[] attributeTypes) throws MappingFailedException {
        try {
            int numberOfEvents = messageBuffer.getInt();
            Event[] events = new Event[numberOfEvents];
            for (int i = 0; i < numberOfEvents; ++i) {
                events[i] = SiddhiEventConverter.getEvent(messageBuffer, attributeTypes);
            }
            return events;
        }
        catch (UnsupportedEncodingException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            throw new MappingFailedException((Throwable)e);
        }
    }

    static Event getEvent(ByteBuffer byteBuffer, Attribute.Type[] attributeTypes) throws UnsupportedEncodingException {
        Event event = new Event();
        long timeStamp = byteBuffer.getLong();
        event.setTimestamp(timeStamp);
        event.setData(SiddhiEventConverter.toObjectArray(byteBuffer, attributeTypes));
        return event;
    }

    static Object[] toObjectArray(ByteBuffer byteBuffer, Attribute.Type[] attributeTypeOrder) throws UnsupportedEncodingException {
        if (attributeTypeOrder != null) {
            Object[] objects = new Object[attributeTypeOrder.length];
            block8: for (int i = 0; i < attributeTypeOrder.length; ++i) {
                switch (attributeTypeOrder[i]) {
                    case INT: {
                        objects[i] = byteBuffer.getInt();
                        continue block8;
                    }
                    case LONG: {
                        objects[i] = byteBuffer.getLong();
                        continue block8;
                    }
                    case STRING: {
                        int stringSize = byteBuffer.getInt();
                        if (stringSize == 0) {
                            objects[i] = null;
                            continue block8;
                        }
                        objects[i] = BinaryMessageConverterUtil.getString(byteBuffer, stringSize);
                        continue block8;
                    }
                    case DOUBLE: {
                        objects[i] = byteBuffer.getDouble();
                        continue block8;
                    }
                    case FLOAT: {
                        objects[i] = Float.valueOf(byteBuffer.getFloat());
                        continue block8;
                    }
                    case BOOL: {
                        objects[i] = byteBuffer.get() == 1;
                        continue block8;
                    }
                }
            }
            return objects;
        }
        return null;
    }
}

