/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.map.binary.sinkmapper;

import io.siddhi.core.event.Event;
import io.siddhi.extension.map.binary.utils.BinaryMessageConverterUtil;
import io.siddhi.query.api.definition.Attribute;
import java.io.IOException;
import java.nio.ByteBuffer;

public class BinaryEventConverter {
    public static ByteBuffer convertToBinaryMessage(Event[] events, Attribute.Type[] types) throws IOException {
        int eventCount = events.length;
        int messageSize = 4;
        for (Event event : events) {
            messageSize += BinaryEventConverter.getEventSize(event, types);
        }
        ByteBuffer messageBuffer = ByteBuffer.wrap(new byte[messageSize]);
        messageBuffer.putInt(eventCount);
        for (Event event : events) {
            messageBuffer.putLong(event.getTimestamp());
            if (event.getData() == null || event.getData().length == 0) continue;
            Object[] data = event.getData();
            for (int i = 0; i < data.length; ++i) {
                Object aData = data[i];
                BinaryMessageConverterUtil.assignData(aData, messageBuffer, types[i]);
            }
        }
        return messageBuffer;
    }

    private static int getEventSize(Event event, Attribute.Type[] types) {
        int eventSize = 8;
        Object[] data = event.getData();
        if (data != null) {
            for (int i = 0; i < data.length; ++i) {
                Object aData = data[i];
                eventSize += BinaryMessageConverterUtil.getSize(aData, types[i]);
            }
        }
        return eventSize;
    }
}

