/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.map.binary.utils;

import io.siddhi.query.api.definition.Attribute;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

public final class BinaryMessageConverterUtil {
    private BinaryMessageConverterUtil() {
    }

    public static byte[] loadData(InputStream in, byte[] dataArray) throws IOException {
        int readCount;
        int start = 0;
        while ((readCount = in.read(dataArray, start, dataArray.length - start)) != -1) {
            if ((start += readCount) != dataArray.length) continue;
            return dataArray;
        }
        throw new EOFException("Connection closed from remote end.");
    }

    public static String getString(ByteBuffer byteBuffer, int size) throws UnsupportedEncodingException {
        byte[] bytes = new byte[size];
        byteBuffer.get(bytes);
        return new String(bytes, Charset.defaultCharset());
    }

    public static int getSize(Object data, Attribute.Type type) {
        switch (type) {
            case STRING: {
                return 4 + ((String)data).length();
            }
            case INT: {
                return 4;
            }
            case LONG: {
                return 8;
            }
            case FLOAT: {
                return 4;
            }
            case DOUBLE: {
                return 8;
            }
            case BOOL: {
                return 1;
            }
        }
        return 4;
    }

    public static void assignData(Object data, ByteBuffer eventDataBuffer, Attribute.Type type) throws IOException {
        switch (type) {
            case STRING: {
                eventDataBuffer.putInt(((String)data).length());
                eventDataBuffer.put(((String)data).getBytes(Charset.defaultCharset()));
                break;
            }
            case INT: {
                eventDataBuffer.putInt((Integer)data);
                break;
            }
            case LONG: {
                eventDataBuffer.putLong((Long)data);
                break;
            }
            case FLOAT: {
                eventDataBuffer.putFloat(((Float)data).floatValue());
                break;
            }
            case DOUBLE: {
                eventDataBuffer.putDouble((Double)data);
                break;
            }
            case BOOL: {
                eventDataBuffer.put((byte)((Boolean)data != false ? 1 : 0));
                break;
            }
            case OBJECT: {
                eventDataBuffer.putInt(0);
            }
        }
    }
}

